/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.client;

import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.book.LavenderBookItem;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BookBakedModel
extends ForwardingBakedModel {
    private final ItemOverrides overrides = new ItemOverrides(this){

        @Nullable
        public BakedModel resolve(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            Book book = LavenderBookItem.bookOf(stack);
            if (book == null || book.dynamicBookModel() == null) {
                return model;
            }
            BakedModel bookModel = Minecraft.getInstance().getModelManager().getModel(new ModelResourceLocation(book.dynamicBookModel(), "inventory"));
            return bookModel != Minecraft.getInstance().getModelManager().getMissingModel() ? bookModel : model;
        }
    };

    private BookBakedModel(BakedModel parent) {
        this.wrapped = parent;
    }

    public ItemOverrides getOverrides() {
        return this.overrides;
    }

    public static class Unbaked
    implements UnbakedModel {
        public static final ResourceLocation BROWN_BOOK_ID = Lavender.id("item/brown_book");

        public Collection<ResourceLocation> getDependencies() {
            return List.of(BROWN_BOOK_ID);
        }

        @Nullable
        public BakedModel bake(ModelBaker baker, Function<Material, TextureAtlasSprite> textureGetter, ModelState rotationContainer) {
            return new BookBakedModel(baker.bake(BROWN_BOOK_ID, rotationContainer));
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelLoader) {
        }
    }
}

