/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.book.BookContentLoader;
import io.wispforest.lavender.client.BookBakedModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public class BookLoader {
    private static final Gson GSON = new GsonBuilder().setLenient().disableHtmlEscaping().create();
    private static final TypeToken<Map<String, String>> MACROS_TOKEN = new TypeToken<Map<String, String>>(){};
    private static final FileToIdConverter BOOK_FINDER = FileToIdConverter.json((String)"lavender/books");
    private static final Map<ResourceLocation, Book> LOADED_BOOKS = new HashMap<ResourceLocation, Book>();
    private static final Map<ResourceLocation, Book> VISIBLE_BOOKS = new HashMap<ResourceLocation, Book>();

    public static void initialize() {
        ModelLoadingPlugin.register(context -> {
            context.addModels(new ResourceLocation[]{BookBakedModel.Unbaked.BROWN_BOOK_ID});
            for (Book book : VISIBLE_BOOKS.values()) {
                if (book.dynamicBookModel() == null) {
                    return;
                }
                context.addModels(new ResourceLocation[]{book.dynamicBookModel()});
            }
        });
    }

    @Nullable
    public static Book get(ResourceLocation bookId) {
        return LOADED_BOOKS.get(bookId);
    }

    public static Collection<Book> loadedBooks() {
        return Collections.unmodifiableCollection(VISIBLE_BOOKS.values());
    }

    static Collection<Book> allBooks() {
        return Collections.unmodifiableCollection(LOADED_BOOKS.values());
    }

    public static void reload(ResourceManager manager) {
        LOADED_BOOKS.clear();
        BOOK_FINDER.listMatchingResources(manager).forEach((identifier, resource) -> {
            ResourceLocation openSoundId;
            JsonElement jsonElement;
            try (BufferedReader reader = resource.openAsReader();){
                jsonElement = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
            }
            catch (IOException e) {
                Lavender.LOGGER.warn("Could not load book '{}'", identifier, (Object)e);
                return;
            }
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject bookObject = jsonElement.getAsJsonObject();
            ResourceLocation resourceId = BOOK_FINDER.fileToId(identifier);
            ResourceLocation textureId = BookLoader.tryGetId(bookObject, "texture");
            ResourceLocation extendId = BookLoader.tryGetId(bookObject, "extend");
            ResourceLocation dynamicBookModelId = BookLoader.tryGetId(bookObject, "dynamic_book_model");
            Component dynamicBookName = null;
            if (bookObject.has("dynamic_book_name")) {
                dynamicBookName = (Component)ComponentSerialization.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)bookObject.get("dynamic_book_name")).getOrThrow(JsonParseException::new);
            }
            SoundEvent openSoundEvent = (openSoundId = BookLoader.tryGetId(bookObject, "open_sound")) != null ? (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(openSoundId) : null;
            ResourceLocation flippingSoundId = BookLoader.tryGetId(bookObject, "flipping_sound");
            SoundEvent flippingSoundEvent = flippingSoundId != null ? (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(flippingSoundId) : null;
            ResourceLocation introEntryId = BookLoader.tryGetId(bookObject, "intro_entry");
            boolean displayCompletion = GsonHelper.getAsBoolean((JsonObject)bookObject, (String)"display_completion", (boolean)false);
            boolean displayUnreadEntryNotifications = GsonHelper.getAsBoolean((JsonObject)bookObject, (String)"display_unread_entry_notifications", (boolean)true);
            Map macros = (Map)GSON.fromJson((JsonElement)GsonHelper.getAsJsonObject((JsonObject)bookObject, (String)"macros", (JsonObject)new JsonObject()), MACROS_TOKEN);
            Book.ToastSettings newEntriesToast = null;
            if (bookObject.has("new_entries_toast")) {
                JsonObject toastObject = bookObject.getAsJsonObject("new_entries_toast");
                ResourceLocation backgroundSprite = null;
                if (toastObject.has("background_sprite")) {
                    backgroundSprite = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)toastObject, (String)"background_sprite"));
                }
                newEntriesToast = new Book.ToastSettings(BookContentLoader.itemStackFromString(GsonHelper.getAsString((JsonObject)toastObject, (String)"icon_stack")), (Component)ComponentSerialization.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)toastObject.get("book_name")).getOrThrow(JsonParseException::new), backgroundSprite);
            }
            Book book = new Book(resourceId, extendId, textureId, dynamicBookModelId, dynamicBookName, openSoundEvent, flippingSoundEvent, introEntryId, displayUnreadEntryNotifications, displayCompletion, newEntriesToast, macros);
            LOADED_BOOKS.put(resourceId, book);
            if (extendId == null) {
                VISIBLE_BOOKS.put(resourceId, book);
            }
        });
        LOADED_BOOKS.values().removeIf(book -> {
            if (book.tryResolveExtension()) {
                return false;
            }
            Lavender.LOGGER.warn("Book '" + String.valueOf(book.id()) + "' (an extension) failed to load because its target was not found");
            return true;
        });
    }

    @Nullable
    private static ResourceLocation tryGetId(JsonObject json, String key) {
        String jsonString = GsonHelper.getAsString((JsonObject)json, (String)key, null);
        if (jsonString == null) {
            return null;
        }
        return ResourceLocation.tryParse((String)jsonString);
    }
}

