/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DynamicOps;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.book.BookLoader;
import io.wispforest.lavender.book.LavenderBookItem;
import io.wispforest.lavender.client.StructureOverlayRenderer;
import io.wispforest.lavender.structure.LavenderStructures;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class LavenderCommands {
    private static final SimpleCommandExceptionType NO_SUCH_BOOK = new SimpleCommandExceptionType((Message)Component.literal((String)"No such book is loaded"));
    private static final SuggestionProvider<FabricClientCommandSource> LOADED_BOOKS = (context, builder) -> SharedSuggestionProvider.suggestResource(BookLoader.loadedBooks().stream().map(Book::id), (SuggestionsBuilder)builder);

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        private static final SimpleCommandExceptionType NO_SUCH_STRUCTURE = new SimpleCommandExceptionType((Message)Component.literal((String)"No such structure is loaded"));
        private static final SuggestionProvider<FabricClientCommandSource> STRUCTURE_INFO = (context, builder) -> SharedSuggestionProvider.suggest(LavenderStructures.loadedStructures().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);

        private static int executeGetLavenderBook(CommandContext<FabricClientCommandSource> context, boolean forceDynamicBook) throws CommandSyntaxException {
            Book book = BookLoader.get((ResourceLocation)context.getArgument("book_id", ResourceLocation.class));
            if (book == null) {
                throw NO_SUCH_BOOK.create();
            }
            ItemStack stack = forceDynamicBook ? LavenderBookItem.createDynamic(book) : LavenderBookItem.itemOf(book);
            String command = "/give @s " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()));
            RegistryOps ops = ((FabricClientCommandSource)context.getSource()).getWorld().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            String components = stack.getComponentsPatch().entrySet().stream().flatMap(entry -> {
                DataComponentType componentType = (DataComponentType)entry.getKey();
                ResourceLocation typeId = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)componentType);
                if (typeId == null) {
                    return Stream.empty();
                }
                Optional componentOptional = (Optional)entry.getValue();
                if (componentOptional.isPresent()) {
                    TypedDataComponent component = TypedDataComponent.createUnchecked((DataComponentType)componentType, componentOptional.get());
                    return component.encodeValue((DynamicOps)ops).result().stream().map(value -> String.valueOf(typeId) + "=" + String.valueOf(value));
                }
                return Stream.of("!" + String.valueOf(typeId));
            }).collect(Collectors.joining(String.valueOf(',')));
            if (!components.isEmpty()) {
                command = command + "[" + components + "]";
            }
            if (stack.getCount() > 1) {
                command = command + " " + stack.getCount();
            }
            String jAvAsE = command;
            ((FabricClientCommandSource)context.getSource()).getClient().tell(() -> ((FabricClientCommandSource)context.getSource()).getClient().setScreen((Screen)new ChatScreen(jAvAsE)));
            return 0;
        }

        public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, CommandBuildContext access) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"get-lavender-book").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"book_id", (ArgumentType)ResourceLocationArgument.id()).suggests(LOADED_BOOKS).executes(context -> Client.executeGetLavenderBook((CommandContext<FabricClientCommandSource>)context, false))).then(ClientCommandManager.argument((String)"force_dynamic_book", (ArgumentType)BoolArgumentType.bool()).executes(context -> Client.executeGetLavenderBook((CommandContext<FabricClientCommandSource>)context, BoolArgumentType.getBool((CommandContext)context, (String)"force_dynamic_book"))))));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"structure-overlay").then(ClientCommandManager.literal((String)"clear-all").executes(context -> {
                StructureOverlayRenderer.clearOverlays();
                return 0;
            }))).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"structure", (ArgumentType)ResourceLocationArgument.id()).suggests(STRUCTURE_INFO).executes(context -> {
                ResourceLocation structureId = (ResourceLocation)context.getArgument("structure", ResourceLocation.class);
                if (LavenderStructures.get(structureId) == null) {
                    throw NO_SUCH_STRUCTURE.create();
                }
                StructureOverlayRenderer.addPendingOverlay(structureId);
                return 0;
            }))));
        }
    }
}

