/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender;

import com.mojang.logging.LogUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.BuiltInEndecs;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.lavender.book.LavenderBookItem;
import io.wispforest.owo.serialization.CodecUtils;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class Lavender
implements ModInitializer {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MOD_ID = "lavender";
    public static final SoundEvent ITEM_BOOK_OPEN = SoundEvent.createVariableRangeEvent((ResourceLocation)Lavender.id("item.book.open"));

    public void onInitialize() {
        Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)Lavender.id("dynamic_book"), (Object)((Object)LavenderBookItem.DYNAMIC_BOOK));
        Registry.register((Registry)BuiltInRegistries.SOUND_EVENT, (ResourceLocation)ITEM_BOOK_OPEN.getLocation(), (Object)ITEM_BOOK_OPEN);
        PayloadTypeRegistry.playS2C().register(WorldUUIDPayload.ID, CodecUtils.toPacketCodec(WorldUUIDPayload.ENDEC));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> sender.sendPacket((CustomPacketPayload)new WorldUUIDPayload(((WorldUUIDState)server.overworld().getDataStorage().computeIfAbsent(WorldUUIDState.TYPE, (String)"lavender_world_id")).id)));
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public record WorldUUIDPayload(UUID worldUuid) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<WorldUUIDPayload> ID = new CustomPacketPayload.Type(Lavender.id("world_uuid"));
        public static final Endec<WorldUUIDPayload> ENDEC = StructEndecBuilder.of((StructField)BuiltInEndecs.UUID.fieldOf("world_uuid", WorldUUIDPayload::worldUuid), WorldUUIDPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    public static class WorldUUIDState
    extends SavedData {
        public static final SavedData.Factory<WorldUUIDState> TYPE = new SavedData.Factory(() -> {
            WorldUUIDState state = new WorldUUIDState(UUID.randomUUID());
            state.setDirty();
            return state;
        }, WorldUUIDState::read, DataFixTypes.LEVEL);
        public final UUID id;

        private WorldUUIDState(UUID id) {
            this.id = id;
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registryLookup) {
            nbt.putUUID("UUID", this.id);
            return nbt;
        }

        public static WorldUUIDState read(CompoundTag nbt, HolderLookup.Provider lookup) {
            return new WorldUUIDState(nbt.contains("UUID", 11) ? nbt.getUUID("UUID") : null);
        }
    }
}

