/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.mixin;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.common.entity.pose.TuffGolemEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.StrongholdPieces;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StrongholdPieces.Library.class})
public abstract class StrongholdGeneratorMixin
extends StructurePiece {
    private boolean isTuffGolemGenerated = false;

    protected StrongholdGeneratorMixin(StructurePieceType type, int length, BoundingBox boundingBox) {
        super(type, length, boundingBox);
    }

    @Inject(at={@At(value="TAIL")}, method={"postProcess"})
    private void friendsandfoes_generate(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot, CallbackInfo ci) {
        if (!FriendsAndFoes.getConfig().generateTuffGolemInStronghold || this.isTuffGolemGenerated || random.nextFloat() > 0.75f) {
            return;
        }
        ServerLevel serverWorld = world.getLevel();
        TuffGolemEntity tuffGolem = (TuffGolemEntity)((EntityType)FriendsAndFoesEntityTypes.TUFF_GOLEM.get()).create((Level)serverWorld);
        if (tuffGolem == null) {
            return;
        }
        ArrayList<Tuple> possibleSpawnPositions = new ArrayList<Tuple>();
        for (int x = 5; x < 8; x += 3) {
            for (int y = 4; y < 12; y += 2) {
                possibleSpawnPositions.add(new Tuple((Object)x, (Object)y));
            }
        }
        Tuple pickedXYPair = (Tuple)possibleSpawnPositions.get(random.nextIntBetweenInclusive(0, possibleSpawnPositions.size() - 1));
        BlockPos.MutableBlockPos tuffGolemPos = this.getWorldPos((Integer)pickedXYPair.getA(), 1, (Integer)pickedXYPair.getB());
        tuffGolem.setPos((float)tuffGolemPos.getX() + 0.5f, tuffGolemPos.getY(), (float)tuffGolemPos.getZ() + 0.5f);
        float randomSpawnYaw = 90.0f * (float)random.nextIntBetweenInclusive(0, 3);
        tuffGolem.setSpawnYaw(randomSpawnYaw);
        ItemStack enchantedBook = Items.ENCHANTED_BOOK.getDefaultInstance();
        enchantedBook.setCount(1);
        enchantedBook.set(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        EnchantmentHelper.enchantItemFromProvider((ItemStack)enchantedBook, (RegistryAccess)serverWorld.registryAccess(), (ResourceKey)VanillaEnchantmentProviders.MOB_SPAWN_EQUIPMENT, (DifficultyInstance)new DifficultyInstance(serverWorld.getDifficulty(), 0L, 0L, 0.0f), (RandomSource)random);
        tuffGolem.setItemSlot(EquipmentSlot.MAINHAND, enchantedBook);
        tuffGolem.setPrevPose(TuffGolemEntityPose.STANDING_WITH_ITEM.get());
        tuffGolem.setPoseWithoutPrevPose(TuffGolemEntityPose.SLEEPING_WITH_ITEM.get());
        boolean isTuffGolemSpawned = world.addFreshEntity((Entity)tuffGolem);
        if (isTuffGolemSpawned) {
            this.isTuffGolemGenerated = true;
        }
    }
}

