/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.createframed.registry;

import com.simibubi.create.content.decoration.palettes.ConnectedGlassPaneBlock;
import com.simibubi.create.content.decoration.palettes.WindowBlock;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.HorizontalCTBehaviour;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Supplier;
import net.createmod.catnip.lang.Lang;
import net.dakotapride.createframed.CreateFramedMod;
import net.dakotapride.createframed.registry.CreateFramedBuilderTransformers;
import net.dakotapride.createframed.registry.CreateFramedSpriteShifts;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public enum CreateFramedWindows {
    COPPER(() -> CreateFramedSpriteShifts.COPPER_WINDOW, Blocks.COPPER_BLOCK, true),
    ZINC(() -> CreateFramedSpriteShifts.ZINC_WINDOW, Blocks.GLOW_LICHEN, true),
    ANDESITE_ALLOY(() -> CreateFramedSpriteShifts.ANDESITE_ALLOY_WINDOW, Blocks.ANDESITE, true),
    ROSE_QUARTZ(() -> CreateFramedSpriteShifts.ROSE_QUARTZ_WINDOW, Blocks.RED_TERRACOTTA, false),
    BRASS(() -> CreateFramedSpriteShifts.BRASS_WINDOW, Blocks.YELLOW_TERRACOTTA, true),
    CARDBOARD(() -> CreateFramedSpriteShifts.CARDBOARD_WINDOW, Blocks.WHITE_TERRACOTTA, true);

    private final ResourceLocation id;
    public final BlockEntry<WindowBlock> window_block;
    public final BlockEntry<ConnectedGlassPaneBlock> window_pane;

    private CreateFramedWindows(Supplier<CTSpriteShiftEntry> ctshift, Block template_block, boolean cutout) {
        String name = Lang.asId((String)this.name());
        this.id = CreateFramedMod.asResource(name);
        if (!cutout) {
            this.window_block = CreateFramedBuilderTransformers.roseQuartzWindowBlock(name, () -> new HorizontalCTBehaviour((CTSpriteShiftEntry)ctshift.get()), template_block);
            this.window_pane = CreateFramedBuilderTransformers.roseQuartzWindowPaneBlock(name, ctshift, () -> ((Block)template_block).defaultMapColor());
        } else {
            this.window_block = CreateFramedBuilderTransformers.windowBlock(name, () -> new HorizontalCTBehaviour((CTSpriteShiftEntry)ctshift.get()), template_block);
            this.window_pane = CreateFramedBuilderTransformers.windowPaneBlock(name, ctshift, () -> ((Block)template_block).defaultMapColor());
        }
    }

    public BlockEntry<WindowBlock> getWindowBlock() {
        return this.window_block;
    }

    public BlockEntry<ConnectedGlassPaneBlock> getWindowPaneBlock() {
        return this.window_pane;
    }

    public static void register() {
    }
}

