/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.piglin.Piglin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Shadow
    public abstract void loadEffect(ResourceLocation var1);

    @Inject(method={"checkEntityPostEffect(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="TAIL")})
    protected void supp$addCustomPostShaders(Entity entity, CallbackInfo ci) {
        Rabbit e;
        if (entity != null && entity.getType() == EntityType.ENDER_DRAGON) {
            this.loadEffect(ClientRegistry.FLARE_SHADER);
        } else if (entity instanceof AbstractSkeleton) {
            this.loadEffect(ClientRegistry.BLACK_AND_WHITE_SHADER);
        } else if (entity instanceof Zombie) {
            this.loadEffect(ClientRegistry.DESATURATE_SHADER);
        } else if (entity instanceof Rabbit && (e = (Rabbit)entity).getVariant() == Rabbit.Variant.EVIL) {
            this.loadEffect(ClientRegistry.RAGE_SHADER);
        } else if (entity instanceof Piglin) {
            this.loadEffect(ClientRegistry.GLITTER_SHADER);
        } else if (entity instanceof WitherBoss) {
            this.loadEffect(ClientRegistry.BLACK_AND_WHITE_SHADER);
        }
    }
}

