/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.events.overrides;

import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.common.events.overrides.ItemUseOnBlockBehavior;
import net.mehvahdjukaar.supplementaries.common.items.JarItem;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModDamageSources;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;

class XPBottlingBehavior
implements ItemUseOnBlockBehavior {
    XPBottlingBehavior() {
    }

    @Override
    public boolean isEnabled() {
        return CommonConfigs.Tweaks.BOTTLE_XP.get();
    }

    @Override
    public boolean appliesToItem(Item item) {
        return item == Items.GLASS_BOTTLE || item instanceof JarItem || item == Items.EXPERIENCE_BOTTLE;
    }

    @Override
    public InteractionResult tryPerformingAction(Level world, Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
        BlockPos pos = hit.getBlockPos();
        Item i = stack.getItem();
        if (CommonConfigs.xpBottlingOverride.test(world.getBlockState(pos).getBlock())) {
            ItemStack returnStack = null;
            if (i == Items.EXPERIENCE_BOTTLE) {
                return InteractionResult.FAIL;
            }
            if (player.experienceLevel > 0 || player.isCreative()) {
                if (i == Items.GLASS_BOTTLE) {
                    returnStack = new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE);
                } else if (i instanceof JarItem) {
                    ItemStack tempStack;
                    ItemStack temp;
                    JarBlockTile dummyTile = new JarBlockTile(BlockPos.ZERO, ModRegistry.JAR.get().defaultBlockState());
                    dummyTile.clearAllContents();
                    BlockUtil.loadTileFromItem((BlockEntity)dummyTile, stack);
                    if (dummyTile.canInteractWithSoftFluidTank() && (temp = dummyTile.fluidHolder.interactWithItem(tempStack = new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE), null, null, false)) != null && temp.getItem() == Items.GLASS_BOTTLE) {
                        returnStack = BlockUtil.saveTileToItem((BlockEntity)dummyTile);
                    }
                }
                if (returnStack != null) {
                    player.hurt(ModDamageSources.bottling(world), (float)CommonConfigs.Tweaks.BOTTLING_COST.get().intValue());
                    Utils.swapItem((Player)player, (InteractionHand)hand, (ItemStack)returnStack);
                    if (!player.isCreative()) {
                        player.giveExperiencePoints(-Utils.getXPinaBottle((int)1, (RandomSource)world.random) - 3);
                    }
                    if (world.isClientSide) {
                        Minecraft.getInstance().particleEngine.createTrackingEmitter((Entity)player, (ParticleOptions)ModParticles.BOTTLING_XP_PARTICLE.get(), 1);
                    }
                    world.playSound(null, player.blockPosition(), SoundEvents.BOTTLE_FILL_DRAGONBREATH, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.sidedSuccess((boolean)world.isClientSide);
                }
            }
        }
        return InteractionResult.PASS;
    }
}

