/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.MimicBlockTile;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.client.screens.SignPostScreen;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StickBlock;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FramedBlocksCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SignPostBlockTile
extends MimicBlockTile
implements ITextHolderProvider,
IScreenProvider {
    public static final ModelDataKey<Boolean> FRAMED_KEY = ModBlockProperties.FRAMED;
    public static final ModelDataKey<Float> RENDER_OFFSET_KEY = ModBlockProperties.RENDER_OFFSET;
    public static final ModelDataKey<Sign> SIGN_UP_KEY = ModBlockProperties.SIGN_UP;
    public static final ModelDataKey<Sign> SIGN_DOWN_KEY = ModBlockProperties.SIGN_DOWN;
    private final Sign signUp = new Sign(false, true, 0.0f, WoodTypeRegistry.OAK_TYPE);
    private final Sign signDown = new Sign(false, false, 0.0f, WoodTypeRegistry.OAK_TYPE);
    private boolean isWaxed = false;
    private float zRenderOffset = 0.0f;
    private boolean framed = false;
    @Nullable
    private UUID playerWhoMayEdit;

    public SignPostBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.WAY_SIGN_TILE.get(), pos, state);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        super.addExtraModelData(builder);
        builder.with(FRAMED_KEY, (Object)this.framed).with(SIGN_UP_KEY, (Object)this.signUp).with(SIGN_DOWN_KEY, (Object)this.signDown).with(RENDER_OFFSET_KEY, (Object)Float.valueOf(this.zRenderOffset));
    }

    @Override
    public TextHolder getTextHolder(int i) {
        return this.getSign((boolean)(i == 0 ? true : false)).text;
    }

    @Override
    public TextHolder getTextHolderAt(Vec3 hit) {
        return this.getClickedSign((Vec3)hit).text;
    }

    @Override
    public int textHoldersCount() {
        return 2;
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.getBlockPos();
        return new AABB((double)pos.getX() - 0.25, (double)pos.getY(), (double)pos.getZ() - 0.25, (double)pos.getX() + 1.25, (double)pos.getY() + 1.0, (double)pos.getZ() + 1.25);
    }

    public float getPointingYaw(boolean up) {
        if (up) {
            return this.signUp.getPointing();
        }
        return this.signDown.getPointing();
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        Rotation rot;
        BlockState state;
        super.loadAdditional(tag, registries);
        this.framed = tag.getBoolean("Framed");
        this.signUp.load(tag.getCompound("SignUp"), registries, this.worldPosition);
        this.signDown.load(tag.getCompound("SignDown"), registries, this.worldPosition);
        if (tag.contains("Waxed")) {
            this.isWaxed = tag.getBoolean("Waxed");
        }
        if (this.level != null && this.level.isClientSide) {
            this.requestModelReload();
        }
        if ((state = this.getBlockState()).hasProperty(ModBlockProperties.ROTATE_TILE) && (rot = (Rotation)state.getValue(ModBlockProperties.ROTATE_TILE)) != Rotation.NONE) {
            this.rotateSign(false, rot.ordinal() * 90, false);
            this.rotateSign(true, rot.ordinal() * 90, false);
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue(ModBlockProperties.ROTATE_TILE, (Comparable)Rotation.NONE));
        }
    }

    public boolean setHeldBlock(BlockState state, int index) {
        Block b = state.getBlock();
        this.zRenderOffset = b instanceof StickBlock ? 0.5625f : (b == Blocks.AIR ? 0.0f : 0.625f);
        return super.setHeldBlock(state, index);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.mimic.isAir()) {
            tag.remove("Mimic");
        }
        tag.putBoolean("Framed", this.framed);
        tag.put("SignUp", (Tag)this.signUp.save(registries));
        tag.put("SignDown", (Tag)this.signDown.save(registries));
        if (this.isWaxed) {
            tag.putBoolean("Waxed", this.isWaxed);
        }
    }

    public boolean rotateSign(boolean up, float angle, boolean constrainAngle) {
        if (up && this.signUp.active) {
            this.signUp.rotateBy(angle, constrainAngle);
            return true;
        }
        if (this.signDown.active) {
            this.signDown.rotateBy(angle, constrainAngle);
            return true;
        }
        return false;
    }

    public void openScreen(Level level, BlockPos pos, Player player, Direction direction) {
        SignPostScreen.open(this);
    }

    public float getOffset() {
        return this.zRenderOffset;
    }

    public Sign getSignUp() {
        return this.signUp;
    }

    public Sign getSignDown() {
        return this.signDown;
    }

    public Sign getSign(boolean up) {
        return up ? this.getSignUp() : this.getSignDown();
    }

    public boolean isFramed() {
        return this.framed;
    }

    public boolean trySetSign(WoodType woodType, int r, boolean up, boolean framed) {
        Sign sign = this.getSign(up);
        if (!sign.active) {
            sign.active = true;
            sign.woodType = woodType;
            sign.yaw = this.getBlockState().hasProperty((Property)HorizontalDirectionalBlock.FACING) ? 90.0f - ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).toYRot() : 90.0f + (float)r * -22.5f;
            this.framed = framed;
            return true;
        }
        return false;
    }

    public ItemInteractionResult handleInteraction(BlockState state, ServerLevel level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, ItemStack itemstack) {
        Item item = itemstack.getItem();
        boolean emptyHand = itemstack.isEmpty();
        boolean isSneaking = player.isShiftKeyDown() && emptyHand;
        boolean ind = this.getClickedSignIndex(hit.getLocation());
        if (hit.getDirection().getAxis() != Direction.Axis.Y) {
            boolean success;
            Sign sign = this.getSign(ind);
            if (!sign.active && item instanceof SignPostItem) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (isSneaking) {
                sign.toggleDirection();
                this.setChanged();
                level.sendBlockUpdated(pos, state, state, 3);
                level.playSound(null, pos, ModSounds.BLOCK_ROTATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.CONSUME;
            }
            if (item instanceof CompassItem && !state.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
                BlockPos pointingPos = SignPostBlockTile.getCompassTrackedPos(level, itemstack);
                if (pointingPos != null) {
                    if (sign.active) {
                        sign.pointToward(pos, pointingPos);
                    }
                    this.setChanged();
                    level.sendBlockUpdated(pos, state, state, 3);
                    return ItemInteractionResult.CONSUME;
                }
                return ItemInteractionResult.FAIL;
            }
            if (CompatHandler.FRAMEDBLOCKS && this.framed && (success = FramedBlocksCompat.interactWithFramedSignPost(this, player, handIn, itemstack, (Level)level, pos))) {
                return ItemInteractionResult.CONSUME;
            }
        }
        return this.textHolderInteract(ind ? 0 : 1, (Level)level, pos, state, player, handIn, itemstack);
    }

    private static BlockPos getCompassTrackedPos(ServerLevel level, ItemStack itemstack) {
        LodestoneTracker tracker = (LodestoneTracker)itemstack.get(DataComponents.LODESTONE_TRACKER);
        if (tracker != null && tracker.target().isPresent()) {
            GlobalPos gp = (GlobalPos)tracker.target().get();
            if (level.dimension() == gp.dimension()) {
                return ((GlobalPos)tracker.target().get()).pos();
            }
        }
        return level.dimensionType().natural() ? level.getLevelData().getSpawnPos() : null;
    }

    public boolean getClickedSignIndex(Vec3 hit) {
        double y = hit.y;
        y = y < 0.0 ? (y += (double)(1 - (int)y)) : (y -= (double)((int)y));
        return y > 0.5;
    }

    public Sign getClickedSign(Vec3 hit) {
        return this.getSign(this.getClickedSignIndex(hit));
    }

    public void setWaxed(boolean waxed) {
        this.isWaxed = waxed;
    }

    public boolean isWaxed() {
        return this.isWaxed;
    }

    @Override
    public void setPlayerWhoMayEdit(UUID playerWhoMayEdit) {
        this.playerWhoMayEdit = playerWhoMayEdit;
    }

    @Override
    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    public static final class Sign {
        public final TextHolder text;
        private boolean active;
        private boolean left;
        private float yaw;
        private WoodType woodType;

        private Sign(boolean active, boolean left, float yaw, WoodType woodType) {
            this.active = active;
            this.left = left;
            this.yaw = yaw;
            this.woodType = woodType;
            this.text = new TextHolder(1, 90);
        }

        public void load(CompoundTag compound, HolderLookup.Provider registries, BlockPos pos) {
            this.active = compound.getBoolean("Active");
            this.left = compound.getBoolean("Left");
            this.yaw = compound.getFloat("Yaw");
            this.woodType = (WoodType)WoodTypeRegistry.INSTANCE.get(ResourceLocation.parse((String)compound.getString("WoodType")));
            this.text.load(compound, registries, pos);
        }

        public CompoundTag save(HolderLookup.Provider registries) {
            CompoundTag compound = new CompoundTag();
            compound.putFloat("Yaw", this.yaw);
            compound.putBoolean("Left", this.left);
            compound.putBoolean("Active", this.active);
            compound.putString("WoodType", this.woodType.toString());
            this.text.save(compound, registries);
            return compound;
        }

        public void pointToward(BlockPos myPos, BlockPos targetPos) {
            float yaw = (float)(Math.atan2((double)targetPos.getX() - (double)myPos.getX(), (double)targetPos.getZ() - (double)myPos.getZ()) * 57.2957763671875);
            this.setYaw(yaw);
        }

        private float getPointing() {
            return Mth.wrapDegrees((float)(-this.yaw - (float)(this.left ? 180 : 0)));
        }

        private void setYaw(float yaw) {
            this.yaw = Mth.wrapDegrees((float)(yaw - (float)(this.left ? 180 : 0)));
        }

        private void rotateBy(float angle, boolean constrainAngle) {
            this.yaw = Mth.wrapDegrees((float)(this.yaw + angle));
            if (constrainAngle) {
                this.yaw -= this.yaw % 22.5f;
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setLeft(boolean left) {
            this.left = left;
        }

        public void setWoodType(WoodType woodType) {
            this.woodType = woodType;
        }

        public boolean active() {
            return this.active;
        }

        public boolean left() {
            return this.left;
        }

        public float yaw() {
            return this.yaw;
        }

        public WoodType woodType() {
            return this.woodType;
        }

        public void toggleDirection() {
            this.left = !this.left;
        }

        public ItemStack getItem() {
            return new ItemStack((ItemLike)ModRegistry.WAY_SIGN_ITEMS.get(this.woodType));
        }
    }
}

