/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RedstoneIlluminatorBlock
extends Block {
    public static final IntegerProperty POWER = BlockStateProperties.POWER;

    public RedstoneIlluminatorBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(state -> 15 - (Integer)state.getValue((Property)POWER)));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWER});
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.neighborChanged(state, level, pos, neighborBlock, fromPos, moving);
        if (!level.isClientSide) {
            int pow = level.getBestNeighborSignal(pos);
            level.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(Mth.clamp((int)pow, (int)0, (int)15))), 2);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)POWER, (Comparable)Integer.valueOf(context.getLevel().getBestNeighborSignal(context.getClickedPos())));
    }
}

