/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PulleyBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PulleyBlock
extends RotatedPillarBlock
implements EntityBlock,
IRotatable {
    public static final EnumProperty<ModBlockProperties.Winding> TYPE = ModBlockProperties.WINDING;
    public static final BooleanProperty FLIPPED = ModBlockProperties.FLIPPED;

    public PulleyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AXIS, (Comparable)Direction.Axis.Y)).setValue(TYPE, (Comparable)((Object)ModBlockProperties.Winding.NONE))).setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TYPE, FLIPPED});
    }

    public boolean windPulley(BlockState state, BlockPos pos, LevelAccessor world, Rotation rot, @Nullable Direction dir) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)AXIS);
        if (axis == Direction.Axis.Y) {
            return false;
        }
        if (dir == null) {
            dir = axis == Direction.Axis.Z ? Direction.NORTH : Direction.WEST;
        }
        return this.rotateOverAxis(state, world, pos, rot, dir, null).isPresent();
    }

    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, Vec3 hit) {
        Direction.Axis targetAxis;
        Direction.Axis myAxis = (Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS);
        if (myAxis == (targetAxis = axis.getAxis())) {
            return Optional.of((BlockState)state.cycle((Property)FLIPPED));
        }
        if (myAxis == Direction.Axis.X) {
            return Optional.of((BlockState)state.setValue((Property)AXIS, (Comparable)(targetAxis == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y)));
        }
        if (myAxis == Direction.Axis.Z) {
            return Optional.of((BlockState)state.setValue((Property)AXIS, (Comparable)(targetAxis == Direction.Axis.Y ? Direction.Axis.X : Direction.Axis.Y)));
        }
        if (myAxis == Direction.Axis.Y) {
            return Optional.of((BlockState)state.setValue((Property)AXIS, (Comparable)(targetAxis == Direction.Axis.Z ? Direction.Axis.X : Direction.Axis.Z)));
        }
        return Optional.of(state);
    }

    public void onRotated(BlockState newState, BlockState oldState, LevelAccessor world, BlockPos pos, Rotation originalRot, Direction axis, @Nullable Vec3 hit) {
        if (axis.getAxis().isHorizontal() && axis.getAxis() == oldState.getValue((Property)AXIS)) {
            BlockPos connectedPos;
            BlockState connected;
            Rotation rot = originalRot;
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof PulleyBlockTile) {
                PulleyBlockTile pulley = (PulleyBlockTile)blockEntity;
                if (axis.getAxisDirection() == Direction.AxisDirection.NEGATIVE) {
                    rot = rot.getRotated(Rotation.CLOCKWISE_180);
                }
                pulley.rotateDirectly(rot);
            }
            if ((connected = world.getBlockState(connectedPos = pos.relative(axis))).is((Block)this) && newState.getValue((Property)AXIS) == connected.getValue((Property)AXIS)) {
                this.windPulley(connected, connectedPos, world, originalRot, axis);
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PulleyBlockTile) {
            PulleyBlockTile tile = (PulleyBlockTile)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                if (!player.isShiftKeyDown() || !this.windPulley(state, pos, (LevelAccessor)level, Rotation.COUNTERCLOCKWISE_90, null)) {
                    PlatHelper.openCustomMenu((ServerPlayer)sp, (MenuProvider)tile, (BlockPos)pos);
                    PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level blockEntity, BlockPos pos) {
        MenuProvider mp;
        BlockEntity tileEntity = blockEntity.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (mp = (MenuProvider)tileEntity) : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new PulleyBlockTile(pPos, pState);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)world.getBlockEntity(pos));
    }
}

