/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.ISimpleBrushable;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class BlackboardBlock
extends WaterBlock
implements EntityBlock,
IWashable,
ISimpleBrushable {
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.SOUTH);
    protected static final VoxelShape SHAPE_EAST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.EAST);
    protected static final VoxelShape SHAPE_WEST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.WEST);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public BlackboardBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public static byte colorToByte(DyeColor color) {
        return switch (color) {
            case DyeColor.BLACK -> 0;
            case DyeColor.WHITE -> 1;
            case DyeColor.ORANGE -> 15;
            default -> (byte)color.getId();
        };
    }

    public static int colorFromByte(byte b) {
        return switch (b) {
            case 0, 1 -> 0xFFFFFF;
            case 15 -> DyeColor.ORANGE.getMapColor().col;
            default -> DyeColor.byId((int)b).getMapColor().col;
        };
    }

    public static Vector2i getHitSubPixel(BlockHitResult hit) {
        Vec3 pos = hit.getLocation();
        Vec3 v = pos.yRot(hit.getDirection().toYRot() * ((float)Math.PI / 180));
        double fx = v.x % 1.0 * 16.0;
        if (fx < 0.0) {
            fx += 16.0;
        }
        int x = Mth.clamp((int)((int)fx), (int)-15, (int)15);
        int y = 15 - (int)Mth.clamp((double)Math.abs(v.y % 1.0 * 16.0), (double)0.0, (double)15.0);
        if (pos.y < 0.0) {
            y = 15 - y;
        }
        return new Vector2i(x, y);
    }

    @Nullable
    public static DyeColor getStackChalkColor(ItemStack stack) {
        boolean hasColor = CommonConfigs.Building.BLACKBOARD_COLOR.get();
        for (DyeColor dyeColor : DyeColor.values()) {
            if (!hasColor && dyeColor != DyeColor.WHITE && dyeColor != DyeColor.BLACK || !stack.is(ModTags.BLACKBOARD_TAGS.get(dyeColor))) continue;
            return dyeColor;
        }
        return null;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof BlackboardBlockTile) {
            DyeColor color;
            BlackboardBlockTile te = (BlackboardBlockTile)blockEntity;
            if (stack.getItem() instanceof BrushItem) {
                return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
            }
            ItemInteractionResult waxingRes = te.tryWaxingWithItem(level, pos, player, stack);
            if (waxingRes == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
                waxingRes = te.tryGlowing(level, pos, player, hand, stack);
            }
            if (waxingRes.consumesAction()) {
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)level.getBlockState(pos)));
                te.setChanged();
            }
            if (waxingRes != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
                return waxingRes;
            }
            UseMode config = CommonConfigs.Building.BLACKBOARD_MODE.get();
            if (hit.getDirection() == state.getValue((Property)FACING) && config.canManualDraw() && !te.isWaxed() && (color = BlackboardBlock.getStackChalkColor(stack)) != null) {
                Vector2i pair = BlackboardBlock.getHitSubPixel(hit);
                int x = pair.x();
                int y = pair.y();
                byte newColor = BlackboardBlock.colorToByte(color);
                if (te.getPixel(x, y) != newColor) {
                    te.setPixel(x, y, newColor);
                    te.setChanged();
                }
                return ItemInteractionResult.CONSUME;
            }
            if (config.canOpenGui()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    te.tryOpeningEditGui(serverPlayer, pos, stack);
                }
                return ItemInteractionResult.CONSUME;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.SUCCESS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new BlackboardBlockTile(pPos, pState);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BlackboardBlockTile) {
            BlackboardBlockTile te = (BlackboardBlockTile)blockEntity;
            return BlockUtil.saveTileToItem(te);
        }
        return super.getCloneItemStack(level, pos, state);
    }

    public boolean tryWash(Level level, BlockPos pos, BlockState state, Vec3 hitVec) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BlackboardBlockTile) {
            BlackboardBlockTile te = (BlackboardBlockTile)blockEntity;
            if (te.isWaxed()) {
                te.setWaxed(false);
                te.setChanged();
                return true;
            }
            if (te.isGlowing()) {
                te.setGlowing(false);
                te.setChanged();
                return true;
            }
            if (!te.isEmpty()) {
                te.clearPixels();
                te.setChanged();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean brush(BlockState state, BlockPos pos, Level level, ItemStack stack, Player livingEntity, HumanoidArm arm, BlockHitResult hit, Vec3 particlesDir) {
        BlackboardBlockTile te;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BlackboardBlockTile && !(te = (BlackboardBlockTile)blockEntity).isWaxed() && !te.isEmpty()) {
            te.clearPixels();
            te.setChanged();
            level.playSound(livingEntity, pos, SoundEvents.BRUSH_GENERIC, SoundSource.BLOCKS);
            return true;
        }
        return false;
    }

    public static enum UseMode {
        BOTH,
        GUI,
        MANUAL;


        public boolean canOpenGui() {
            return this != MANUAL;
        }

        public boolean canManualDraw() {
            return this != GUI;
        }
    }
}

