/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import net.mehvahdjukaar.supplementaries.common.items.KeyItem;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface IKeyLockable {
    public static final int MAX_ITEM_NAME_LEN = 50;

    public void setPassword(String var1);

    public String getPassword();

    public void clearPassword();

    default public void onPasswordCleared(Player player, BlockPos pos) {
        player.displayClientMessage((Component)Component.translatable((String)"message.supplementaries.safe.cleared"), true);
        player.level().playSound(null, pos, SoundEvents.IRON_TRAPDOOR_OPEN, SoundSource.BLOCKS, 0.5f, 1.5f);
    }

    default public boolean shouldShowPassword() {
        String password = this.getPassword();
        return password != null && password.length() <= 50;
    }

    default public void onKeyAssigned(Level level, BlockPos pos, Player player, String newKey) {
        MutableComponent message = this.shouldShowPassword() ? Component.translatable((String)"message.supplementaries.safe.assigned_key", (Object[])new Object[]{newKey}) : Component.translatable((String)"message.supplementaries.safe.assigned_key_generic");
        player.displayClientMessage((Component)message, true);
        level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.IRON_TRAPDOOR_OPEN, SoundSource.BLOCKS, 0.5f, 1.5f);
    }

    default public KeyStatus getKeyStatus(ItemStack key) {
        return IKeyLockable.getKeyStatus(key, this.getPassword());
    }

    default public KeyStatus getKeyInInventoryStatus(Player player) {
        return ItemsUtil.getPlayerKeyStatus(player, this.getPassword());
    }

    public static KeyStatus getKeyStatus(ItemStack key, String password) {
        String correct = IKeyLockable.getKeyPassword(key);
        if (correct != null) {
            if (correct.equals(password)) {
                return KeyStatus.CORRECT_KEY;
            }
            return KeyStatus.INCORRECT_KEY;
        }
        return KeyStatus.NO_KEY;
    }

    @Nullable
    public static String getKeyPassword(ItemStack key) {
        Item item = key.getItem();
        if (item instanceof KeyItem) {
            KeyItem k = (KeyItem)item;
            return k.getPassword(key);
        }
        if (key.is(ModTags.KEYS)) {
            return ModRegistry.KEY_ITEM.get().getPassword(key);
        }
        return null;
    }

    public static enum KeyStatus {
        CORRECT_KEY,
        INCORRECT_KEY,
        NO_KEY;


        public boolean isCorrect() {
            return this == CORRECT_KEY;
        }

        public void sendMessage(Player player, String translName) {
            if (this == INCORRECT_KEY) {
                player.displayClientMessage((Component)Component.translatable((String)"message.supplementaries.safe.incorrect_key"), true);
            } else if (this == NO_KEY) {
                player.displayClientMessage((Component)Component.translatable((String)("message.supplementaries." + translName + ".locked")), true);
            }
        }
    }
}

