/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.models;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.models.IRootModel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import org.joml.Vector3f;

public class GenericAnimationStuff {
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public static <M extends EntityModel<?>> void animate(M model, AnimationState pAnimationState, AnimationDefinition pAnimationDefinition, float pAgeInTicks) {
        GenericAnimationStuff.animate(model, pAnimationState, pAnimationDefinition, pAgeInTicks, 1.0f);
    }

    public static <M extends EntityModel<?>> void animate(M model, AnimationState pAnimationState, AnimationDefinition pAnimationDefinition, float pAgeInTicks, float pSpeed) {
        pAnimationState.updateTime(pAgeInTicks, pSpeed);
        pAnimationState.ifStarted(a -> GenericAnimationStuff.animate(model, pAnimationDefinition, a.getAccumulatedTime(), 1.0f));
    }

    public static <M extends EntityModel<?>> void animate(M model, AnimationDefinition animationDefinition, long accumulatedTime, float scale) {
        float time = GenericAnimationStuff.getElapsedSeconds(animationDefinition, accumulatedTime);
        for (Map.Entry stringListEntry : animationDefinition.boneAnimations().entrySet()) {
            Optional<ModelPart> optional = GenericAnimationStuff.getAnyDescendantWithName(model, (String)stringListEntry.getKey());
            List list = (List)stringListEntry.getValue();
            optional.ifPresent(modelPart -> list.forEach(animationChannel -> {
                Keyframe[] keyframes = animationChannel.keyframes();
                int frameInd = Math.max(0, Mth.binarySearch((int)0, (int)keyframes.length, ix -> time <= keyframes[ix].timestamp()) - 1);
                int nextFrameInd = Math.min(keyframes.length - 1, frameInd + 1);
                Keyframe frame = keyframes[frameInd];
                Keyframe nextFrame = keyframes[nextFrameInd];
                float timeDelta = time - frame.timestamp();
                float delta = nextFrameInd != frameInd ? Mth.clamp((float)(timeDelta / (nextFrame.timestamp() - frame.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
                nextFrame.interpolation().apply(ANIMATION_VECTOR_CACHE, delta, keyframes, frameInd, nextFrameInd, scale);
                animationChannel.target().apply(modelPart, ANIMATION_VECTOR_CACHE);
            }));
        }
    }

    private static float getElapsedSeconds(AnimationDefinition animationDefinition, long accumulatedTime) {
        float f = (float)accumulatedTime / 1000.0f;
        return animationDefinition.looping() ? f % animationDefinition.lengthInSeconds() : f;
    }

    private static <M extends EntityModel<?>> Optional<ModelPart> getAnyDescendantWithName(M model, String string) {
        return string.equals("root") ? Optional.of(((IRootModel)model).getRoot()) : ((IRootModel)model).getRoot().getAllParts().filter(arg -> arg.hasChild(string)).findFirst().map(arg -> arg.getChild(string));
    }
}

