/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavendermd.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class TextBuilder {
    private final Deque<Style> styles;
    private MutableComponent text = Component.empty();
    private boolean empty = true;

    public TextBuilder() {
        this.styles = new ArrayDeque<Style>();
        this.styles.push(Style.EMPTY);
    }

    public void append(MutableComponent text) {
        this.text.append((Component)text.withStyle(style -> style.applyTo(this.styles.peek())));
        this.empty = false;
    }

    public void pushStyle(UnaryOperator<Style> style) {
        this.styles.push((Style)style.apply(this.styles.peek()));
    }

    public void popStyle() {
        this.styles.pop();
    }

    public MutableComponent build() {
        MutableComponent result = this.text;
        if (result.getString().equals("\n")) {
            result = Component.literal((String)" ");
        }
        this.text = Component.empty();
        this.empty = true;
        return result;
    }

    public boolean empty() {
        return this.empty;
    }
}

