/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavendermd;

import com.google.common.collect.ImmutableList;
import io.wispforest.lavendermd.Lexer;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.Parser;
import io.wispforest.lavendermd.compiler.MarkdownCompiler;
import io.wispforest.lavendermd.compiler.TextCompiler;
import io.wispforest.lavendermd.feature.BasicFormattingFeature;
import io.wispforest.lavendermd.feature.BlockQuoteFeature;
import io.wispforest.lavendermd.feature.ColorFeature;
import io.wispforest.lavendermd.feature.LinkFeature;
import io.wispforest.lavendermd.feature.ListFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;

public class MarkdownProcessor<R> {
    private final Supplier<MarkdownCompiler<R>> compilerFactory;
    private final List<MarkdownFeature> features;
    private final Lexer lexer;
    private final Parser parser;

    public MarkdownProcessor(Supplier<MarkdownCompiler<R>> compilerFactory, MarkdownFeature ... features) {
        this(compilerFactory, Arrays.asList(features));
    }

    public MarkdownProcessor(Supplier<MarkdownCompiler<R>> compilerFactory, List<MarkdownFeature> features) {
        this.compilerFactory = compilerFactory;
        this.features = ImmutableList.copyOf(features);
        MarkdownCompiler<R> testCompiler = this.compilerFactory.get();
        for (MarkdownFeature feature : this.features) {
            if (feature.supportsCompiler(testCompiler)) continue;
            throw new IllegalStateException("Feature '" + feature.name() + "' is incompatible with compiler '" + testCompiler.name() + "'");
        }
        this.lexer = new Lexer();
        this.parser = new Parser();
        for (MarkdownFeature extension : features) {
            extension.registerTokens(this.lexer);
            extension.registerNodes(this.parser);
        }
    }

    public Collection<MarkdownFeature> installedFeatures() {
        return this.features;
    }

    public boolean hasFeature(Class<?> featureClass) {
        for (MarkdownFeature extension : this.features) {
            if (!featureClass.isInstance(extension)) continue;
            return true;
        }
        return false;
    }

    public R process(String markdown) {
        MarkdownCompiler<R> compiler = this.compilerFactory.get();
        this.parser.parse(this.lexer.lex(markdown)).visit(compiler);
        return compiler.compile();
    }

    public MarkdownProcessor<R> copyWith(MarkdownFeature ... features) {
        ArrayList<MarkdownFeature> newFeatures = new ArrayList<MarkdownFeature>(this.features);
        for (MarkdownFeature feature : features) {
            if (this.hasFeature(feature.getClass())) continue;
            newFeatures.add(feature);
        }
        return new MarkdownProcessor<R>(this.compilerFactory, newFeatures);
    }

    public <R2> MarkdownProcessor<R2> copyWith(Supplier<MarkdownCompiler<R2>> compilerFactory) {
        return new MarkdownProcessor<R>(compilerFactory, this.features);
    }

    public static MarkdownProcessor<Component> text() {
        return new MarkdownProcessor<Component>(TextCompiler::new, new BasicFormattingFeature(false), new ColorFeature());
    }

    public static MarkdownProcessor<Component> richText(int assumedOutputWidth) {
        return new MarkdownProcessor<Component>(() -> new TextCompiler(assumedOutputWidth), new BasicFormattingFeature(), new ColorFeature(), new LinkFeature(), new ListFeature(), new BlockQuoteFeature());
    }
}

