/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.jei.transfer;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.network.serverbound.JEITransferKegRecipeServerboundPacket;
import umpaz.brewinandchewin.common.registry.BnCMenuTypes;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.integration.jei.BnCJEIRecipeTypes;
import umpaz.brewinandchewin.integration.jei.KegFermentingPouringRecipe;

public class FermentingTransfer {

    private record InventoryState(Map<Slot, ItemStack> availableItemStacks, int filledCraftSlotCount, int emptySlotCount) {
        private boolean hasRoom(int inputCount) {
            return this.filledCraftSlotCount - inputCount <= this.emptySlotCount;
        }
    }

    public static class TransferOperations {
        public final List<Pair<Slot, Slot>> results = new ArrayList<Pair<Slot, Slot>>();
        public final List<Pair<Slot, Long>> fluidResults = new ArrayList<Pair<Slot, Long>>();
        public final List<Pair<Slot, Long>> emptyingResults = new ArrayList<Pair<Slot, Long>>();
        public final List<IRecipeSlotView> missingItems = new ArrayList<IRecipeSlotView>();
        public boolean canEmpty = true;
        public boolean notEnoughFluid = false;
        public boolean invalidFluid = false;

        public static TransferOperations readFromIntegers(List<Pair<Integer, Integer>> resultSlots, List<Pair<Integer, Long>> fluidSlots, List<Pair<Integer, Long>> emptyingSlots, AbstractContainerMenu menu) {
            TransferOperations operations = new TransferOperations();
            for (Pair<Integer, Integer> pair : resultSlots) {
                int inventorySlotIndex = (Integer)pair.getFirst();
                int craftingSlotIndex = (Integer)pair.getSecond();
                operations.results.add((Pair<Slot, Slot>)Pair.of((Object)menu.getSlot(inventorySlotIndex), (Object)menu.getSlot(craftingSlotIndex)));
            }
            for (Pair pair : fluidSlots) {
                int fluidSlotIndex = (Integer)pair.getFirst();
                long fluidAmount = (Long)pair.getSecond();
                operations.fluidResults.add((Pair<Slot, Long>)Pair.of((Object)menu.getSlot(fluidSlotIndex), (Object)fluidAmount));
            }
            for (Pair pair : emptyingSlots) {
                int emptyingSlotIndex = (Integer)pair.getFirst();
                long fluidAmount = (Long)pair.getSecond();
                operations.emptyingResults.add((Pair<Slot, Long>)Pair.of((Object)menu.getSlot(emptyingSlotIndex), (Object)fluidAmount));
            }
            return operations;
        }
    }

    private record SlotReference(Slot slot, ItemStack stack, @Nullable Long fluidAmount, int shrinkAmount) {
    }

    public static class Handler
    implements IRecipeTransferHandler<KegMenu, KegFermentingPouringRecipe> {
        private final IRecipeTransferHandlerHelper helper;
        private final IStackHelper stackHelper;
        private final IPlatformFluidHelper<?> platformFluidHelper;

        public Handler(IRecipeTransferHandlerHelper helper, IStackHelper stackHelper, IPlatformFluidHelper<?> platformFluidHelper) {
            this.helper = helper;
            this.stackHelper = stackHelper;
            this.platformFluidHelper = platformFluidHelper;
        }

        public Class<? extends KegMenu> getContainerClass() {
            return KegMenu.class;
        }

        public Optional<MenuType<KegMenu>> getMenuType() {
            return Optional.of(BnCMenuTypes.KEG);
        }

        public RecipeType<KegFermentingPouringRecipe> getRecipeType() {
            return BnCJEIRecipeTypes.FERMENTING;
        }

        @Nullable
        public IRecipeTransferError transferRecipe(KegMenu menu, KegFermentingPouringRecipe recipe, IRecipeSlotsView view, Player player, boolean maxTransfer, boolean doTransfer) {
            int requiredInv;
            if (!KegBlockEntity.isValidTemp(menu.getKegTemperature(), recipe.getTemperature())) {
                MutableComponent message = Component.translatable((String)"brewinandchewin.jei.tooltip.error.recipe.transfer.temperature");
                return this.helper.createUserErrorWithTooltip((Component)message);
            }
            Info info = Info.INSTANCE;
            List<Slot> craftingSlots = Collections.unmodifiableList(info.getRecipeSlots(menu, recipe));
            List<Slot> inventorySlots = Collections.unmodifiableList(info.getInventorySlots(menu, recipe));
            List<IRecipeSlotView> inputItemSlotViews = view.getSlotViews(RecipeIngredientRole.INPUT).stream().filter(ingredientView -> ingredientView.getAllIngredients().anyMatch(ingredient -> ingredient.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).isPresent())).toList();
            InventoryState inv = this.createInvState(craftingSlots, inventorySlots);
            if (!inv.hasRoom(requiredInv = inputItemSlotViews.size())) {
                MutableComponent message = Component.translatable((String)"jei.tooltip.error.recipe.transfer.inventory.full");
                return this.helper.createUserErrorWithTooltip((Component)message);
            }
            TransferOperations operations = this.createOperations(inv.availableItemStacks, inputItemSlotViews, recipe.getFluidIngredient().isPresent() ? (IRecipeSlotView)view.getSlotViews(RecipeIngredientRole.INPUT).stream().filter(ingredientView -> ingredientView.getAllIngredients().anyMatch(ingredient -> ingredient.getIngredient((IIngredientType)this.platformFluidHelper.getFluidIngredientType()).isPresent())).findFirst().orElse(null) : null, recipe, menu, craftingSlots, maxTransfer);
            if (!operations.canEmpty) {
                MutableComponent message = Component.translatable((String)"brewinandchewin.jei.tooltip.error.recipe.transfer.cant_empty");
                return this.helper.createUserErrorWithTooltip((Component)message);
            }
            if (operations.notEnoughFluid) {
                MutableComponent message = Component.translatable((String)"brewinandchewin.jei.tooltip.error.recipe.transfer.not_enough_fluid");
                return this.helper.createUserErrorWithTooltip((Component)message);
            }
            if (operations.invalidFluid) {
                MutableComponent message = Component.translatable((String)"brewinandchewin.jei.tooltip.error.recipe.transfer.invalid_fluid");
                return this.helper.createUserErrorWithTooltip((Component)message);
            }
            if (!operations.missingItems.isEmpty()) {
                MutableComponent message = Component.translatable((String)"jei.tooltip.error.recipe.transfer.missing");
                return this.helper.createUserErrorForMissingSlots((Component)message, operations.missingItems);
            }
            if (doTransfer) {
                BrewinAndChewin.getHelper().sendServerbound(new JEITransferKegRecipeServerboundPacket(recipe.getId(), operations.results.stream().map(pair -> Pair.of((Object)((Slot)pair.getFirst()).index, (Object)((Slot)pair.getSecond()).index)).toList(), operations.fluidResults.stream().map(pair -> Pair.of((Object)((Slot)pair.getFirst()).index, (Object)((Long)pair.getSecond()))).toList(), operations.emptyingResults.stream().map(pair -> Pair.of((Object)((Slot)pair.getFirst()).index, (Object)((Long)pair.getSecond()))).toList(), craftingSlots.stream().map(slot -> slot.index).toList(), inventorySlots.stream().map(slot -> slot.index).toList(), maxTransfer));
            }
            return null;
        }

        private InventoryState createInvState(Collection<Slot> craftingSlots, Collection<Slot> inventorySlots) {
            ItemStack stack;
            HashMap<Slot, ItemStack> availableItemStacks = new HashMap<Slot, ItemStack>();
            int filledCraftSlotCount = 0;
            int emptySlotCount = 0;
            for (Slot slot : craftingSlots) {
                stack = slot.getItem();
                if (stack.isEmpty()) continue;
                ++filledCraftSlotCount;
                availableItemStacks.put(slot, stack.copy());
            }
            for (Slot slot : inventorySlots) {
                stack = slot.getItem();
                if (!stack.isEmpty()) {
                    availableItemStacks.put(slot, stack.copy());
                    continue;
                }
                ++emptySlotCount;
            }
            return new InventoryState(availableItemStacks, filledCraftSlotCount, emptySlotCount);
        }

        /*
         * WARNING - void declaration
         */
        private TransferOperations createOperations(Map<Slot, ItemStack> availableItemStacks, List<IRecipeSlotView> requiredItemStacks, IRecipeSlotView requiredFluidStack, KegFermentingPouringRecipe recipe, KegMenu menu, List<Slot> craftingSlots, boolean maxTransfer) {
            List allMatching;
            long l;
            void var21_28;
            TransferOperations operations = new TransferOperations();
            IdentityHashMap<IRecipeSlotView, Map> relevantSlots = new IdentityHashMap<IRecipeSlotView, Map>();
            IdentityHashMap<ItemStack, List> emptyingSlots = new IdentityHashMap<ItemStack, List>();
            boolean hasTooMuchFluid = false;
            long fluidCapacity = 0L;
            long largestFluidCapacity = 0L;
            long largestEmptyCapacity = 0L;
            for (Map.Entry<Slot, ItemStack> slotTuple : availableItemStacks.entrySet()) {
                long tankAmount;
                List<KegPouringRecipe> pouringRecipes;
                Optional<KegPouringRecipe> optional;
                for (IRecipeSlotView iRecipeSlotView : requiredItemStacks) {
                    if (iRecipeSlotView.isEmpty() || !iRecipeSlotView.getItemStacks().anyMatch(it -> this.stackHelper.isEquivalent(it, (ItemStack)slotTuple.getValue(), UidContext.Ingredient))) continue;
                    relevantSlots.computeIfAbsent(iRecipeSlotView, it -> new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<ItemStack>(){

                        public int hashCode(ItemStack o) {
                            return o.getItem().hashCode();
                        }

                        public boolean equals(ItemStack a, ItemStack b) {
                            return stackHelper.isEquivalent(a, b, UidContext.Ingredient);
                        }
                    })).computeIfAbsent(slotTuple.getValue(), it -> new ArrayList()).add(new SlotReference(slotTuple.getKey(), slotTuple.getValue(), null, 1));
                }
                if (!(menu.kegTank.isEmpty() || maxTransfer && !recipe.getFluidIngredient().isEmpty() && recipe.getFluidIngredient().get().ingredient().matches(menu.kegTank.getAbstractedFluid()) || !(optional = (pouringRecipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().map(RecipeHolder::value).filter(kegPouringRecipe -> kegPouringRecipe.getFluid((ItemStack)slotTuple.getValue()).matches(menu.kegTank.getAbstractedFluid())).toList()).stream().filter(pouring -> {
                    if (pouring.isStrict()) {
                        return ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)slotTuple.getValue()), (ItemStack)pouring.getContainer());
                    }
                    return ItemStack.isSameItem((ItemStack)((ItemStack)slotTuple.getValue()), (ItemStack)pouring.getContainer());
                }).findFirst()).isPresent())) {
                    int shrinkAmount;
                    if (optional.get().getRawFluid().amount() <= menu.kegTank.getAbstractedFluid().amount()) {
                        shrinkAmount = (int)(menu.kegTank.getAbstractedFluid().amount() / optional.get().getRawFluid().amount());
                        emptyingSlots.computeIfAbsent(slotTuple.getValue(), it -> new ArrayList()).add(new SlotReference(slotTuple.getKey(), slotTuple.getValue(), optional.get().getRawFluid().amount() * (long)shrinkAmount, shrinkAmount));
                    }
                    if (recipe.getFluidIngredient().isPresent() && recipe.getFluidIngredient().get().ingredient().matches(menu.kegTank.getAbstractedFluid()) && optional.get().getRawFluid().amount() <= recipe.getFluidIngredient().get().amount() && fluidCapacity < recipe.getFluidIngredient().get().amount()) {
                        if (optional.get().getRawFluid().amount() > largestEmptyCapacity) {
                            relevantSlots.remove(requiredFluidStack);
                        }
                        shrinkAmount = (int)(recipe.getFluidIngredient().get().amount() / optional.get().getRawFluid().amount());
                        largestEmptyCapacity = optional.get().getRawFluid().amount();
                        relevantSlots.computeIfAbsent(requiredFluidStack, it -> new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<ItemStack>(){

                            public int hashCode(ItemStack o) {
                                return o.getItem().hashCode();
                            }

                            public boolean equals(ItemStack a, ItemStack b) {
                                return stackHelper.isEquivalent(a, b, UidContext.Ingredient);
                            }
                        })).computeIfAbsent(slotTuple.getValue(), it -> new ArrayList()).add(new SlotReference(slotTuple.getKey(), optional.get().getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).copyWithCount(shrinkAmount), optional.get().getRawFluid().amount() * (long)shrinkAmount, shrinkAmount));
                    }
                }
                if (!recipe.getFluidIngredient().isPresent() || requiredFluidStack.isEmpty() || !requiredFluidStack.getIngredients((IIngredientType)this.platformFluidHelper.getFluidIngredientType()).findFirst().isPresent()) continue;
                pouringRecipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().map(RecipeHolder::value).filter(kegPouringRecipe -> kegPouringRecipe.canFill() && recipe.getFluidIngredient().get().ingredient().matches(kegPouringRecipe.getFluid((ItemStack)slotTuple.getValue()))).toList();
                Optional<KegPouringRecipe> optional2 = pouringRecipes.stream().filter(pouring -> {
                    if (pouring.isStrict()) {
                        return ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)slotTuple.getValue()), (ItemStack)pouring.getOutput());
                    }
                    return ItemStack.isSameItem((ItemStack)((ItemStack)slotTuple.getValue()), (ItemStack)pouring.getOutput());
                }).findFirst();
                long l2 = tankAmount = recipe.getFluidIngredient().get().ingredient().matches(menu.kegTank.getAbstractedFluid()) ? menu.kegTank.getAbstractedFluid().amount() : 0L;
                if (!optional2.isPresent()) continue;
                if (optional2.get().getRawFluid().amount() <= menu.kegTank.getFluidCapacity() - tankAmount && fluidCapacity < menu.kegTank.getFluidCapacity() - tankAmount) {
                    if (optional2.get().getRawFluid().amount() > largestFluidCapacity) {
                        relevantSlots.remove(requiredFluidStack);
                    }
                    int shrinkAmount = (int)(recipe.getFluidIngredient().get().amount() / optional2.get().getRawFluid().amount() - tankAmount % recipe.getFluidIngredient().get().amount() / optional2.get().getRawFluid().amount());
                    largestFluidCapacity = optional2.get().getRawFluid().amount();
                    fluidCapacity += optional2.get().getRawFluid().amount() * (long)shrinkAmount;
                    relevantSlots.computeIfAbsent(requiredFluidStack, it -> new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<ItemStack>(){

                        public int hashCode(ItemStack o) {
                            return o.getItem().hashCode();
                        }

                        public boolean equals(ItemStack a, ItemStack b) {
                            return stackHelper.isEquivalent(a, b, UidContext.Ingredient);
                        }
                    })).computeIfAbsent(slotTuple.getValue(), it -> new ArrayList()).add(new SlotReference(slotTuple.getKey(), slotTuple.getValue(), optional2.get().getRawFluid().amount() * (long)shrinkAmount, shrinkAmount));
                    continue;
                }
                hasTooMuchFluid = true;
            }
            Object2ObjectArrayMap bestMatches = new Object2ObjectArrayMap();
            ArrayList emptyingBestMatches = new ArrayList();
            for (Map.Entry entry : relevantSlots.entrySet()) {
                ArrayList<List> countedAndSorted = new ArrayList<List>();
                for (Map.Entry foundSlots : ((Map)entry.getValue()).entrySet()) {
                    ((List)foundSlots.getValue()).sort((o1, o2) -> {
                        int compare;
                        int n = compare = o1.fluidAmount != null && o2.fluidAmount != null ? Long.compare(o1.fluidAmount, o2.fluidAmount) : Integer.compare(o1.stack.getCount(), o2.stack.getCount());
                        if (compare == 0) {
                            return Integer.compare(o1.slot.index, o2.slot.index);
                        }
                        return compare;
                    });
                    countedAndSorted.add((List)foundSlots.getValue());
                }
                countedAndSorted.sort((o1, o2) -> {
                    int compare = Long.compare(o2.stream().mapToLong(it -> it.stack.getCount()).sum(), o1.stream().mapToLong(it -> it.stack.getCount()).sum());
                    if (compare == 0) {
                        return Integer.compare(o1.stream().mapToInt(it -> it.slot.index).min().orElse(0), o2.stream().mapToInt(it -> it.slot.index).min().orElse(0));
                    }
                    return compare;
                });
                bestMatches.put((IRecipeSlotView)entry.getKey(), countedAndSorted);
            }
            for (Map.Entry entry : emptyingSlots.entrySet()) {
                ArrayList<List> countedAndSorted = new ArrayList<List>();
                ((List)entry.getValue()).sort((o1, o2) -> {
                    int compare;
                    int n = compare = o1.fluidAmount != null && o2.fluidAmount != null ? Long.compare(o1.fluidAmount, o2.fluidAmount) : Integer.compare(o1.stack.getCount(), o2.stack.getCount());
                    if (compare == 0) {
                        return Integer.compare(o1.slot.index, o2.slot.index);
                    }
                    return compare;
                });
                countedAndSorted.add((List)entry.getValue());
                countedAndSorted.sort((o1, o2) -> {
                    int compare = Long.compare(o2.stream().mapToLong(it -> it.stack.getCount()).sum(), o1.stream().mapToLong(it -> it.stack.getCount()).sum());
                    if (compare == 0) {
                        return Integer.compare(o1.stream().mapToInt(it -> it.slot.index).min().orElse(0), o2.stream().mapToInt(it -> it.slot.index).min().orElse(0));
                    }
                    return compare;
                });
                emptyingBestMatches.addAll(countedAndSorted);
            }
            ArrayList<IRecipeSlotView> inclusiveRequiredItemStacks = new ArrayList<IRecipeSlotView>(requiredItemStacks);
            if (requiredFluidStack != null) {
                inclusiveRequiredItemStacks.add(requiredFluidStack);
            }
            for (IRecipeSlotView ingredient : inclusiveRequiredItemStacks) {
                if (ingredient.isEmpty()) continue;
                bestMatches.computeIfAbsent(ingredient, it -> new ArrayList());
            }
            boolean bl = false;
            while (var21_28 < requiredItemStacks.size()) {
                IRecipeSlotView requiredItemStack = requiredItemStacks.get((int)var21_28);
                if (!requiredItemStack.isEmpty()) {
                    Slot craftingSlot = craftingSlots.get((int)var21_28);
                    SlotReference matching = ((List)bestMatches.get(requiredItemStack)).stream().flatMap(pairs -> pairs.stream().filter(p -> !p.stack.isEmpty())).findFirst().orElse(null);
                    if (matching == null) {
                        operations.missingItems.add(requiredItemStack);
                    } else {
                        matching.stack.shrink(matching.shrinkAmount);
                        operations.results.add((Pair<Slot, Slot>)Pair.of((Object)matching.slot, (Object)craftingSlot));
                    }
                }
                ++var21_28;
            }
            if (requiredFluidStack != null && recipe.getFluidIngredient().isPresent() && (l = Math.max((maxTransfer ? menu.kegTank.getFluidCapacity() : recipe.getFluidIngredient().get().amount()) - (recipe.getFluidIngredient().get().ingredient().matches(menu.kegTank.getAbstractedFluid()) ? menu.kegTank.getAbstractedFluid().amount() : 0L), 0L)) > 0L) {
                allMatching = ((List)bestMatches.get(requiredFluidStack)).stream().flatMap(pairs -> pairs.stream().filter(p -> !p.stack.isEmpty() && p.fluidAmount != null)).toList();
                if (allMatching.isEmpty()) {
                    operations.missingItems.add(requiredFluidStack);
                    if (hasTooMuchFluid) {
                        operations.invalidFluid = true;
                    }
                } else {
                    ArrayList<SlotReference> toShrink = new ArrayList<SlotReference>();
                    for (SlotReference matching : allMatching) {
                        if (l <= 0L) break;
                        toShrink.add(matching);
                        operations.fluidResults.add((Pair<Slot, Long>)Pair.of((Object)matching.slot, (Object)matching.fluidAmount));
                        l -= matching.fluidAmount != null ? matching.fluidAmount : 0L;
                    }
                    if (l > 0L) {
                        operations.fluidResults.clear();
                        operations.notEnoughFluid = true;
                    } else {
                        toShrink.forEach(slotReference -> slotReference.stack.shrink(slotReference.shrinkAmount));
                    }
                }
            }
            if (!emptyingBestMatches.isEmpty()) {
                long l3 = menu.kegTank.getAbstractedFluid().amount();
                allMatching = emptyingBestMatches.stream().flatMap(pairs -> pairs.stream().filter(p -> !p.stack.isEmpty() && p.fluidAmount != null)).toList();
                if (allMatching.isEmpty() && !menu.kegTank.isEmpty() && (recipe.getFluidIngredient().isEmpty() || !recipe.getFluidIngredient().get().ingredient().matches(menu.kegTank.getAbstractedFluid()))) {
                    operations.canEmpty = false;
                } else {
                    ArrayList<SlotReference> toShrink = new ArrayList<SlotReference>();
                    for (SlotReference matching : allMatching) {
                        if (l3 <= 0L) break;
                        toShrink.add(matching);
                        operations.emptyingResults.add((Pair<Slot, Long>)Pair.of((Object)matching.slot, (Object)matching.fluidAmount));
                        l3 -= matching.fluidAmount != null ? matching.fluidAmount : 0L;
                    }
                    if (!(l3 <= 0L || menu.kegTank.isEmpty() || !recipe.getFluidIngredient().isEmpty() && recipe.getFluidIngredient().get().ingredient().matches(menu.kegTank.getAbstractedFluid()))) {
                        operations.emptyingResults.clear();
                        operations.canEmpty = false;
                    } else {
                        toShrink.forEach(slotReference -> slotReference.stack.shrink(slotReference.shrinkAmount));
                    }
                }
            }
            if (!menu.kegTank.isEmpty() && emptyingBestMatches.isEmpty() && (recipe.getFluidIngredient().isEmpty() || !recipe.getFluidIngredient().get().ingredient().matches(menu.kegTank.getAbstractedFluid()) || recipe.getFluidIngredient().isPresent() && menu.kegTank.getAbstractedFluid().amount() % recipe.getFluidIngredient().get().amount() != 0L)) {
                operations.canEmpty = false;
            }
            return operations;
        }
    }

    public static class Info
    implements IRecipeTransferInfo<KegMenu, KegFermentingPouringRecipe> {
        public static final Info INSTANCE = new Info();

        protected Info() {
        }

        public Class<? extends KegMenu> getContainerClass() {
            return KegMenu.class;
        }

        public Optional<MenuType<KegMenu>> getMenuType() {
            return Optional.of(BnCMenuTypes.KEG);
        }

        public RecipeType<KegFermentingPouringRecipe> getRecipeType() {
            return BnCJEIRecipeTypes.FERMENTING;
        }

        public boolean canHandle(KegMenu container, KegFermentingPouringRecipe recipe) {
            return true;
        }

        public List<Slot> getRecipeSlots(KegMenu container, KegFermentingPouringRecipe recipe) {
            ArrayList<Slot> slots = new ArrayList<Slot>();
            for (int i = 0; i < 4; ++i) {
                Slot slot = container.getSlot(i);
                slots.add(slot);
            }
            return slots;
        }

        public List<Slot> getInventorySlots(KegMenu container, KegFermentingPouringRecipe recipe) {
            ArrayList<Slot> slots = new ArrayList<Slot>();
            for (int i = 6; i < 42; ++i) {
                Slot slot = container.getSlot(i);
                slots.add(slot);
            }
            return slots;
        }
    }
}

