/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.utility.dfu;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.datafix.fixes.ItemRenameFix;
import net.minecraft.util.datafix.fixes.NamespacedTypeRenameFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;
import umpaz.brewinandchewin.common.mixin.DataFixTypesAccessor;
import umpaz.brewinandchewin.common.utility.dfu.schema.BnCSchemaV1;

public record BnCDataFixer(DataFixer fixer) {
    public static final int CURRENT_VERSION = 100;
    private static final BiFunction<Integer, Schema, Schema> SAME = Schema::new;
    private static final BiFunction<Integer, Schema, Schema> SAME_NAMESPACED = NamespacedSchema::new;
    private static BnCDataFixer instance;

    public static BnCDataFixer get() {
        if (instance == null) {
            instance = new BnCDataFixer(BnCDataFixer.registerFixers());
        }
        return instance;
    }

    private static DataFixer registerFixers() {
        DataFixerBuilder builder = new DataFixerBuilder(100);
        builder.addSchema(0, (integer, schema) -> new Schema(integer.intValue(), DataFixers.getDataFixer().getSchema(DataFixUtils.makeKey((int)SharedConstants.getCurrentVersion().getDataVersion().getVersion()))));
        builder.addSchema(1, BnCSchemaV1::new);
        Schema schema2 = builder.addSchema(2, SAME_NAMESPACED);
        builder.addFixer(ItemRenameFix.create((Schema)schema2, (String)"Fix Scarlet Pierogi item name", BnCDataFixer.createRenamer("brewinandchewin:scarlet_pierogies", "brewinandchewin:scarlet_pierogi")));
        builder.addFixer((DataFix)new NamespacedTypeRenameFix(schema2, "Rename Scarlet Pierogi recipe", References.RECIPE, BnCDataFixer.createRenamer("brewinandchewin:cooking/scarlet_pierogies", "brewinandchewin:cooking/scarlet_pierogi")));
        Schema schema100 = builder.addSchema(100, SAME_NAMESPACED);
        return builder.build().fixer();
    }

    private static UnaryOperator<String> createRenamer(String original, String newName) {
        return name -> name.equals(original) ? newName : name;
    }

    public <T> Dynamic<T> updateWithFixers(DataFixTypes types, Dynamic<T> dynamic) {
        return this.fixer.update(((DataFixTypesAccessor)types).brewinandchewin$getType(), dynamic, BnCDataFixer.getModDataVersion(dynamic), 100);
    }

    public static <T> int getModDataVersion(Dynamic<T> dynamic) {
        return dynamic.get("brewinandchewin:data_version").asInt(0);
    }

    public static int getModDataVersion(CompoundTag tag) {
        return tag.getInt("brewinandchewin:data_version");
    }

    public static CompoundTag setModDataVersion(CompoundTag tag) {
        tag.putInt("brewinandchewin:data_version", 100);
        return tag;
    }
}

