/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.network.serverbound;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;

public record EMIFillPouringRecipeServerboundPacket(int syncId, int action, List<ItemStack> stacks) implements CustomPacketPayload
{
    public static final ResourceLocation ID = BrewinAndChewin.asResource("emi_fill_pouring_recipe");
    public static final CustomPacketPayload.Type<EMIFillPouringRecipeServerboundPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, EMIFillPouringRecipeServerboundPacket> STREAM_CODEC = StreamCodec.of(EMIFillPouringRecipeServerboundPacket::encode, EMIFillPouringRecipeServerboundPacket::new);

    public EMIFillPouringRecipeServerboundPacket(KegMenu menu, int action, List<ItemStack> stacks) {
        this(menu.containerId, action, stacks);
    }

    public EMIFillPouringRecipeServerboundPacket(RegistryFriendlyByteBuf buf) {
        this(buf.readInt(), (int)buf.readByte(), (List<ItemStack>)((List)ItemStack.LIST_STREAM_CODEC.decode((Object)buf)));
    }

    public static void encode(RegistryFriendlyByteBuf buf, EMIFillPouringRecipeServerboundPacket packet) {
        buf.writeInt(packet.syncId);
        buf.writeByte(packet.action);
        ItemStack.LIST_STREAM_CODEC.encode((Object)buf, packet.stacks);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(ServerPlayer sender) {
        sender.getServer().execute(() -> {
            if (!BrewinAndChewin.getHelper().isModLoaded("emi")) {
                return;
            }
            AbstractContainerMenu menu = sender.containerMenu;
            if (menu.containerId != this.syncId || !(menu instanceof KegMenu)) {
                BrewinAndChewin.LOG.error("Attempted to transfer fermenting recipe to an incorrect menu");
                return;
            }
            KegMenu kegMenu = (KegMenu)menu;
            ArrayList rubble = Lists.newArrayList();
            try {
                for (ItemStack stack : this.stacks) {
                    if (stack.isEmpty()) continue;
                    int gotten = EMIFillPouringRecipeServerboundPacket.grabMatching(kegMenu, (Player)sender, List.of(menu.getSlot(4)), rubble, stack);
                    if (gotten != stack.getCount()) {
                        if (gotten > 0) {
                            stack.setCount(gotten);
                            sender.getInventory().placeItemBackInInventory(stack);
                        }
                        break;
                    }
                    Slot s = menu.getSlot(5);
                    for (ItemStack item : kegMenu.blockEntity.extractInGui(stack, gotten)) {
                        if ((s.getItem().isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)s.getItem())) && s.getItem().getCount() < item.getMaxStackSize() && s.getItem().getCount() + item.getCount() < s.getMaxStackSize()) {
                            s.set(item);
                            continue;
                        }
                        sender.getInventory().placeItemBackInInventory(item);
                    }
                    if (this.action == 1) {
                        menu.clicked(5, 0, ClickType.PICKUP, (Player)sender);
                        continue;
                    }
                    if (this.action != 2) continue;
                    menu.clicked(5, 0, ClickType.QUICK_MOVE, (Player)sender);
                }
            }
            finally {
                for (ItemStack stack : rubble) {
                    sender.getInventory().placeItemBackInInventory(stack);
                }
            }
        });
    }

    private static int grabMatching(KegMenu menu, Player player, List<Slot> crafting, List<ItemStack> rubble, ItemStack stack) {
        int amount = stack.getCount();
        int grabbed = 0;
        for (int i = 0; i < rubble.size(); ++i) {
            if (grabbed >= amount) {
                return grabbed;
            }
            ItemStack r = rubble.get(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)r)) continue;
            int wanted = amount - grabbed;
            if (r.getCount() <= wanted) {
                grabbed += r.getCount();
                rubble.remove(i);
                --i;
                continue;
            }
            grabbed = amount;
            r.setCount(r.getCount() - wanted);
        }
        for (Slot s : menu.slots) {
            ItemStack st;
            if (grabbed >= amount) {
                return grabbed;
            }
            if (crafting.contains(s) || !s.mayPickup(player) || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)(st = s.getItem()))) continue;
            int wanted = amount - grabbed;
            ItemStack taken = st.copy();
            if (st.getCount() <= wanted) {
                grabbed += st.getCount();
                s.setByPlayer(ItemStack.EMPTY);
            } else {
                grabbed = amount;
                st.setCount(st.getCount() - wanted);
            }
            s.onTake(player, taken);
        }
        return grabbed;
    }
}

