/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.loot.condition;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.access.LootParamsParamSetAccess;
import umpaz.brewinandchewin.common.mixin.LootContextAccessor;
import umpaz.brewinandchewin.common.mixin.LootParamsAccessor;

public class AreaLocationCheckCondition
implements LootItemCondition {
    public static final MapCodec<AreaLocationCheckCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LootItemCondition.DIRECT_CODEC.listOf().fieldOf("terms").forGetter(cond -> cond.terms), (App)ExtraCodecs.POSITIVE_INT.fieldOf("range").forGetter(cond -> cond.range)).apply((Applicative)inst, AreaLocationCheckCondition::new));
    public static final ResourceLocation ID = BrewinAndChewin.asResource("area_location_check");
    public static final LootItemConditionType TYPE = new LootItemConditionType(CODEC);
    protected final List<LootItemCondition> terms;
    private final Predicate<LootContext> composedPredicate;
    private final int range;

    protected AreaLocationCheckCondition(List<LootItemCondition> predicates, int range) {
        this.terms = predicates;
        this.composedPredicate = Util.allOf(this.terms);
        this.range = range;
    }

    public LootItemConditionType getType() {
        return TYPE;
    }

    public boolean test(LootContext context) {
        Vec3 vec3 = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
        for (int x = -this.range; x <= this.range; ++x) {
            for (int y = -this.range; y <= this.range; ++y) {
                for (int z = -this.range; z <= this.range; ++z) {
                    LootContext newCtx;
                    Vec3 offset = vec3.add((double)x, (double)y, (double)z);
                    LootParams.Builder paramBuilder = new LootParams.Builder(context.getLevel());
                    LootParams originalParams = ((LootContextAccessor)context).brewinandchewin$getParams();
                    for (Map.Entry<LootContextParam<?>, Object> entry : ((LootParamsAccessor)originalParams).brewinandchewin$getParams().entrySet()) {
                        paramBuilder.withParameter(entry.getKey(), entry.getValue());
                    }
                    paramBuilder.withParameter(LootContextParams.ORIGIN, (Object)offset);
                    if (context.hasParam(LootContextParams.BLOCK_STATE)) {
                        paramBuilder.withOptionalParameter(LootContextParams.BLOCK_STATE, (Object)context.getLevel().getBlockState(BlockPos.containing((Position)offset)));
                    }
                    if (context.hasParam(LootContextParams.BLOCK_ENTITY)) {
                        paramBuilder.withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)context.getLevel().getBlockEntity(BlockPos.containing((Position)offset)));
                    }
                    if (!this.composedPredicate.test(newCtx = new LootContext.Builder(paramBuilder.create(((LootParamsParamSetAccess)originalParams).brewinandchewin$getParamSet())).create(Optional.empty()))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.ORIGIN);
    }

    public void validate(ValidationContext pContext) {
        super.validate(pContext);
        for (int i = 0; i < this.terms.size(); ++i) {
            this.terms.get(i).validate(pContext.forChild(".term[" + i + "]"));
        }
    }

    public static LootItemCondition.Builder checkArea(int range, LootItemCondition.Builder ... predicateBuilder) {
        return () -> new AreaLocationCheckCondition(Arrays.stream(predicateBuilder).map(LootItemCondition.Builder::build).toList(), range);
    }
}

