/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.RecipeSerializer;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCRecipeSerializers;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.common.utility.KegRecipeWrapper;

public class CreatePotionPouringRecipe
extends KegPouringRecipe {
    public CreatePotionPouringRecipe(Optional<ItemStack> container, ItemStack result, long amount, Optional<FluidUnit> unit, boolean canFill) {
        super(new AbstractedFluidStack(BrewinAndChewin.getHelper().getCreatePotionFluid(), amount), container, result, unit, false, canFill);
    }

    @Override
    public ItemStack assemble(KegRecipeWrapper recipeWrapper, HolderLookup.Provider provider) {
        ItemStack stack = super.getResultItem(provider).copy();
        AbstractedFluidStack fluidStack = recipeWrapper.getFluid();
        if (fluidStack.components().has(DataComponents.POTION_CONTENTS) && fluidStack.components().get(DataComponents.POTION_CONTENTS) != PotionContents.EMPTY) {
            stack.set(DataComponents.POTION_CONTENTS, (Object)((PotionContents)fluidStack.components().get(DataComponents.POTION_CONTENTS)));
        }
        return stack;
    }

    @Override
    public AbstractedFluidStack getFluid(ItemStack container) {
        AbstractedFluidStack fluidStack = super.getFluid(container);
        DataComponentPatch.Builder patch = DataComponentPatch.builder();
        for (Map.Entry entry : container.getComponentsPatch().entrySet()) {
            patch.set((DataComponentType)entry.getKey(), ((Optional)entry.getValue()).get());
        }
        if (container.has(DataComponents.POTION_CONTENTS) && container.get(DataComponents.POTION_CONTENTS) != PotionContents.EMPTY) {
            patch.set(DataComponents.POTION_CONTENTS, (Object)((PotionContents)container.get(DataComponents.POTION_CONTENTS)));
        }
        return new AbstractedFluidStack(fluidStack.fluid(), fluidStack.amount(), (DataComponentMap)PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)patch.build()), this.getUnit());
    }

    @Override
    public boolean isSpecial() {
        return true;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return BnCRecipeSerializers.CREATE_POTION_POURING;
    }

    public static class Serializer
    implements RecipeSerializer<CreatePotionPouringRecipe> {
        public static final MapCodec<CreatePotionPouringRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ItemStack.CODEC.optionalFieldOf("container").forGetter(KegPouringRecipe::getRawContainer), (App)ItemStack.CODEC.fieldOf("output").forGetter(KegPouringRecipe::getOutput), (App)Codec.LONG.fieldOf("fluid_amount").forGetter(pouringRecipe -> pouringRecipe.getRawFluid().amount()), (App)FluidUnit.CODEC.optionalFieldOf("unit").forGetter(KegPouringRecipe::getRawUnit), (App)Codec.BOOL.optionalFieldOf("can_fill", (Object)true).forGetter(KegPouringRecipe::canFill)).apply((Applicative)inst, CreatePotionPouringRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CreatePotionPouringRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public static CreatePotionPouringRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            Optional container = (Optional)ByteBufCodecs.optional((StreamCodec)ItemStack.STREAM_CODEC).decode((Object)buf);
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            long amount = buf.readLong();
            Optional unit = (Optional)ByteBufCodecs.optional(FluidUnit.STREAM_CODEC).decode((Object)buf);
            boolean canFill = buf.readBoolean();
            return new CreatePotionPouringRecipe(container, output, amount, unit, canFill);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, CreatePotionPouringRecipe recipe) {
            ByteBufCodecs.optional((StreamCodec)ItemStack.STREAM_CODEC).encode((Object)buf, recipe.getRawContainer());
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.getOutput());
            buf.writeLong(recipe.getRawFluid().amount());
            ByteBufCodecs.optional(FluidUnit.STREAM_CODEC).encode((Object)buf, recipe.getRawUnit());
            ByteBufCodecs.BOOL.encode((Object)buf, (Object)recipe.canFill());
        }

        public MapCodec<CreatePotionPouringRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CreatePotionPouringRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

