/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.block.KegBlock;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.block.entity.container.SidedKegWrapper;
import umpaz.brewinandchewin.common.container.AbstractedFluidTank;
import umpaz.brewinandchewin.common.container.AbstractedItemHandler;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCBlockEntityTypes;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.tag.BnCTags;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.BnCTextUtils;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.common.utility.KegRecipeWrapper;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class KegBlockEntity
extends SyncedBlockEntity
implements MenuProvider,
Nameable,
RecipeCraftingHolder {
    public static final int CONTAINER_SLOT = 4;
    public static final int OUTPUT_SLOT = 5;
    public static final int INVENTORY_SIZE = 6;
    public static final int RANGE = 2;
    private final AbstractedItemHandler inventory = this.createHandler();
    private final SidedKegWrapper inputHandler = BrewinAndChewin.getHelper().createSidedKegWrapper(this.inventory, Direction.UP);
    private final SidedKegWrapper outputHandler = BrewinAndChewin.getHelper().createSidedKegWrapper(this.inventory, Direction.DOWN);
    private final AbstractedFluidTank fluidTank = this.createFluidTank();
    private final KegRecipeWrapper recipeWrapper;
    private int fermentTime;
    private int fermentTimeTotal;
    private Component customName;
    private boolean deferFluidExtraction = false;
    private boolean currentlyOperating = false;
    public int kegTemperature;
    private boolean initialisedTemperature = false;
    protected final ContainerData kegData = this.createIntArray();
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipeTracker = new Object2IntOpenHashMap();
    private ResourceLocation lastRecipeID;
    private boolean checkNewRecipe = true;

    public KegBlockEntity(BlockPos pos, BlockState state) {
        super(BnCBlockEntityTypes.KEG, pos, state);
        this.recipeWrapper = BrewinAndChewin.getHelper().createRecipeWrapper(this.inventory, this.fluidTank);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.inventory.readFromNbt(compound.getCompound("Inventory"), provider);
        this.fluidTank.readFromNbt(compound.getCompound("FluidTank"), provider);
        this.fermentTime = compound.getInt("FermentTime");
        this.fermentTimeTotal = compound.getInt("FermentTimeTotal");
        if (compound.contains("CustomName", 8)) {
            this.customName = Component.Serializer.fromJson((String)compound.getString("CustomName"), (HolderLookup.Provider)provider);
        }
        CompoundTag compoundRecipes = compound.getCompound("RecipesUsed");
        for (String key : compoundRecipes.getAllKeys()) {
            this.usedRecipeTracker.put((Object)ResourceLocation.tryParse((String)key), compoundRecipes.getInt(key));
        }
        if (compound.contains("Temperature", 3)) {
            this.kegTemperature = compound.getInt("Temperature");
        }
        this.checkNewRecipe = true;
    }

    public static AbstractedFluidStack getMealFromItem(ItemStack kegStack, HolderLookup.Provider provider) {
        if (!kegStack.is(BnCItems.KEG)) {
            return AbstractedFluidStack.EMPTY;
        }
        CustomData data = (CustomData)kegStack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = data.copyTag();
        if (!tag.isEmpty() && tag.contains("FluidTank")) {
            return (AbstractedFluidStack)AbstractedFluidStack.CODEC.decode((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)provider), (Object)tag.get("FluidTank")).mapOrElse(Pair::getFirst, pairError -> AbstractedFluidStack.EMPTY);
        }
        return AbstractedFluidStack.EMPTY;
    }

    public AbstractedFluidStack getOutput() {
        return this.fluidTank.getAbstractedFluid();
    }

    public SidedKegWrapper getSidedHandler(Direction direction) {
        if (direction == Direction.UP) {
            return this.inputHandler;
        }
        return this.outputHandler;
    }

    public CustomData writeMeal(CompoundTag tag, HolderLookup.Provider provider) {
        AbstractedItemHandler drops = BrewinAndChewin.getHelper().createKegInventory(6, (handler, integer) -> {});
        for (int i = 0; i < 6; ++i) {
            drops.setStackInSlot(i, i == 4 ? this.inventory.getStackInSlot(i) : ItemStack.EMPTY);
        }
        if (this.customName != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)provider));
        }
        tag.put("Inventory", (Tag)drops.writeToNbt(provider));
        if (!this.fluidTank.isEmpty()) {
            tag.put("FluidTank", (Tag)this.fluidTank.writeToNbt(provider));
        }
        return CustomData.of((CompoundTag)tag);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("Inventory", (Tag)this.inventory.writeToNbt(provider));
        compound.put("FluidTank", (Tag)this.fluidTank.writeToNbt(provider));
        compound.putInt("FermentTime", this.fermentTime);
        compound.putInt("FermentTimeTotal", this.fermentTimeTotal);
        if (this.customName != null) {
            compound.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)provider));
        }
        CompoundTag compoundRecipes = new CompoundTag();
        this.usedRecipeTracker.forEach((recipeId, craftedAmount) -> compoundRecipes.putInt(recipeId.toString(), craftedAmount.intValue()));
        compound.put("RecipesUsed", (Tag)compoundRecipes);
    }

    private CompoundTag writeUpdateTag(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("Inventory", (Tag)this.inventory.writeToNbt(provider));
        compound.put("FluidTank", (Tag)this.fluidTank.writeToNbt(provider));
        compound.putInt("FermentTime", this.fermentTime);
        compound.putInt("FermentTimeTotal", this.fermentTimeTotal);
        compound.putInt("Temperature", this.kegTemperature);
        return compound;
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        components.set(DataComponents.CUSTOM_DATA, (Object)this.writeMeal(new CompoundTag(), (HolderLookup.Provider)this.level.registryAccess()));
    }

    public CompoundTag writeDrink(CompoundTag compound, HolderLookup.Provider provider) {
        if (this.customName != null) {
            compound.putString("CustomName", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)provider));
        }
        if (!this.fluidTank.isEmpty()) {
            compound.put("FluidTank", (Tag)this.fluidTank.writeToNbt(provider));
        }
        return compound;
    }

    public static boolean isValidTemp(int kegTemp, int want) {
        return switch (want) {
            case 1 -> {
                if (kegTemp <= 1) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (kegTemp <= 2) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (kegTemp < 5 && kegTemp > 1) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (kegTemp >= 4) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (kegTemp >= 5) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    protected boolean canFerment(KegFermentingRecipe recipe, KegBlockEntity keg) {
        if (!this.hasInput()) {
            return false;
        }
        if (this.level == null) {
            return false;
        }
        if (!KegBlockEntity.isValidTemp(keg.getTemperature(), recipe.getTemperature())) {
            return false;
        }
        if (recipe.getFluidIngredient().isEmpty()) {
            return keg.fluidTank.isEmpty();
        }
        if (!recipe.getFluidIngredient().get().ingredient().matches(keg.fluidTank.getAbstractedFluid())) {
            return false;
        }
        return keg.fluidTank.getAbstractedFluid().amount() % recipe.getFluidIngredient().get().amount() == 0L;
    }

    public static void fermentingTick(Level level, BlockPos pos, BlockState state, KegBlockEntity keg) {
        boolean didInventoryChange = false;
        if (level.getGameTime() % 80L == 0L) {
            keg.updateTemperature();
        }
        if (keg.deferFluidExtraction) {
            keg.deferFluidExtraction = false;
            List<ItemStack> out = keg.extractInGui(keg.inventory.getStackInSlot(4), keg.inventory.getSlotLimit(5));
            if (!out.isEmpty()) {
                keg.inventory.insertItem(5, out.getFirst(), false);
            }
        }
        if (keg.hasInput()) {
            Optional<RecipeHolder<KegFermentingRecipe>> recipe = keg.getMatchingRecipe(keg.recipeWrapper);
            if (recipe.isPresent()) {
                if (keg.canFerment((KegFermentingRecipe)recipe.get().value(), keg)) {
                    didInventoryChange = keg.processFermenting((KegFermentingRecipe)recipe.get().value(), keg);
                } else {
                    keg.fermentTime = Math.max(0, keg.fermentTime - 20);
                }
            } else {
                keg.fermentTime = Math.max(0, keg.fermentTime - 20);
            }
        } else if (keg.fermentTime > 0) {
            keg.fermentTime = Math.max(0, keg.fermentTime - 20);
        }
        if (didInventoryChange) {
            keg.inventoryChanged();
        }
    }

    public Optional<RecipeHolder<KegFermentingRecipe>> getRecipeWithoutTemperature() {
        if (!this.hasInput()) {
            return Optional.empty();
        }
        Optional<RecipeHolder<KegFermentingRecipe>> recipe = this.getMatchingRecipe(this.recipeWrapper);
        if (recipe.isEmpty()) {
            return Optional.empty();
        }
        if (((KegFermentingRecipe)recipe.get().value()).getFluidIngredient().isEmpty()) {
            if (!this.fluidTank.isEmpty()) {
                return Optional.empty();
            }
        } else {
            if (!((KegFermentingRecipe)recipe.get().value()).getFluidIngredient().get().ingredient().matches(this.fluidTank.getAbstractedFluid())) {
                return Optional.empty();
            }
            if (this.fluidTank.getAbstractedFluid().amount() % ((KegFermentingRecipe)recipe.get().value()).getFluidIngredient().get().amount() != 0L) {
                return Optional.empty();
            }
        }
        return recipe;
    }

    private Optional<RecipeHolder<KegFermentingRecipe>> getMatchingRecipe(KegRecipeWrapper inventoryWrapper) {
        Optional recipe;
        if (this.level == null) {
            return Optional.empty();
        }
        if (this.checkNewRecipe && (recipe = this.level.getRecipeManager().getAllRecipesFor(BnCRecipeTypes.FERMENTING).stream().filter(a -> ((KegFermentingRecipe)a.value()).matches(inventoryWrapper, this.level)).findFirst()).isPresent()) {
            ResourceLocation newRecipeID = recipe.get().id();
            if (this.lastRecipeID != null && !this.lastRecipeID.equals((Object)newRecipeID)) {
                this.fermentTime = 0;
            }
            this.lastRecipeID = newRecipeID;
            return recipe;
        }
        this.checkNewRecipe = false;
        if (this.lastRecipeID != null && (recipe = this.level.getRecipeManager().getRecipeFor(BnCRecipeTypes.FERMENTING, (RecipeInput)inventoryWrapper, this.level, this.lastRecipeID)).isPresent() && ((KegFermentingRecipe)((RecipeHolder)recipe.get()).value()).matches(inventoryWrapper, this.level)) {
            return recipe;
        }
        return Optional.empty();
    }

    private boolean hasInput() {
        for (int i = 0; i < 5; ++i) {
            if (this.inventory.getStackInSlot(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean processFermenting(KegFermentingRecipe recipe, KegBlockEntity keg) {
        if (this.level == null) {
            return false;
        }
        ++this.fermentTime;
        this.fermentTimeTotal = recipe.getFermentTime();
        if (this.fermentTime < this.fermentTimeTotal) {
            this.setChanged();
            return false;
        }
        this.fermentTime = 0;
        if (recipe.getResult().left().isPresent()) {
            this.deferFluidExtraction = true;
            keg.fluidTank.setAbstractedFluid((AbstractedFluidStack)recipe.getResult().left().get());
            if (!keg.level.isClientSide()) {
                Vec3 center = keg.getBlockPos().getCenter();
                keg.level.playSound(null, center.x(), center.y(), center.z(), SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 0.6f, 0.8f);
            }
        }
        if (recipe.getResult().right().isPresent()) {
            if (recipe.getFluidIngredient().isPresent()) {
                keg.fluidTank.drain(recipe.getFluidIngredient().get().amount(), recipe.getUnit(), false);
            }
            keg.inventory.insertItem(5, ((ItemStack)recipe.getResult().right().get()).copy(), false);
        }
        for (int i = 0; i < 5; ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (!BrewinAndChewin.getHelper().getCraftingRemainingItem(slotStack).isEmpty()) {
                this.ejectIngredientRemainder(BrewinAndChewin.getHelper().getCraftingRemainingItem(slotStack));
            }
            this.inventory.extractItem(i, 1, false);
        }
        return true;
    }

    public List<ItemStack> extractInGui(ItemStack slotIn, int maxTakeAmount) {
        return this.fluidExtract(slotIn, maxTakeAmount, true, false);
    }

    public List<ItemStack> extractInWorld(ItemStack slotIn, int maxTakeAmount, boolean isCreative) {
        return this.fluidExtract(slotIn, maxTakeAmount, false, isCreative);
    }

    private List<ItemStack> fluidExtract(ItemStack slotIn, int maxTakeAmount, boolean inGui, boolean isCreative) {
        if (slotIn.isEmpty() || this.deferFluidExtraction || this.inventory.getStackInSlot(5).getCount() >= Math.min(this.inventory.getSlotLimit(5), this.inventory.getStackInSlot(5).getMaxStackSize())) {
            return List.of();
        }
        Optional<KegPouringRecipe> recipe = this.getPouringRecipe(slotIn);
        boolean changed = false;
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        this.currentlyOperating = true;
        if (recipe.isPresent() && (this.fluidTank.isEmpty() || this.fluidTank.getAbstractedFluid().fluid() == recipe.get().getRawFluid().fluid())) {
            ItemStack resultItem = recipe.get().assemble(this.recipeWrapper, (HolderLookup.Provider)this.level.registryAccess());
            if (ItemStack.isSameItem((ItemStack)slotIn, (ItemStack)recipe.get().getContainer(resultItem)) && recipe.get().getRawFluid().amount() <= this.fluidTank.getAbstractedFluid().amount() && (!inGui || this.inventory.getStackInSlot(5).isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)resultItem, (ItemStack)this.inventory.getStackInSlot(5)))) {
                containerAmount = (int)Mth.clamp((long)Math.min(Math.min(slotIn.getCount(), resultItem.getMaxStackSize()), maxTakeAmount), (long)1L, (long)(this.fluidTank.getAbstractedFluid().amount() / recipe.get().getLoaderAmount()));
                this.fluidTank.drain(recipe.get().getRawFluid().amount() * (long)containerAmount, recipe.get().getUnit(), false);
                if (!isCreative) {
                    for (long overflow = (long)containerAmount; !(overflow <= 0L || inGui && !outputs.isEmpty() || slotIn.isEmpty()); overflow -= (long)newResult.getCount()) {
                        newResult = resultItem.copyWithCount((int)Math.min((long)Math.min(slotIn.getCount(), maxTakeAmount), overflow));
                        outputs.add(newResult);
                        slotIn.shrink(newResult.getCount());
                    }
                    if (!slotIn.isEmpty()) {
                        outputs.add(slotIn);
                    }
                } else {
                    outputs.add(slotIn);
                }
                changed = true;
            } else if (recipe.filter(KegPouringRecipe::canFill).isPresent() && (recipe.get().isStrict() && ItemStack.isSameItemSameComponents((ItemStack)resultItem, (ItemStack)slotIn) || !recipe.get().isStrict() && ItemStack.isSameItem((ItemStack)slotIn, (ItemStack)resultItem)) && (this.fluidTank.isEmpty() || this.fluidTank.getAbstractedFluid().matches(recipe.get().getFluid(slotIn)) && this.fluidTank.getAbstractedFluid().amount() < this.fluidTank.getFluidCapacity()) && (!inGui || this.inventory.getStackInSlot(5).isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)recipe.get().getContainer(slotIn), (ItemStack)this.inventory.getStackInSlot(5)))) {
                containerAmount = (int)Mth.clamp((long)Math.min((long)Math.min(slotIn.getCount(), recipe.get().getContainer(slotIn).getMaxStackSize()), this.fluidTank.getFluidCapacity() / recipe.get().getLoaderAmount()), (long)1L, (long)maxTakeAmount);
                this.fluidTank.fill(new AbstractedFluidStack(recipe.get().getFluid(slotIn).fluid(), recipe.get().getRawFluid().amount() * (long)containerAmount, recipe.get().getFluid(slotIn).components(), recipe.get().getUnit(), null), false);
                if (!isCreative) {
                    ItemStack recipeItem = recipe.get().getContainer(slotIn);
                    for (int overflow = containerAmount; overflow > 0 && !slotIn.isEmpty(); overflow -= newResult.getCount()) {
                        newResult = recipeItem.copyWithCount(Math.min(Math.min(slotIn.getCount(), maxTakeAmount), overflow));
                        outputs.add(newResult);
                        slotIn.shrink(newResult.getCount());
                    }
                    if (!slotIn.isEmpty()) {
                        outputs.add(slotIn);
                    }
                } else {
                    outputs.add(slotIn);
                }
                changed = true;
            }
            if (changed) {
                this.inventoryChanged();
            }
        }
        if (!outputs.isEmpty() || recipe.isPresent()) {
            this.inventory.commitModifiedStacks();
            this.currentlyOperating = false;
            return outputs;
        }
        AbstractedFluidTank itemFluidContainer = BrewinAndChewin.getHelper().getFluidContainerFromItem(slotIn);
        if (itemFluidContainer != null && !slotIn.isEmpty()) {
            if ((this.fluidTank.getAbstractedFluid().matches(itemFluidContainer.getAbstractedFluid()) || this.fluidTank.getAbstractedFluid().isEmpty()) && (!inGui || this.inventory.getStackInSlot(5).isEmpty() || this.inventory.getStackInSlot(5).is(itemFluidContainer.getContainer().getItem())) && this.level.getRecipeManager().getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().anyMatch(pouringRecipe -> ((KegPouringRecipe)pouringRecipe.value()).getFluid(slotIn).matches(this.fluidTank.getAbstractedFluid()))) {
                long amountToDrain = this.fluidTank.getFluidCapacity() - this.fluidTank.getAbstractedFluid().amount();
                long amount = this.fluidTank.fill(itemFluidContainer.drain(amountToDrain, FluidUnit.getLoaderUnit(), true), true).amount();
                if (amount <= amountToDrain && amount > 0L) {
                    this.fluidTank.fill(itemFluidContainer.drain(amountToDrain, FluidUnit.getLoaderUnit(), true), true);
                    if (!isCreative) {
                        ItemStack newResult;
                        ItemStack recipeItem = BrewinAndChewin.getHelper().getCraftingRemainingItem(slotIn).isEmpty() ? itemFluidContainer.getContainer() : BrewinAndChewin.getHelper().getCraftingRemainingItem(slotIn);
                        for (int overflow = (int)(amount / this.fluidTank.getFluidCapacity()); overflow > 0 && !slotIn.isEmpty(); overflow -= newResult.getCount()) {
                            newResult = recipeItem.copyWithCount(Math.min(Math.min(slotIn.getCount(), maxTakeAmount), overflow));
                            outputs.add(newResult);
                            slotIn.shrink(newResult.getCount());
                        }
                    } else {
                        outputs.add(slotIn);
                    }
                    this.setChanged();
                    this.inventoryChanged();
                }
            } else if (!this.fluidTank.getAbstractedFluid().isEmpty() && itemFluidContainer.isFluidValid(this.fluidTank.getAbstractedFluid()) && (!inGui || this.inventory.getStackInSlot(5).isEmpty() || this.inventory.getStackInSlot(5).is(itemFluidContainer.getContainer().getItem()))) {
                long amountToDrain = itemFluidContainer.getFluidCapacity();
                itemFluidContainer = BrewinAndChewin.getHelper().getFluidContainerFromItem(slotIn.copyWithCount((int)(amountToDrain / itemFluidContainer.getFluidCapacity())));
                long amount = itemFluidContainer.fill(this.fluidTank.drain(amountToDrain, FluidUnit.getLoaderUnit(), true), true).amount();
                if (amount > 0L) {
                    itemFluidContainer.fill(this.fluidTank.drain(amountToDrain, FluidUnit.getLoaderUnit(), false), false);
                    if (amount <= amountToDrain) {
                        outputs.add(slotIn);
                        this.setChanged();
                        this.inventoryChanged();
                    }
                }
            }
        }
        this.inventory.commitModifiedStacks();
        this.currentlyOperating = false;
        return outputs;
    }

    public Optional<KegPouringRecipe> getPouringRecipe(ItemStack slot) {
        if (this.level == null) {
            return Optional.empty();
        }
        return this.level.getRecipeManager().getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().map(RecipeHolder::value).sorted(Comparator.comparingInt(value -> value.isStrict() ? 0 : 1)).filter(r -> {
            boolean containerCheck = false;
            boolean resultCheck = false;
            boolean fluidCheck = false;
            if (r.isStrict() && ItemStack.isSameItemSameComponents((ItemStack)r.getContainer(), (ItemStack)slot) || !r.isStrict() && r.getContainer().getItem() == slot.getItem()) {
                containerCheck = true;
            }
            if (!containerCheck && r.canFill() && (r.isStrict() && ItemStack.isSameItemSameComponents((ItemStack)r.assemble(this.recipeWrapper, (HolderLookup.Provider)this.level.registryAccess()), (ItemStack)slot) || !r.isStrict() && r.assemble(this.recipeWrapper, (HolderLookup.Provider)this.level.registryAccess()).getItem() == slot.getItem())) {
                resultCheck = true;
            }
            if (this.recipeWrapper.getFluid().isEmpty() || containerCheck && r.getRawFluid().fluid() == this.recipeWrapper.getFluid().fluid() || r.getFluid(slot).matches(this.recipeWrapper.getFluid())) {
                fluidCheck = true;
            }
            return (containerCheck || resultCheck) && fluidCheck;
        }).findFirst();
    }

    public void updateTemperature() {
        Holder biome;
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    states.add(this.level.getBlockState(this.worldPosition.offset(x, y, z)));
                }
            }
        }
        int heat = states.stream().filter(s -> s.is(ModTags.HEAT_SOURCES) && s.hasProperty((Property)BlockStateProperties.LIT)).filter(s -> (Boolean)s.getValue((Property)BlockStateProperties.LIT)).mapToInt(s -> 1).sum();
        heat += states.stream().filter(s -> s.is(ModTags.HEAT_SOURCES) && !s.hasProperty((Property)BlockStateProperties.LIT)).mapToInt(s -> 1).sum();
        int cold = states.stream().filter(s -> s.is(BnCTags.Blocks.FREEZE_SOURCES) && s.hasProperty((Property)BlockStateProperties.LIT)).filter(s -> s.hasProperty((Property)BlockStateProperties.LIT)).filter(s -> (Boolean)s.getValue((Property)BlockStateProperties.LIT)).mapToInt(s -> 1).sum();
        cold += states.stream().filter(s -> s.is(BnCTags.Blocks.FREEZE_SOURCES) && !s.hasProperty((Property)BlockStateProperties.LIT)).mapToInt(s -> 1).sum();
        if (((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().biomeTemp() && (biome = this.level.getBiome(this.worldPosition)).isBound()) {
            float biomeTemperature = ((Biome)biome.value()).getBaseTemperature();
            if (biomeTemperature <= 0.0f) {
                ++cold;
            } else if (biomeTemperature == 2.0f) {
                ++heat;
            }
        }
        int temp = heat - cold;
        if (((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().dimTemp() && this.level.dimensionType().ultraWarm()) {
            temp += 2;
        }
        if (!this.initialisedTemperature || temp != this.kegTemperature) {
            this.kegTemperature = temp;
            this.initialisedTemperature = true;
            this.inventoryChanged();
        }
    }

    public int getTemperature() {
        if (this.kegTemperature <= -((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().cold()) {
            return 1;
        }
        if (this.kegTemperature <= -((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().chilly()) {
            return 2;
        }
        if (this.kegTemperature < ((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().warm()) {
            return 3;
        }
        if (this.kegTemperature < ((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().hot()) {
            return 4;
        }
        return 5;
    }

    protected void ejectIngredientRemainder(ItemStack remainderStack) {
        Direction direction = ((Direction)this.getBlockState().getValue((Property)KegBlock.FACING)).getCounterClockWise();
        double x = (double)this.worldPosition.getX() + 0.5 + (double)direction.getStepX() * 0.25;
        double y = (double)this.worldPosition.getY() + 0.7;
        double z = (double)this.worldPosition.getZ() + 0.5 + (double)direction.getStepZ() * 0.25;
        ItemUtils.spawnItemEntity((Level)this.level, (ItemStack)remainderStack, (double)x, (double)y, (double)z, (double)((float)direction.getStepX() * 0.08f), (double)0.25, (double)((float)direction.getStepZ() * 0.08f));
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceLocation recipeID = recipe.id();
            this.usedRecipeTracker.addTo((Object)recipeID, 1);
        }
    }

    @Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(Player player, List<ItemStack> items) {
        List<RecipeHolder<?>> usedRecipes = this.getUsedRecipesAndPopExperience(player.level(), player.position());
        player.awardRecipes(usedRecipes);
        this.usedRecipeTracker.clear();
    }

    public List<RecipeHolder<?>> getUsedRecipesAndPopExperience(Level level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipeTracker.object2IntEntrySet()) {
            level.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                KegBlockEntity.splitAndSpawnExperience((ServerLevel)level, pos, entry.getIntValue(), ((KegFermentingRecipe)recipe.value()).getExperience());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(ServerLevel level, Vec3 pos, int craftedAmount, float experience) {
        int expTotal = Mth.floor((float)((float)craftedAmount * experience));
        float expFraction = Mth.frac((float)((float)craftedAmount * experience));
        if (expFraction > 0.0f && Math.random() < (double)expFraction) {
            ++expTotal;
        }
        ExperienceOrb.award((ServerLevel)level, (Vec3)pos, (int)expTotal);
    }

    public AbstractedItemHandler getInventory() {
        return this.inventory;
    }

    public AbstractedFluidTank getFluidTank() {
        return this.fluidTank;
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.create();
        for (int i = 0; i < 6; ++i) {
            drops.add((Object)this.inventory.getStackInSlot(i));
        }
        return drops;
    }

    public Component getName() {
        return this.customName != null ? this.customName : BnCTextUtils.getTranslation("container.keg", new Object[0]);
    }

    public Component getDisplayName() {
        return this.getName();
    }

    @Nullable
    public Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public AbstractContainerMenu createMenu(int id, Inventory player, Player entity) {
        return new KegMenu(id, player, this, this.kegData);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.writeUpdateTag(new CompoundTag(), provider);
    }

    private AbstractedItemHandler createHandler() {
        return BrewinAndChewin.getHelper().createKegInventory(6, (handler, slot) -> {
            if (!(this.getLevel().isClientSide() || slot != 4 && slot != 5 || this.currentlyOperating)) {
                this.deferFluidExtraction = true;
            }
            if (slot >= 0 && slot < 5) {
                this.checkNewRecipe = true;
            }
            this.inventoryChanged();
        });
    }

    private AbstractedFluidTank createFluidTank() {
        return BrewinAndChewin.getHelper().createKegTank(((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().localizedCapacity(), () -> {
            List<ItemStack> out;
            AbstractedItemHandler handler = this.inventory;
            if (!(this.getLevel().isClientSide() || this.currentlyOperating || this.deferFluidExtraction || (out = this.extractInGui(handler.getStackInSlot(4), handler.getSlotLimit(5))).isEmpty())) {
                handler.insertItem(5, out.get(0), false);
            }
            this.inventoryChanged();
            this.checkNewRecipe = true;
        });
    }

    private ContainerData createIntArray() {
        return new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> KegBlockEntity.this.fermentTime;
                    case 1 -> KegBlockEntity.this.fermentTimeTotal;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        KegBlockEntity.this.fermentTime = value;
                        break;
                    }
                    case 1: {
                        KegBlockEntity.this.fermentTimeTotal = value;
                    }
                }
            }

            public int getCount() {
                return 3;
            }
        };
    }
}

