/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import umpaz.brewinandchewin.common.registry.BnCItems;

public class PizzaBlock
extends Block {
    public static final IntegerProperty SERVINGS = IntegerProperty.create((String)"servings", (int)0, (int)3);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)8.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)2.0, (double)16.0)), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0)};

    public PizzaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SERVINGS, (Comparable)Integer.valueOf(3)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.getValue((Property)SERVINGS)];
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide && this.takeServing(level, pos, state, player, player.getUsedItemHand()).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        return this.takeServing(level, pos, state, player, player.getUsedItemHand());
    }

    private InteractionResult takeServing(Level level, BlockPos pos, BlockState state, Player player, InteractionHand handIn) {
        int servings = (Integer)state.getValue((Property)SERVINGS);
        ItemStack heldStack = player.getItemInHand(handIn);
        if (heldStack.isEmpty() || heldStack.getItem().equals(BnCItems.PIZZA_SLICE)) {
            if (heldStack.getItem().equals(BnCItems.PIZZA_SLICE) && heldStack.getCount() < heldStack.getMaxStackSize()) {
                heldStack.setCount(heldStack.getCount() + 1);
            } else {
                player.setItemInHand(handIn, new ItemStack((ItemLike)BnCItems.PIZZA_SLICE));
            }
        } else {
            PizzaBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BnCItems.PIZZA_SLICE, 1));
        }
        level.playSound(null, pos, SoundEvents.SLIME_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        if ((Integer)level.getBlockState(pos).getValue((Property)SERVINGS) == 0) {
            level.destroyBlock(pos, false);
        } else if ((Integer)level.getBlockState(pos).getValue((Property)SERVINGS) > 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        return facing == Direction.DOWN && !this.canSurvive(state, (LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, pos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return PizzaBlock.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SERVINGS});
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        return (Integer)blockState.getValue((Property)SERVINGS);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }
}

