/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.BrewinAndChewin;

public class HeatingCaskBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape STEAM_AREA = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);

    public HeatingCaskBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (this.isSpaceAbove(level, pos) && (heldStack.is(Items.WATER_BUCKET) || heldStack.is(Items.POTION) && ((PotionContents)heldStack.get(DataComponents.POTION_CONTENTS)).potion().isPresent() && ((Holder)((PotionContents)heldStack.get(DataComponents.POTION_CONTENTS)).potion().get()).is(Potions.WATER))) {
            for (int i = 0; i < 20; ++i) {
                RandomSource randomsource = level.getRandom();
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), (double)pos.getY() + 1.1, (double)pos.getZ() + 0.5 + randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1), 0.15, randomsource.nextDouble() / 4.0 * (double)(randomsource.nextBoolean() ? 1 : -1));
                if (i % 3 != 0) continue;
                level.playSound(player, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            if (!player.isCreative()) {
                if (heldStack.is(Items.WATER_BUCKET)) {
                    player.setItemInHand(hand, BrewinAndChewin.getHelper().getCraftingRemainingItem(heldStack));
                } else {
                    player.setItemInHand(hand, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.nextInt(5) == 0 && this.isSpaceAbove(level, pos)) {
            level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + 0.5 + random.nextDouble() / 4.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.getY() + 1.1, (double)pos.getZ() + 0.5 + random.nextDouble() / 4.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public boolean isSpaceAbove(Level level, BlockPos pos) {
        if (level != null) {
            BlockState above = level.getBlockState(pos.above());
            return !Shapes.joinIsNotEmpty((VoxelShape)STEAM_AREA, (VoxelShape)above.getShape((BlockGetter)level, pos.above()), (BooleanOp)BooleanOp.AND);
        }
        return true;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

