/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.attachment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.particle.RagingParticleOptions;
import umpaz.brewinandchewin.common.mixin.LivingEntityAccessor;
import umpaz.brewinandchewin.common.network.clientbound.SyncRagingStacksClientboundPacket;
import umpaz.brewinandchewin.common.registry.BnCEffects;

public class RagingAttachment {
    public static final float RESET_TICK_MULTIPLIER = 2.5f;
    public static final ResourceLocation ID = BrewinAndChewin.asResource("raging");
    public static final Codec<RagingAttachment> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("stacks").forGetter(RagingAttachment::getStacks), (App)Codec.INT.fieldOf("ticks_until_reset").forGetter(RagingAttachment::getTicksUntilReset)).apply((Applicative)inst, RagingAttachment::new));
    private int stacks;
    private int ticksUntilReset;
    private int previousStacks = 0;
    private static final ResourceLocation RAGING_ATTRIBUTE_ID = BrewinAndChewin.asResource("raging");

    public RagingAttachment(int stacks, int ticksUntilReset) {
        this.stacks = stacks;
        this.ticksUntilReset = ticksUntilReset;
    }

    public int getStacks() {
        return this.stacks;
    }

    public void setStacks(int value) {
        this.stacks = value;
    }

    public int getTicksUntilReset() {
        return this.ticksUntilReset;
    }

    public void setTicksUntilReset(int value) {
        this.ticksUntilReset = value;
    }

    public static void tick(LivingEntity living) {
        RagingAttachment attachment = BrewinAndChewin.getHelper().getRagingAttachment(living);
        if (attachment == null) {
            return;
        }
        if (!living.level().isClientSide()) {
            if (attachment.getTicksUntilReset() <= 0 && attachment.getStacks() > 0) {
                float f;
                attachment.setStacks(attachment.getStacks() - 1);
                if (living instanceof Player) {
                    Player player = (Player)living;
                    f = player.getCurrentItemAttackStrengthDelay();
                } else {
                    f = 30.0f;
                }
                attachment.setTicksUntilReset(Mth.ceil((float)(2.5f * f)));
            }
            if (attachment.getStacks() <= 0 || !living.hasEffect(BnCEffects.RAGING)) {
                if (living.getAttributes().hasModifier(Attributes.ATTACK_SPEED, RAGING_ATTRIBUTE_ID)) {
                    living.getAttribute(Attributes.ATTACK_SPEED).removeModifier(RAGING_ATTRIBUTE_ID);
                }
                if (attachment.previousStacks != 0) {
                    attachment.previousStacks = 0;
                    BrewinAndChewin.getHelper().setRagingAttachment(living, null);
                    BrewinAndChewin.getHelper().sendClientboundTracking((Entity)living, new SyncRagingStacksClientboundPacket(living.getId(), Optional.empty()));
                }
                ((LivingEntityAccessor)living).brewinandchewin$invokeUpdateEffectVisibility();
                return;
            }
            attachment.setTicksUntilReset(attachment.getTicksUntilReset() - 1);
            if (attachment.previousStacks != attachment.stacks) {
                if (living.getAttributes().hasModifier(Attributes.ATTACK_SPEED, RAGING_ATTRIBUTE_ID)) {
                    living.getAttribute(Attributes.ATTACK_SPEED).removeModifier(RAGING_ATTRIBUTE_ID);
                }
                living.getAttribute(Attributes.ATTACK_SPEED).addTransientModifier(new AttributeModifier(RAGING_ATTRIBUTE_ID, Math.min(0.8, 0.05 * (double)attachment.getStacks() + 0.025 * (double)living.getEffect(BnCEffects.RAGING).getAmplifier() * (double)attachment.getStacks()), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                ((LivingEntityAccessor)living).brewinandchewin$invokeUpdateEffectVisibility();
                BrewinAndChewin.getHelper().sendClientboundTracking((Entity)living, new SyncRagingStacksClientboundPacket(living.getId(), Optional.of(attachment.getStacks())));
            }
            attachment.previousStacks = attachment.stacks;
        }
    }

    public static ParticleOptions getParticleType(int stacks, float size) {
        return switch (stacks) {
            case 0, 1 -> new RagingParticleOptions.StageOne(size);
            case 2 -> new RagingParticleOptions.StageTwo(size);
            case 3 -> new RagingParticleOptions.StageThree(size);
            default -> new RagingParticleOptions.StageFour(size);
        };
    }
}

