/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.utility;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.utility.TagReference;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;

public record FluidItemComponentRemapper(ItemStack baseItem, Map<DataComponentType<?>, Pair<DataComponentType<?>, Map<List<TagReference>, List<TagReference>>>> map) {
    public static final Codec<FluidItemComponentRemapper> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.STRICT_SINGLE_ITEM_CODEC.fieldOf("base").forGetter(FluidItemComponentRemapper::baseItem), (App)Codec.unboundedMap((Codec)BuiltInRegistries.DATA_COMPONENT_TYPE.byNameCodec(), (Codec)ValueCodec.INSTANCE).optionalFieldOf("remaps", Map.of()).forGetter(FluidItemComponentRemapper::map)).apply((Applicative)inst, FluidItemComponentRemapper::new));
    public static final Codec<FluidItemComponentRemapper> CODEC = Codec.withAlternative(DIRECT_CODEC, (Codec)Codec.withAlternative((Codec)ItemStack.STRICT_SINGLE_ITEM_CODEC, (Codec)BuiltInRegistries.ITEM.byNameCodec(), ItemStack::new), stack -> new FluidItemComponentRemapper((ItemStack)stack, Map.of()));

    public ItemStack convert(HolderLookup.Provider lookup, AbstractedFluidStack fluid) throws IllegalStateException {
        ItemStack stack = this.baseItem.copy();
        if (fluid.components().isEmpty()) {
            return stack;
        }
        RegistryOps registryOps = RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)lookup);
        CompoundTag fluidTag = (CompoundTag)DataComponentMap.CODEC.encodeStart((DynamicOps)registryOps, (Object)fluid.components()).getOrThrow();
        CompoundTag itemTag = (CompoundTag)DataComponentMap.CODEC.encodeStart((DynamicOps)registryOps, (Object)stack.getComponents()).getOrThrow();
        DataComponentPatch patch = (DataComponentPatch)((Pair)DataComponentPatch.CODEC.decode((DynamicOps)registryOps, (Object)this.encodeTag(fluidTag, itemTag)).getOrThrow()).getFirst();
        stack.applyComponents(patch);
        return stack;
    }

    private CompoundTag encodeTag(CompoundTag fluidTag, CompoundTag itemTag) {
        if (this.map.isEmpty()) {
            return itemTag;
        }
        for (Map.Entry<DataComponentType<?>, Pair<DataComponentType<?>, Map<List<TagReference>, List<TagReference>>>> entry : this.map.entrySet()) {
            CompoundTag current;
            if (((Map)entry.getValue().getSecond()).isEmpty() && (current = itemTag) instanceof CompoundTag) {
                Tag innerFluidTag;
                CompoundTag tag = current;
                ResourceLocation id = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)entry.getValue().getFirst()));
                if (id == null || (innerFluidTag = fluidTag.get(id.toString())) == null) continue;
                tag.put(id.toString(), innerFluidTag);
            }
            for (int i = 0; i < ((Map)entry.getValue().getSecond()).size(); ++i) {
                current = itemTag.copy();
                block2: for (Map.Entry referenceEntry : ((Map)entry.getValue().getSecond()).entrySet()) {
                    List fluidKeys = (List)referenceEntry.getKey();
                    List itemKeys = (List)referenceEntry.getValue();
                    for (int j = 0; j < itemKeys.size(); ++j) {
                        CompoundTag compoundTag;
                        TagReference key = (TagReference)itemKeys.get(j);
                        if (i == itemKeys.size() - 1) {
                            Tag newElement = this.getTag((Tag)fluidTag, fluidKeys);
                            if (newElement instanceof ListTag) {
                                if (current instanceof ListTag) {
                                    ListTag listTag = (ListTag)current;
                                    listTag.set(key.index(), newElement);
                                    continue block2;
                                }
                                BrewinAndChewin.LOG.error("Unable to map tag {}. Tag {} is not a list tag.", (Object)String.join((CharSequence)".", fluidKeys.stream().map(TagReference::key).toList()), (Object)String.join((CharSequence)".", itemKeys.stream().map(TagReference::key).toList()));
                                continue block2;
                            }
                            if (current instanceof CompoundTag) {
                                compoundTag = current;
                                compoundTag.put(key.key(), newElement);
                                continue block2;
                            }
                            BrewinAndChewin.LOG.error("Unable to map tag {}. Tag {} is not a compound tag.", (Object)String.join((CharSequence)".", fluidKeys.stream().map(TagReference::key).toList()), (Object)String.join((CharSequence)".", itemKeys.stream().map(TagReference::key).toList()));
                            continue block2;
                        }
                        if (key.isArrayValue()) {
                            if (current instanceof ListTag) {
                                ListTag listTag = (ListTag)current;
                                if (listTag.size() < key.index()) {
                                    current = listTag.get(key.index());
                                    continue;
                                }
                                BrewinAndChewin.LOG.error("Unable to find tag {} in output json.", (Object)String.join((CharSequence)".", itemKeys.stream().map(TagReference::key).toList()));
                                continue;
                            }
                            BrewinAndChewin.LOG.error("Unable to map tag {}. Tag {} is not a list tag.", (Object)String.join((CharSequence)".", fluidKeys.stream().map(TagReference::key).toList()), (Object)String.join((CharSequence)".", itemKeys.subList(0, i).stream().map(TagReference::key).toList()));
                            continue;
                        }
                        if (current instanceof CompoundTag) {
                            compoundTag = current;
                            if (compoundTag.contains(key.key())) {
                                current = compoundTag.get(key.key());
                                continue;
                            }
                            BrewinAndChewin.LOG.error("Unable to find tag {} in output json.", (Object)String.join((CharSequence)".", itemKeys.stream().map(TagReference::key).toList()));
                            continue;
                        }
                        BrewinAndChewin.LOG.error("Unable to map tag {}. Tag {} is not a compound tag.", (Object)String.join((CharSequence)".", fluidKeys.stream().map(TagReference::key).toList()), (Object)String.join((CharSequence)".", String.join((CharSequence)".", itemKeys.subList(0, i).stream().map(TagReference::key).toList())));
                    }
                }
            }
        }
        return itemTag;
    }

    private Tag getTag(Tag keyTag, List<TagReference> references) {
        EndTag tag = EndTag.INSTANCE;
        for (int i = 0; i < references.size(); ++i) {
            ListTag listTag;
            TagReference key = references.get(i);
            if (i == references.size() - 1) {
                if (key.isArrayValue()) {
                    if (keyTag instanceof ListTag) {
                        listTag = (ListTag)keyTag;
                        if (listTag.size() < key.index()) {
                            tag = listTag.get(key.index());
                            break;
                        }
                        throw new RuntimeException("Unable to find tag " + String.join((CharSequence)".", references.stream().map(TagReference::key).toList()) + " in fluid stack.");
                    }
                    throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", references.stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", references.stream().map(TagReference::key).toList()) + " is not a list tag.");
                }
                if (keyTag instanceof CompoundTag) {
                    CompoundTag compoundTag = (CompoundTag)keyTag;
                    if (compoundTag.contains(key.key())) {
                        tag = compoundTag.get(key.key());
                        break;
                    }
                    throw new RuntimeException("Unable to find tag " + String.join((CharSequence)".", references.stream().map(TagReference::key).toList()) + " in fluid stack.");
                }
                throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", references.stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", references.stream().map(TagReference::key).toList()) + " is not a compound tag.");
            }
            if (key.isArrayValue()) {
                if (keyTag instanceof ListTag) {
                    listTag = (ListTag)keyTag;
                    if (listTag.size() < key.index()) {
                        tag = listTag.get(key.index());
                        continue;
                    }
                    throw new RuntimeException("Unable to find tag " + String.join((CharSequence)".", references.subList(0, i).stream().map(TagReference::key).toList()) + " in fluid stack.");
                }
                throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", references.subList(0, i).stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", references.subList(0, i).stream().map(TagReference::key).toList()) + " is not a list tag.");
            }
            if (keyTag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)keyTag;
                if (compoundTag.contains(key.key())) {
                    tag = compoundTag.get(key.key());
                    continue;
                }
                throw new RuntimeException("Unable to find tag " + String.join((CharSequence)".", references.subList(0, i).stream().map(TagReference::key).toList()) + " in fluid stack.");
            }
            throw new RuntimeException("Unable to map tag " + String.join((CharSequence)".", references.subList(0, i).stream().map(TagReference::key).toList()) + ". Tag " + String.join((CharSequence)".", references.subList(0, i).stream().map(TagReference::key).toList()) + " is not a compound tag.");
        }
        return tag;
    }

    static class ValueCodec
    implements Codec<Pair<DataComponentType<?>, Map<List<TagReference>, List<TagReference>>>> {
        private static final ValueCodec INSTANCE = new ValueCodec();

        protected ValueCodec() {
        }

        public <T> DataResult<Pair<Pair<DataComponentType<?>, Map<List<TagReference>, List<TagReference>>>, T>> decode(DynamicOps<T> ops, T input) {
            MapLike map = (MapLike)ops.getMap(input).getOrThrow();
            DataResult componentTypeResult = BuiltInRegistries.DATA_COMPONENT_TYPE.byNameCodec().decode(ops, map.get("component"));
            if (componentTypeResult.isError()) {
                return DataResult.error(() -> "Failed to decode 'component' field within fluid to item remapping.");
            }
            DataComponentType componentType = (DataComponentType)((Pair)componentTypeResult.getOrThrow()).getFirst();
            HashMap references = new HashMap();
            if (map.entries().anyMatch(p -> p.getFirst() == ops.createString("functions"))) {
                if (!ops.getStream(map.get("functions")).isError()) {
                    List functions = ((Stream)ops.getStream(map.get("functions")).getOrThrow()).toList();
                    for (Object innerFunction : functions) {
                        DataResult<Map<List<TagReference>, List<TagReference>>> dataResult = ValueCodec.getReferences(ops, innerFunction);
                        if (dataResult.isError()) {
                            BrewinAndChewin.LOG.error("Failed to decode remap value within fluid to item remapping: {}", (Object)((DataResult.Error)dataResult.error().get()).message());
                            continue;
                        }
                        references.putAll((Map)dataResult.getOrThrow());
                    }
                } else {
                    DataResult<Map<List<TagReference>, List<TagReference>>> dataResult = ValueCodec.getReferences(ops, map.get("functions"));
                    if (dataResult.isSuccess()) {
                        references.putAll((Map)dataResult.getOrThrow());
                    } else {
                        BrewinAndChewin.LOG.error("Failed to decode remap value within fluid to item remapping: {}", (Object)((DataResult.Error)dataResult.error().get()).message());
                    }
                }
            }
            return DataResult.success((Object)Pair.of((Object)Pair.of((Object)componentType, references), input));
        }

        private static <T> DataResult<Map<List<TagReference>, List<TagReference>>> getReferences(DynamicOps<T> ops, T input) {
            HashMap<List<TagReference>, List<TagReference>> map = new HashMap<List<TagReference>, List<TagReference>>();
            if (!ops.getMap(input).isError()) {
                MapLike innerMap = (MapLike)ops.getMap(input).getOrThrow();
                Object from = innerMap.get("from");
                if (ops.getStringValue(from).isError()) {
                    return DataResult.error(() -> "Failed to decode 'from' value. Must be a string that points to a NBT path.\n\nObjects are denoted with '.' (for example 'root.substring') and array values are denoted with '[<index_number>]' (for example '[0]').");
                }
                List<TagReference> fromValues = TagReference.createFromString((String)ops.getStringValue(from).getOrThrow());
                Object to = innerMap.get("to");
                if (!ops.getStringValue(to).isError()) {
                    map.put(fromValues, TagReference.createFromString((String)ops.getStringValue(to).getOrThrow()));
                } else {
                    return DataResult.error(() -> "Failed to decode 'to' value. Must be a string that points to a NBT path.\n\nObjects are denoted with '.' (for example 'root.substring') and array values are denoted with '[<index_number>]' (for example '[0]').");
                }
            }
            return DataResult.success((Object)ImmutableMap.copyOf(map));
        }

        public <T> DataResult<T> encode(Pair<DataComponentType<?>, Map<List<TagReference>, List<TagReference>>> input, DynamicOps<T> ops, T prefix) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put(ops.createString("component"), BuiltInRegistries.DATA_COMPONENT_TYPE.byNameCodec().encodeStart(ops, (Object)((DataComponentType)input.getFirst())).getOrThrow());
            ArrayList<Object> functionList = new ArrayList<Object>();
            for (Map.Entry entry : ((Map)input.getSecond()).entrySet()) {
                HashMap functionMap = new HashMap();
                map.put(ops.createString("from"), ops.createString(((List)entry.getKey()).stream().map(TagReference::key).collect(Collectors.joining("."))));
                map.put(ops.createString("to"), ops.createString(((List)entry.getValue()).stream().map(TagReference::key).collect(Collectors.joining("."))));
                functionList.add(ops.createMap(functionMap));
            }
            if (!functionList.isEmpty()) {
                map.put(ops.createString("functions"), ops.createList(functionList.stream()));
            }
            return DataResult.success((Object)ops.createMap(map));
        }
    }
}

