/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.mixin;

import java.nio.file.Path;
import java.util.List;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.book.BookFile;
import me.chrr.scribble.book.FileChooser;
import me.chrr.scribble.book.RichText;
import me.chrr.scribble.config.Config;
import me.chrr.scribble.gui.IconButtonWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BookViewScreen.class})
public abstract class BookScreenMixin
extends Screen {
    @Shadow
    private BookViewScreen.BookAccess bookAccess;

    private BookScreenMixin() {
        super(null);
    }

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    public void initButtons(CallbackInfo info) {
        if (Scribble.CONFIG_MANAGER.getConfig().showActionButtons == Config.ShowActionButtons.ALWAYS) {
            int x = this.width / 2 - 78 - 7 - 12;
            int y = Scribble.getBookScreenYOffset(this.height) + 12 + 4;
            Runnable saveBook = () -> FileChooser.chooseBook(true, path -> {
                try {
                    List<RichText> richPages = this.bookAccess.pages().stream().map(RichText::fromStringVisitableLossy).toList();
                    BookFile bookFile = new BookFile("<written book>", List.copyOf(richPages));
                    bookFile.write((Path)path);
                }
                catch (Exception e) {
                    Scribble.LOGGER.error("could not save book to file", (Throwable)e);
                }
            });
            this.addRenderableWidget((GuiEventListener)new IconButtonWidget((Component)Component.translatable((String)"text.scribble.action.save_book_to_file"), saveBook, x, y, 48, 90, 12, 12));
        }
    }

    @ModifyArg(method={"renderBackground(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIIIII)V"), index=2)
    public int shiftBackgroundY(int y) {
        return Scribble.getBookScreenYOffset(this.height) + y;
    }

    @Redirect(method={"createMenuControls()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/BookViewScreen;addRenderableWidget(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;"))
    public <T extends GuiEventListener & Renderable> T shiftCloseButtonY(BookViewScreen instance, T element) {
        if (element instanceof LayoutElement) {
            LayoutElement widget = (LayoutElement)element;
            widget.setY(widget.getY() + Scribble.getBookScreenYOffset(this.height));
        }
        return (T)this.addRenderableWidget(element);
    }

    @Redirect(method={"createPageControlButtons()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/BookViewScreen;addRenderableWidget(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;"))
    public <T extends GuiEventListener & Renderable> T shiftPageButtonY(BookViewScreen instance, T element) {
        if (element instanceof LayoutElement) {
            LayoutElement widget = (LayoutElement)element;
            widget.setY(widget.getY() + Scribble.getBookScreenYOffset(this.height));
        }
        return (T)this.addRenderableWidget(element);
    }

    @ModifyVariable(method={"getClickedComponentStyleAt(DD)Lnet/minecraft/network/chat/Style;"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    public double shiftTextStyleY(double y) {
        return y - (double)Scribble.getBookScreenYOffset(this.height);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", shift=At.Shift.AFTER)})
    public void translateRender(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.pose().pushPose();
        context.pose().translate(0.0f, (float)Scribble.getBookScreenYOffset(this.height), 0.0f);
    }

    @ModifyArg(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;renderComponentHoverEffect(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Style;II)V"), index=3)
    public int shiftHoverTooltipY(int y) {
        return y - Scribble.getBookScreenYOffset(this.height);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="RETURN")})
    public void popRender(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.pose().popPose();
    }
}

