/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.mixin;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import me.chrr.scribble.KeyboardUtil;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.book.BookFile;
import me.chrr.scribble.book.FileChooser;
import me.chrr.scribble.book.RichPageContent;
import me.chrr.scribble.book.RichSelectionManager;
import me.chrr.scribble.book.RichText;
import me.chrr.scribble.book.SynchronizedPageList;
import me.chrr.scribble.config.Config;
import me.chrr.scribble.gui.ColorSwatchWidget;
import me.chrr.scribble.gui.IconButtonWidget;
import me.chrr.scribble.gui.ModifierButtonWidget;
import me.chrr.scribble.history.BookEditScreenMemento;
import me.chrr.scribble.history.CommandManager;
import me.chrr.scribble.history.Restorable;
import me.chrr.scribble.history.command.ActionCommand;
import me.chrr.scribble.history.command.DeletePageCommand;
import me.chrr.scribble.history.command.InsertPageCommand;
import me.chrr.scribble.history.command.PagesListener;
import net.minecraft.ChatFormatting;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BookEditScreen.class})
public abstract class BookEditScreenMixin
extends Screen
implements PagesListener,
Restorable<BookEditScreenMemento> {
    @Unique
    private static final int MAX_PAGES_NUMBER = 100;
    @Unique
    private static final ChatFormatting[] COLORS = new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.DARK_GRAY, ChatFormatting.GRAY, ChatFormatting.WHITE, ChatFormatting.DARK_RED, ChatFormatting.RED, ChatFormatting.GOLD, ChatFormatting.YELLOW, ChatFormatting.DARK_GREEN, ChatFormatting.GREEN, ChatFormatting.DARK_AQUA, ChatFormatting.AQUA, ChatFormatting.DARK_BLUE, ChatFormatting.BLUE, ChatFormatting.DARK_PURPLE, ChatFormatting.LIGHT_PURPLE};
    @Unique
    private static final ChatFormatting DEFAULT_COLOR = ChatFormatting.BLACK;
    @Mutable
    @Shadow
    @Final
    private TextFieldHelper pageEdit;
    @Shadow
    private int currentPage;
    @Shadow
    private boolean isModified;
    @Shadow
    @Final
    private List<String> pages;
    @Shadow
    private boolean isSigning;
    @Shadow
    @Final
    private Player owner;
    @Unique
    private final SynchronizedPageList synchronizedPages = new SynchronizedPageList();
    @Unique
    private final CommandManager commandManager;
    @Unique
    @Nullable
    private ChatFormatting activeColor;
    @Unique
    @NotNull
    private Set<ChatFormatting> activeModifiers;
    @Unique
    private ModifierButtonWidget boldButton;
    @Unique
    private ModifierButtonWidget italicButton;
    @Unique
    private ModifierButtonWidget underlineButton;
    @Unique
    private ModifierButtonWidget strikethroughButton;
    @Unique
    private ModifierButtonWidget obfuscatedButton;
    @Unique
    @NotNull
    private List<ColorSwatchWidget> colorSwatches;
    @Unique
    private IconButtonWidget deletePageButton;
    @Unique
    private IconButtonWidget insertPageButton;
    @Unique
    private IconButtonWidget undoButton;
    @Unique
    private IconButtonWidget redoButton;
    @Unique
    private IconButtonWidget saveBookButton;
    @Unique
    private IconButtonWidget loadBookButton;

    @Shadow
    protected abstract BookEditScreen.Pos2i convertLocalToScreen(BookEditScreen.Pos2i var1);

    @Shadow
    static int findLineFromPos(int[] lineStarts, int position) {
        return 0;
    }

    @Shadow
    protected abstract Rect2i createSelection(BookEditScreen.Pos2i var1, BookEditScreen.Pos2i var2);

    @Shadow
    protected abstract void setClipboard(String var1);

    @Shadow
    protected abstract void clearDisplayCache();

    @Shadow
    protected abstract void clearDisplayCacheAfterPageChange();

    @Shadow
    protected abstract void updateButtonVisibility();

    private BookEditScreenMixin() {
        super(null);
        this.commandManager = new CommandManager(Scribble.CONFIG_MANAGER.getConfig().editHistorySize);
        this.activeColor = DEFAULT_COLOR;
        this.activeModifiers = new HashSet<ChatFormatting>();
        this.colorSwatches = List.of();
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/InteractionHand;)V"}, at={@At(value="TAIL")})
    public void init(Player player, ItemStack stack, InteractionHand hand, CallbackInfo ci) {
        this.pageEdit = new RichSelectionManager(this::getCurrentPageText, this::setPageText, this::onCursorFormattingChanged, this::getRawClipboard, this::setClipboard, text -> text.getAsFormattedString().length() < 1024 && this.font.wordWrapHeight((FormattedText)text, 114) <= 128, () -> Optional.ofNullable(this.activeColor).orElse(DEFAULT_COLOR), () -> this.activeModifiers);
        this.commandManager.onHistoryUpdate(this::invalidateHistoryButtons);
        this.synchronizedPages.populate(this.pages);
        this.getRichSelectionManager().notifyCursorFormattingChanged();
    }

    @Inject(method={"init()V"}, at={@At(value="HEAD")})
    private void initScreen(CallbackInfo ci) {
        this.initButtons();
    }

    @Unique
    private void initButtons() {
        int x = this.width / 2 + 78;
        int y = Scribble.getBookScreenYOffset(this.height) + 12;
        this.boldButton = this.addModifierButton(ChatFormatting.BOLD, (Component)Component.translatable((String)"text.scribble.modifier.bold"), x, y, 0, 0, 22, 19);
        this.italicButton = this.addModifierButton(ChatFormatting.ITALIC, (Component)Component.translatable((String)"text.scribble.modifier.italic"), x, y + 19, 0, 19, 22, 17);
        this.underlineButton = this.addModifierButton(ChatFormatting.UNDERLINE, (Component)Component.translatable((String)"text.scribble.modifier.underline"), x, y + 36, 0, 36, 22, 17);
        this.strikethroughButton = this.addModifierButton(ChatFormatting.STRIKETHROUGH, (Component)Component.translatable((String)"text.scribble.modifier.strikethrough"), x, y + 53, 0, 53, 22, 17);
        this.obfuscatedButton = this.addModifierButton(ChatFormatting.OBFUSCATED, (Component)Component.translatable((String)"text.scribble.modifier.obfuscated"), x, y + 70, 0, 70, 22, 18);
        this.colorSwatches = new ArrayList<ColorSwatchWidget>(COLORS.length);
        for (int i = 0; i < COLORS.length; ++i) {
            ChatFormatting color = COLORS[i];
            int dx = i % 2 * 8;
            int dy = i / 2 * 8;
            ColorSwatchWidget swatch = new ColorSwatchWidget((Component)Component.translatable((String)("text.scribble.color." + color.getName())), color, () -> this.changeActiveColor(color), x + 3 + dx, y + 95 + dy, 8, 8);
            swatch.setToggled(this.activeColor == color);
            ColorSwatchWidget widget = (ColorSwatchWidget)this.addRenderableWidget((GuiEventListener)swatch);
            this.colorSwatches.add(widget);
        }
        int px = this.width / 2 - 96;
        this.deletePageButton = (IconButtonWidget)this.addRenderableWidget((GuiEventListener)new IconButtonWidget((Component)Component.translatable((String)"text.scribble.action.delete_page"), this::deletePage, px + 78, y + 148, 0, 90, 12, 12));
        this.insertPageButton = (IconButtonWidget)this.addRenderableWidget((GuiEventListener)new IconButtonWidget((Component)Component.translatable((String)"text.scribble.action.insert_new_page"), this::insertPage, px + 94, y + 148, 12, 90, 12, 12));
        int ax = this.width / 2 - 78 - 7 - 12;
        int ay = y + 4;
        this.undoButton = (IconButtonWidget)this.addRenderableWidget((GuiEventListener)new IconButtonWidget((Component)Component.translatable((String)"text.scribble.action.undo"), this.commandManager::tryUndo, ax, ay, 24, 90, 12, 12));
        this.redoButton = (IconButtonWidget)this.addRenderableWidget((GuiEventListener)new IconButtonWidget((Component)Component.translatable((String)"text.scribble.action.redo"), this.commandManager::tryRedo, ax, ay + 12, 36, 90, 12, 12));
        this.saveBookButton = (IconButtonWidget)this.addRenderableWidget((GuiEventListener)new IconButtonWidget((Component)Component.translatable((String)"text.scribble.action.save_book_to_file"), () -> FileChooser.chooseBook(true, this::saveTo), ax, ay + 24 + 4, 48, 90, 12, 12));
        this.loadBookButton = (IconButtonWidget)this.addRenderableWidget((GuiEventListener)new IconButtonWidget((Component)Component.translatable((String)"text.scribble.action.load_book_from_file"), () -> this.confirmOverwrite(() -> FileChooser.chooseBook(false, this::loadFrom)), ax, ay + 36 + 4, 60, 90, 12, 12));
        this.invalidateHistoryButtons();
    }

    @Unique
    private ModifierButtonWidget addModifierButton(ChatFormatting modifier, Component tooltip, int x, int y, int u, int v, int width, int height) {
        ModifierButtonWidget button = new ModifierButtonWidget(tooltip, toggled -> this.toggleActiveModifier(modifier, (boolean)toggled), x, y, u, v, width, height, this.activeModifiers.contains(modifier));
        return (ModifierButtonWidget)this.addRenderableWidget((GuiEventListener)button);
    }

    @Unique
    private void changeActiveColor(@NotNull ChatFormatting newColor) {
        if (newColor == this.activeColor) {
            return;
        }
        ActionCommand<BookEditScreenMemento> command = new ActionCommand<BookEditScreenMemento>(this, () -> {
            this.activeColor = newColor;
            this.invalidateFormattingButtons();
            this.getRichSelectionManager().applyColorForSelection(newColor);
        });
        this.commandManager.execute(command);
    }

    @Unique
    public void toggleActiveModifier(ChatFormatting modifier, boolean toggled) {
        ActionCommand<BookEditScreenMemento> command = new ActionCommand<BookEditScreenMemento>(this, () -> {
            if (toggled) {
                this.activeModifiers.add(modifier);
            } else {
                this.activeModifiers.remove(modifier);
            }
            this.invalidateFormattingButtons();
            this.getRichSelectionManager().toggleModifierForSelection(modifier, toggled);
        });
        this.commandManager.execute(command);
    }

    @Inject(method={"updateButtonVisibility()V"}, at={@At(value="HEAD")})
    private void invalidateControlButtons(CallbackInfo ci) {
        Optional.ofNullable(this.boldButton).ifPresent(button -> {
            button.visible = !this.isSigning;
        });
        Optional.ofNullable(this.italicButton).ifPresent(button -> {
            button.visible = !this.isSigning;
        });
        Optional.ofNullable(this.underlineButton).ifPresent(button -> {
            button.visible = !this.isSigning;
        });
        Optional.ofNullable(this.strikethroughButton).ifPresent(button -> {
            button.visible = !this.isSigning;
        });
        Optional.ofNullable(this.obfuscatedButton).ifPresent(button -> {
            button.visible = !this.isSigning;
        });
        for (ColorSwatchWidget swatch : this.colorSwatches) {
            swatch.visible = !this.isSigning;
        }
        Optional.ofNullable(this.deletePageButton).ifPresent(button -> {
            button.visible = !this.isSigning && this.synchronizedPages.size() > 1;
        });
        Optional.ofNullable(this.insertPageButton).ifPresent(button -> {
            button.visible = !this.isSigning && this.synchronizedPages.size() < 100;
        });
        boolean showSaveLoadButtons = Scribble.CONFIG_MANAGER.getConfig().showActionButtons != Config.ShowActionButtons.NEVER;
        Optional.ofNullable(this.undoButton).ifPresent(button -> {
            button.visible = !this.isSigning && showSaveLoadButtons;
        });
        Optional.ofNullable(this.redoButton).ifPresent(button -> {
            button.visible = !this.isSigning && showSaveLoadButtons;
        });
        Optional.ofNullable(this.saveBookButton).ifPresent(button -> {
            button.visible = !this.isSigning && showSaveLoadButtons;
        });
        Optional.ofNullable(this.loadBookButton).ifPresent(button -> {
            button.visible = !this.isSigning && showSaveLoadButtons;
        });
    }

    @Unique
    private void invalidateFormattingButtons() {
        Optional.ofNullable(this.boldButton).ifPresent(button -> {
            button.toggled = this.activeModifiers.contains(ChatFormatting.BOLD);
        });
        Optional.ofNullable(this.italicButton).ifPresent(button -> {
            button.toggled = this.activeModifiers.contains(ChatFormatting.ITALIC);
        });
        Optional.ofNullable(this.underlineButton).ifPresent(button -> {
            button.toggled = this.activeModifiers.contains(ChatFormatting.UNDERLINE);
        });
        Optional.ofNullable(this.strikethroughButton).ifPresent(button -> {
            button.toggled = this.activeModifiers.contains(ChatFormatting.STRIKETHROUGH);
        });
        Optional.ofNullable(this.obfuscatedButton).ifPresent(button -> {
            button.toggled = this.activeModifiers.contains(ChatFormatting.OBFUSCATED);
        });
        this.setSwatchColor(this.activeColor);
    }

    @Unique
    private void invalidateHistoryButtons() {
        Optional.ofNullable(this.undoButton).ifPresent(button -> {
            button.active = this.commandManager.hasCommandsToUndo();
        });
        Optional.ofNullable(this.redoButton).ifPresent(button -> {
            button.active = this.commandManager.hasCommandsToRedo();
        });
    }

    @Unique
    private void setSwatchColor(ChatFormatting color) {
        for (ColorSwatchWidget swatch : this.colorSwatches) {
            swatch.setToggled(swatch.getColor() == color);
        }
    }

    @Unique
    private void onCursorFormattingChanged(@Nullable ChatFormatting color, Set<ChatFormatting> modifiers) {
        this.activeColor = color;
        this.activeModifiers = modifiers;
        this.invalidateFormattingButtons();
    }

    @Redirect(method={"getCurrentPageText()Ljava/lang/String;"}, at=@At(value="INVOKE", target="Ljava/util/List;get(I)Ljava/lang/Object;"))
    public Object getCurrentPageContent(List<String> pages, int page) {
        return this.synchronizedPages.get(page).getPlainText();
    }

    @Overwrite
    public void setCurrentPageText(String newContent) {
        Scribble.LOGGER.warn("setPageContent() was called, but ignored.");
    }

    @Unique
    private String getRawClipboard() {
        return this.minecraft != null ? this.minecraft.keyboardHandler.getClipboard().replaceAll("\\r", "") : "";
    }

    @Unique
    private Rect2i getSelectionRectangle(RichText text, StringSplitter handler, int selectionStart, int selectionEnd, int lineY, int lineStart) {
        RichText toSelectionStart = text.subText(lineStart, selectionStart);
        RichText toSelectionEnd = text.subText(lineStart, selectionEnd);
        BookEditScreen.Pos2i topLeft = new BookEditScreen.Pos2i((int)handler.stringWidth((FormattedText)toSelectionStart), lineY);
        BookEditScreen.Pos2i bottomRight = new BookEditScreen.Pos2i((int)handler.stringWidth((FormattedText)toSelectionEnd), lineY + 9);
        return this.createSelection(topLeft, bottomRight);
    }

    @Unique
    private RichText getCurrentPageText() {
        return this.currentPage >= 0 && this.currentPage < this.synchronizedPages.size() ? this.synchronizedPages.get(this.currentPage) : RichText.empty();
    }

    @Unique
    private void setPageText(RichText newText) {
        if (this.currentPage >= 0 && this.currentPage < this.synchronizedPages.size()) {
            this.synchronizedPages.set(this.currentPage, newText);
        }
        this.isModified = true;
        this.clearDisplayCache();
    }

    @Unique
    private RichSelectionManager getRichSelectionManager() {
        return (RichSelectionManager)this.pageEdit;
    }

    @Inject(method={"eraseEmptyTrailingPages()V"}, at={@At(value="HEAD")})
    private void removeEmptyPages(CallbackInfo ci) {
        int lastIndex;
        for (int i = lastIndex = this.synchronizedPages.size() - 1; i >= 0 && this.synchronizedPages.get(i).isEmpty(); --i) {
            this.synchronizedPages.remove(i);
        }
    }

    @Redirect(method={"appendPageToBook()V"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z"))
    private boolean appendNewPage(List<String> page, Object empty) {
        InsertPageCommand command = new InsertPageCommand(this.synchronizedPages, this.synchronizedPages.size(), this);
        this.commandManager.execute(command);
        return true;
    }

    @Override
    public void scribble$onPageAdded(int pageAddedIndex) {
        this.currentPage = pageAddedIndex;
        this.isModified = true;
        this.updateButtonVisibility();
        this.clearDisplayCacheAfterPageChange();
    }

    @Override
    public void scribble$onPageRemoved(int pageRemovedIndex) {
        if (pageRemovedIndex < this.currentPage) {
            this.currentPage = Math.max(0, pageRemovedIndex - 1);
        } else if (this.currentPage >= this.synchronizedPages.size()) {
            this.currentPage = Math.max(0, this.synchronizedPages.size() - 1);
        }
        this.isModified = true;
        this.updateButtonVisibility();
        this.clearDisplayCacheAfterPageChange();
    }

    @Unique
    private void deletePage() {
        DeletePageCommand command = new DeletePageCommand(this.synchronizedPages, this.currentPage, this);
        this.commandManager.execute(command);
    }

    @Unique
    private void insertPage() {
        if (this.synchronizedPages.size() < 100) {
            InsertPageCommand command = new InsertPageCommand(this.synchronizedPages, this.currentPage, this);
            this.commandManager.execute(command);
        }
    }

    @Override
    public BookEditScreenMemento scribble$createMemento() {
        RichSelectionManager selectionManager = this.getRichSelectionManager();
        return new BookEditScreenMemento(this.currentPage, selectionManager.cursorPos, selectionManager.selectionPos, this.getCurrentPageText(), this.activeColor, Set.copyOf(this.activeModifiers));
    }

    @Override
    public void scribble$restore(BookEditScreenMemento memento) {
        this.currentPage = memento.pageIndex();
        this.updateButtonVisibility();
        this.clearDisplayCacheAfterPageChange();
        this.setPageText(memento.currentPageRichText());
        RichSelectionManager selectionManager = this.getRichSelectionManager();
        selectionManager.setSelectionRange(memento.selectionStart(), memento.selectionEnd());
        this.activeColor = memento.color();
        this.activeModifiers = new HashSet<ChatFormatting>(memento.modifiers());
        this.invalidateFormattingButtons();
    }

    @Unique
    private void confirmOverwrite(Runnable callback) {
        if (!this.synchronizedPages.arePagesEmpty()) {
            if (this.minecraft == null) {
                return;
            }
            this.minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
                if (confirmed) {
                    callback.run();
                }
                this.minecraft.setScreen((Screen)this);
            }, (Component)Component.translatable((String)"text.scribble.overwrite_warning.title"), (Component)Component.translatable((String)"text.scribble.overwrite_warning.description")));
        } else {
            callback.run();
        }
    }

    public void onClose() {
        if (this.isModified && this.minecraft != null) {
            this.minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
                if (confirmed) {
                    super.onClose();
                } else {
                    this.minecraft.setScreen((Screen)this);
                }
            }, (Component)Component.translatable((String)"text.scribble.quit_without_saving.title"), (Component)Component.translatable((String)"text.scribble.quit_without_saving.description")));
        } else {
            super.onClose();
        }
    }

    @Unique
    private void saveTo(Path path) {
        try {
            BookFile bookFile = new BookFile(this.owner.getGameProfile().getName(), this.synchronizedPages.getRichPages());
            bookFile.write(path);
        }
        catch (Exception e) {
            Scribble.LOGGER.error("could not save book to file", (Throwable)e);
        }
    }

    @Unique
    private void loadFrom(Path path) {
        try {
            BookFile bookFile = BookFile.read(path);
            Collection<RichText> loadedPages = bookFile.pages().isEmpty() ? List.of(RichText.empty()) : bookFile.pages();
            this.synchronizedPages.clear();
            this.commandManager.clear();
            this.synchronizedPages.addAll(loadedPages);
            this.currentPage = 0;
            this.isModified = true;
            this.updateButtonVisibility();
            this.clearDisplayCacheAfterPageChange();
        }
        catch (Exception e) {
            Scribble.LOGGER.error("could not load book from file", (Throwable)e);
        }
    }

    @ModifyArg(method={"renderBackground(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIIIII)V"), index=2)
    public int shiftBackgroundY(int y) {
        return Scribble.getBookScreenYOffset(this.height) + y;
    }

    @Redirect(method={"init()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/BookEditScreen;addRenderableWidget(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;"))
    public <T extends GuiEventListener & Renderable> T shiftButtonY(BookEditScreen screen, T element) {
        if (element instanceof LayoutElement) {
            LayoutElement widget = (LayoutElement)element;
            widget.setY(widget.getY() + Scribble.getBookScreenYOffset(this.height));
        }
        return (T)this.addRenderableWidget(element);
    }

    @ModifyArg(method={"mouseClicked(DDI)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/BookEditScreen;convertScreenToLocal(Lnet/minecraft/client/gui/screens/inventory/BookEditScreen$Pos2i;)Lnet/minecraft/client/gui/screens/inventory/BookEditScreen$Pos2i;"))
    public BookEditScreen.Pos2i shiftMouseClicks(BookEditScreen.Pos2i position) {
        return new BookEditScreen.Pos2i(position.x, position.y - Scribble.getBookScreenYOffset(this.height));
    }

    @ModifyArg(method={"mouseDragged(DDIDD)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/BookEditScreen;convertScreenToLocal(Lnet/minecraft/client/gui/screens/inventory/BookEditScreen$Pos2i;)Lnet/minecraft/client/gui/screens/inventory/BookEditScreen$Pos2i;"))
    public BookEditScreen.Pos2i shiftMouseDrags(BookEditScreen.Pos2i position) {
        return new BookEditScreen.Pos2i(position.x, position.y - Scribble.getBookScreenYOffset(this.height));
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", shift=At.Shift.AFTER)})
    public void translateRender(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.pose().pushPose();
        context.pose().translate(0.0f, (float)Scribble.getBookScreenYOffset(this.height), 0.0f);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="RETURN")})
    public void popRender(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.pose().popPose();
    }

    @Inject(method={"mouseDragged(DDIDD)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/BookEditScreen;getDisplayCache()Lnet/minecraft/client/gui/screens/inventory/BookEditScreen$DisplayCache;")}, cancellable=true)
    private void mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY, CallbackInfoReturnable<Boolean> cir) {
        if (mouseX < (double)(this.width - 152) / 2.0 || mouseX > (double)(this.width + 152) / 2.0) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"pageForward()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void openNextPage(CallbackInfo ci) {
        int lastPage = this.synchronizedPages.size() - 1;
        if (this.currentPage < lastPage && Screen.hasShiftDown()) {
            this.currentPage = lastPage;
            this.updateButtonVisibility();
            this.clearDisplayCacheAfterPageChange();
            ci.cancel();
        }
    }

    @Inject(method={"pageBack()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void openPreviousPage(CallbackInfo ci) {
        if (Screen.hasShiftDown()) {
            this.currentPage = 0;
            this.updateButtonVisibility();
            this.clearDisplayCacheAfterPageChange();
            ci.cancel();
        }
    }

    @Redirect(method={"charTyped(CI)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/font/TextFieldHelper;insertText(Ljava/lang/String;)V"))
    private void charTypedEditMode(TextFieldHelper instance, String string) {
        ActionCommand<BookEditScreenMemento> command = new ActionCommand<BookEditScreenMemento>(this, () -> this.getRichSelectionManager().insertText(string));
        this.commandManager.execute(command);
    }

    @Inject(method={"bookKeyPressed(III)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void keyPressedEditMode(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (BookEditScreenMixin.hasControlDown() && !BookEditScreenMixin.hasAltDown() && (keyCode == 67 || keyCode == 88)) {
            boolean shouldCopyFormatting = Scribble.CONFIG_MANAGER.getConfig().copyFormattingCodes && !BookEditScreenMixin.hasShiftDown();
            String selectedText = this.getRichSelectionManager().getSelectedFormattedText();
            this.setClipboard(shouldCopyFormatting ? selectedText : ChatFormatting.stripFormatting((String)selectedText));
            if (keyCode == 88) {
                ActionCommand<BookEditScreenMemento> command = new ActionCommand<BookEditScreenMemento>(this, () -> this.getRichSelectionManager().removeCharsFromCursor(0));
                this.commandManager.execute(command);
            }
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
        if (BookEditScreenMixin.hasControlDown() && !BookEditScreenMixin.hasAltDown() && keyCode == 86) {
            String textToPaste = BookEditScreenMixin.hasShiftDown() ? ChatFormatting.stripFormatting((String)this.getRawClipboard()) : this.getRawClipboard();
            ActionCommand<BookEditScreenMemento> command = new ActionCommand<BookEditScreenMemento>(this, () -> this.getRichSelectionManager().insertText(textToPaste));
            this.commandManager.execute(command);
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
        if (!BookEditScreenMixin.hasShiftDown() && BookEditScreenMixin.hasControlDown() && !BookEditScreenMixin.hasAltDown() && KeyboardUtil.isKey(keyCode, "Z")) {
            this.commandManager.tryUndo();
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
        if (BookEditScreenMixin.hasControlDown() && !BookEditScreenMixin.hasAltDown() && (BookEditScreenMixin.hasShiftDown() && KeyboardUtil.isKey(keyCode, "Z") || !BookEditScreenMixin.hasShiftDown() && KeyboardUtil.isKey(keyCode, "Y"))) {
            this.commandManager.tryRedo();
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
        if (keyCode == 261 || keyCode == 259) {
            TextFieldHelper.CursorStep selectionType = Screen.hasControlDown() ? TextFieldHelper.CursorStep.WORD : TextFieldHelper.CursorStep.CHARACTER;
            int offset = keyCode == 261 ? 1 : -1;
            ActionCommand<BookEditScreenMemento> command = new ActionCommand<BookEditScreenMemento>(this, () -> this.getRichSelectionManager().removeFromCursor(offset, selectionType));
            this.commandManager.execute(command);
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
        if (BookEditScreenMixin.hasControlDown() && !BookEditScreenMixin.hasShiftDown() && !BookEditScreenMixin.hasAltDown()) {
            if (keyCode == 66) {
                Optional.ofNullable(this.boldButton).ifPresent(ModifierButtonWidget::toggle);
            } else if (keyCode == 73) {
                Optional.ofNullable(this.italicButton).ifPresent(ModifierButtonWidget::toggle);
            } else if (keyCode == 85) {
                Optional.ofNullable(this.underlineButton).ifPresent(ModifierButtonWidget::toggle);
            } else if (keyCode == 45) {
                Optional.ofNullable(this.strikethroughButton).ifPresent(ModifierButtonWidget::toggle);
            } else if (keyCode == 75) {
                Optional.ofNullable(this.obfuscatedButton).ifPresent(ModifierButtonWidget::toggle);
            } else {
                return;
            }
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @ModifyArg(method={"renderCursor(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/screens/inventory/BookEditScreen$Pos2i;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)I"), index=4)
    private int modifyEndCursorColor(int constant) {
        return this.activeColor == null || this.activeColor.getColor() == null ? constant : this.activeColor.getColor();
    }

    @ModifyArg(method={"renderCursor(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/screens/inventory/BookEditScreen$Pos2i;Z)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V"), index=4)
    private int modifyLineCursorColor(int constant) {
        return this.modifyEndCursorColor(constant) | 0xFF000000;
    }

    protected void changeFocus(ComponentPath path) {
        this.clearFocus();
    }

    @Overwrite
    private BookEditScreen.DisplayCache rebuildDisplayCache() {
        BookEditScreen.Pos2i cursorPosition;
        boolean atEnd;
        RichText text = this.getCurrentPageText();
        String plainText = text.getPlainText();
        if (text.isEmpty()) {
            return RichPageContent.EMPTY;
        }
        int selectionStart = this.pageEdit.getCursorPos();
        int selectionEnd = this.pageEdit.getSelectionPos();
        IntArrayList lineStarts = new IntArrayList();
        ArrayList lines = new ArrayList();
        MutableBoolean endsWithNewline = new MutableBoolean();
        StringSplitter textHandler = this.font.getSplitter();
        MutableInt lineNumber = new MutableInt();
        MutableInt charNumber = new MutableInt();
        textHandler.splitLines((FormattedText)text, 114, Style.EMPTY, (arg_0, arg_1) -> this.lambda$createPageContent$34(lineNumber, charNumber, plainText, endsWithNewline, (IntList)lineStarts, lines, arg_0, arg_1));
        int[] lineStartsArray = lineStarts.toIntArray();
        boolean bl = atEnd = selectionStart == plainText.length();
        if (atEnd && endsWithNewline.isTrue()) {
            cursorPosition = new BookEditScreen.Pos2i(0, lines.size() * 9);
        } else {
            int i = BookEditScreenMixin.findLineFromPos(lineStartsArray, selectionStart);
            int width = this.font.width((FormattedText)text.subText(lineStartsArray[i], selectionStart));
            cursorPosition = new BookEditScreen.Pos2i(width, i * 9);
        }
        ArrayList selectionRectangles = Lists.newArrayList();
        if (selectionStart != selectionEnd) {
            int endLine;
            int selStart = Math.min(selectionStart, selectionEnd);
            int selEnd = Math.max(selectionStart, selectionEnd);
            int startLine = BookEditScreenMixin.findLineFromPos(lineStartsArray, selStart);
            if (startLine == (endLine = BookEditScreenMixin.findLineFromPos(lineStartsArray, selEnd))) {
                int y = startLine * 9;
                int lineStart = lineStartsArray[startLine];
                selectionRectangles.add(this.getSelectionRectangle(text, textHandler, selStart, selEnd, y, lineStart));
            } else {
                int lineEnd = startLine + 1 > lineStartsArray.length ? plainText.length() : lineStartsArray[startLine + 1];
                selectionRectangles.add(this.getSelectionRectangle(text, textHandler, selStart, lineEnd, startLine * 9, lineStartsArray[startLine]));
                for (int i = startLine + 1; i < endLine; ++i) {
                    int y = i * 9;
                    int s = (int)textHandler.stringWidth(((RichPageContent.Line)((Object)lines.get(i))).getStringVisitable());
                    selectionRectangles.add(this.createSelection(new BookEditScreen.Pos2i(0, y), new BookEditScreen.Pos2i(s, y + 9)));
                }
                selectionRectangles.add(this.getSelectionRectangle(text, textHandler, lineStartsArray[endLine], selEnd, endLine * 9, lineStartsArray[endLine]));
            }
        }
        return new RichPageContent(text, cursorPosition, atEnd, lineStartsArray, lines.toArray(new BookEditScreen.LineInfo[0]), selectionRectangles.toArray(new Rect2i[0]));
    }

    private /* synthetic */ void lambda$createPageContent$34(MutableInt lineNumber, MutableInt charNumber, String plainText, MutableBoolean endsWithNewline, IntList lineStarts, List lines, FormattedText stringVisitable, Boolean continued) {
        String string = stringVisitable.getString();
        int length = string.length();
        int i = lineNumber.getAndIncrement();
        int start = charNumber.getValue();
        boolean newline = false;
        if (plainText.length() > start + length) {
            char lastChar = plainText.charAt(start + length);
            if (lastChar == '\n') {
                newline = true;
                ++length;
            } else if (lastChar == ' ') {
                ++length;
            }
        }
        endsWithNewline.setValue(newline);
        charNumber.add(length);
        int y = i * 9;
        BookEditScreen.Pos2i position = this.convertLocalToScreen(new BookEditScreen.Pos2i(0, y));
        lineStarts.add(start);
        lines.add(new RichPageContent.Line(stringVisitable, position.x, position.y));
    }
}

