/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.history.command;

import me.chrr.scribble.Scribble;
import me.chrr.scribble.book.RichText;
import me.chrr.scribble.book.SynchronizedPageList;
import me.chrr.scribble.history.command.Command;
import me.chrr.scribble.history.command.PagesListener;
import org.jetbrains.annotations.Nullable;

public class DeletePageCommand
implements Command {
    private final SynchronizedPageList pages;
    private final int index;
    private final PagesListener pagesListener;
    @Nullable
    private RichText deletedPage;

    public DeletePageCommand(SynchronizedPageList pages, int index, PagesListener pagesListener) {
        if (index < 0 || index >= pages.size()) {
            throw new IllegalArgumentException("Delete page index is out of pages range");
        }
        this.pages = pages;
        this.index = index;
        this.pagesListener = pagesListener;
    }

    @Override
    public boolean execute() {
        this.deletedPage = this.pages.get(this.index);
        this.pages.remove(this.index);
        this.pagesListener.scribble$onPageRemoved(this.index);
        return true;
    }

    @Override
    public boolean rollback() {
        if (this.deletedPage != null) {
            this.pages.add(this.index, this.deletedPage);
            this.pagesListener.scribble$onPageAdded(this.index);
            return true;
        }
        Scribble.LOGGER.error("Unable to rollback DeletePageCommand, deletedPage is null");
        return false;
    }
}

