/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.gui;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class ColorSwatchWidget
extends AbstractWidget {
    private final ChatFormatting color;
    private final Runnable onClick;
    private boolean toggled = false;

    public ColorSwatchWidget(Component tooltip, ChatFormatting color, Runnable onClick, int x, int y, int width, int height) {
        super(x, y, width, height, tooltip);
        this.setTooltip(Tooltip.create((Component)tooltip));
        this.color = color;
        this.onClick = onClick;
    }

    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        Integer color;
        if (this.isHoveredOrFocused() || this.toggled) {
            context.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, this.isHoveredOrFocused() ? -1 : -6250336);
        }
        if ((color = this.color.getColor()) == null) {
            return;
        }
        color = color | 0xFF000000;
        context.fill(this.getX() + 1, this.getY() + 1, this.getX() + this.width - 1, this.getY() + this.height - 1, color.intValue());
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
        this.defaultButtonNarrationText(builder);
    }

    public void onClick(double mouseX, double mouseY) {
        this.toggled = true;
        this.onClick.run();
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public void setToggled(boolean toggled) {
        this.toggled = toggled;
    }
}

