/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.book;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.book.RichText;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.util.StringUtil;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.Nullable;

public class RichSelectionManager
extends TextFieldHelper {
    private final Supplier<RichText> textGetter;
    private final Consumer<RichText> textSetter;
    private final Predicate<RichText> textFilter;
    private final StateCallback stateCallback;
    private final Supplier<ChatFormatting> colorGetter;
    private final Supplier<Set<ChatFormatting>> modifiersGetter;

    public RichSelectionManager(Supplier<RichText> textGetter, Consumer<RichText> textSetter, StateCallback stateCallback, Supplier<String> clipboardGetter, Consumer<String> clipboardSetter, Predicate<RichText> textFilter, Supplier<ChatFormatting> colorGetter, Supplier<Set<ChatFormatting>> modifiersGetter) {
        super(() -> ((RichText)textGetter.get()).getPlainText(), text -> Scribble.LOGGER.warn("stringSetter called with \"{}\"", text), clipboardGetter, clipboardSetter, s -> true);
        this.textGetter = textGetter;
        this.textSetter = textSetter;
        this.textFilter = textFilter;
        this.stateCallback = stateCallback;
        this.colorGetter = colorGetter;
        this.modifiersGetter = modifiersGetter;
    }

    public boolean charTyped(char c) {
        Predicate<Character> isValidChar = StringUtil::isAllowedChatCharacter;
        if (isValidChar.test(Character.valueOf(c))) {
            this.insertText(String.valueOf(c));
        }
        return true;
    }

    public void insertText(String string) {
        RichText insertion;
        boolean isFormattedString;
        RichText text = this.textGetter.get();
        int start = Math.min(this.cursorPos, this.selectionPos);
        int end = Math.max(this.cursorPos, this.selectionPos);
        boolean bl = isFormattedString = !ChatFormatting.stripFormatting((String)string).equals(string.replaceAll(ChatFormatting.RESET.toString(), ""));
        if (isFormattedString) {
            insertion = RichText.fromFormattedString(string);
        } else {
            string = string.replaceAll(ChatFormatting.RESET.toString(), "");
            insertion = new RichText(string, this.colorGetter.get(), this.modifiersGetter.get());
        }
        text = start == end ? text.insert(start, insertion) : text.replace(start, end, insertion);
        if (this.textFilter.test(text)) {
            int newCursorPosition;
            this.textSetter.accept(text);
            String plaintStringToInsert = RichText.fromFormattedString(string).getPlainText();
            this.selectionPos = this.cursorPos = (newCursorPosition = Math.min(text.getPlainText().length(), start + plaintStringToInsert.length()));
            this.notifyCursorFormattingChanged();
        }
    }

    public void removeCharsFromCursor(int offset) {
        RichText text = this.textGetter.get();
        if (this.selectionPos != this.cursorPos) {
            int start = Math.min(this.cursorPos, this.selectionPos);
            int end = Math.max(this.cursorPos, this.selectionPos);
            text = text.replace(start, end, RichText.empty());
            this.cursorPos = this.selectionPos = start;
        } else {
            int cursor = Util.offsetByCodepoints((String)text.getPlainText(), (int)this.cursorPos, (int)offset);
            int start = Math.min(cursor, this.cursorPos);
            int end = Math.max(cursor, this.cursorPos);
            text = text.replace(start, end, RichText.empty());
            this.selectionPos = this.cursorPos = start;
        }
        this.textSetter.accept(text);
        this.notifyCursorFormattingChanged();
    }

    public void copy() {
        this.setClipboardFn.accept(this.getSelectedFormattedText());
    }

    public void cut() {
        this.setClipboardFn.accept(this.getSelectedFormattedText());
        this.removeCharsFromCursor(0);
    }

    public String getSelectedFormattedText() {
        int i = Math.min(this.cursorPos, this.selectionPos);
        int j = Math.max(this.cursorPos, this.selectionPos);
        return this.textGetter.get().subText(i, j).getAsFormattedString();
    }

    public void paste() {
        this.insertText((String)this.getClipboardFn.get());
    }

    public void applyColorForSelection(ChatFormatting color) {
        this.applyFormatting(color, Set.of(), Set.of());
    }

    public void toggleModifierForSelection(ChatFormatting modifier, boolean toggled) {
        if (toggled) {
            this.applyFormatting(null, Set.of(modifier), Set.of());
        } else {
            this.applyFormatting(null, Set.of(), Set.of(modifier));
        }
    }

    private void applyFormatting(@Nullable ChatFormatting newColor, Set<ChatFormatting> addModifiers, Set<ChatFormatting> removeModifiers) {
        if (this.isSelecting()) {
            int start = Math.min(this.cursorPos, this.selectionPos);
            int end = Math.max(this.cursorPos, this.selectionPos);
            RichText text = this.textGetter.get().applyFormatting(start, end, newColor, addModifiers, removeModifiers);
            this.textSetter.accept(text);
        }
    }

    public void notifyCursorFormattingChanged() {
        if (this.stateCallback == null) {
            return;
        }
        Tuple<@Nullable ChatFormatting, Set<ChatFormatting>> format = this.getCursorFormatting();
        ChatFormatting color = (ChatFormatting)format.getA();
        HashSet<ChatFormatting> modifiers = new HashSet<ChatFormatting>((Collection)format.getB());
        this.stateCallback.onCursorFormattingChanged(color, modifiers);
    }

    public Tuple<@Nullable ChatFormatting, Set<ChatFormatting>> getCursorFormatting() {
        if (this.textGetter == null) {
            return new Tuple(null, Set.of());
        }
        int start = Math.min(this.cursorPos, this.selectionPos);
        int end = Math.max(this.cursorPos, this.selectionPos);
        return this.textGetter.get().getCommonFormat(start, end);
    }

    public void setSelectionRange(int start, int end) {
        super.setSelectionRange(start, end);
        this.notifyCursorFormattingChanged();
    }

    public void selectAll() {
        super.selectAll();
        this.notifyCursorFormattingChanged();
    }

    protected void resetSelectionIfNeeded(boolean shiftDown) {
        super.resetSelectionIfNeeded(shiftDown);
        this.notifyCursorFormattingChanged();
    }

    public static interface StateCallback {
        public void onCursorFormattingChanged(@Nullable ChatFormatting var1, Set<ChatFormatting> var2);
    }
}

