/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.book;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import me.chrr.scribble.book.RichText;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public record BookFile(String author, Collection<RichText> pages) {
    public static BookFile read(Path path) throws IOException {
        CompoundTag root = NbtIo.read((Path)path);
        if (root == null) {
            throw new IOException("could not read book nbt file");
        }
        String author = root.getString("author");
        List<RichText> pages = root.getList("pages", 8).stream().map(Tag::getAsString).map(RichText::fromFormattedString).toList();
        return new BookFile(author, pages);
    }

    public void write(Path path) throws IOException {
        ListTag pagesNbt = new ListTag();
        for (RichText page : this.pages) {
            pagesNbt.add((Object)StringTag.valueOf((String)page.getAsFormattedString()));
        }
        CompoundTag root = new CompoundTag();
        root.putString("author", this.author);
        root.put("pages", (Tag)pagesNbt);
        NbtIo.write((CompoundTag)root, (Path)path);
    }
}

