/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.network.client;

import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.puzzleslib.api.network.v2.WritableMessage;
import fuzs.statuemenus.api.v1.world.inventory.ArmorStandMenu;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.jetbrains.annotations.Nullable;

public class C2SStrawStatueSetProfileMessage
implements WritableMessage<C2SStrawStatueSetProfileMessage> {
    private final String profileName;
    private final boolean clearOfflinePlayerProfile;

    public C2SStrawStatueSetProfileMessage(String profileName, boolean clearOfflinePlayerProfile) {
        this.profileName = profileName;
        this.clearOfflinePlayerProfile = clearOfflinePlayerProfile;
    }

    public C2SStrawStatueSetProfileMessage(FriendlyByteBuf buf) {
        this.profileName = buf.readUtf();
        this.clearOfflinePlayerProfile = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.profileName);
        buf.writeBoolean(this.clearOfflinePlayerProfile);
    }

    public MessageV2.MessageHandler<C2SStrawStatueSetProfileMessage> makeHandler() {
        return new MessageV2.MessageHandler<C2SStrawStatueSetProfileMessage>(this){

            public void handle(C2SStrawStatueSetProfileMessage message, Player player, Object gameInstance) {
                String s;
                ArmorStandMenu menu;
                AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                if (abstractContainerMenu instanceof ArmorStandMenu && (menu = (ArmorStandMenu)abstractContainerMenu).stillValid(player) && StringUtil.isValidPlayerName((String)(s = StringUtil.filterText((String)message.profileName)))) {
                    StrawStatue strawStatue = (StrawStatue)menu.getArmorStand();
                    if (!message.clearOfflinePlayerProfile || 1.clearOfflinePlayerProfile(((MinecraftServer)gameInstance).getProfileCache(), strawStatue)) {
                        ResolvableProfile resolvableProfile = s.isEmpty() ? null : new ResolvableProfile(Optional.of(s), Optional.empty(), new PropertyMap());
                        strawStatue.setProfile(resolvableProfile);
                    }
                }
            }

            private static boolean clearOfflinePlayerProfile(@Nullable GameProfileCache gameProfileCache, StrawStatue strawStatue) {
                GameProfile gameProfile = strawStatue.getProfile().map(ResolvableProfile::gameProfile).orElse(null);
                if (gameProfile != null && C2SStrawStatueSetProfileMessage.isOfflinePlayerProfile(gameProfile)) {
                    return C2SStrawStatueSetProfileMessage.clearOfflinePlayerProfile(gameProfile.getName(), gameProfileCache);
                }
                return false;
            }
        };
    }

    public static boolean isOfflinePlayerProfile(GameProfile gameProfile) {
        return UUIDUtil.createOfflinePlayerUUID((String)gameProfile.getName()).equals(gameProfile.getId());
    }

    public static boolean clearOfflinePlayerProfile(String profileName, @Nullable GameProfileCache gameProfileCache) {
        profileName = profileName.toLowerCase(Locale.ROOT);
        boolean hasClearedProfile = false;
        LoadingCache profileCache = SkullBlockEntity.profileCacheByName;
        if (profileCache != null && profileCache.getIfPresent((Object)profileName) != null) {
            profileCache.invalidate((Object)profileName);
            hasClearedProfile = true;
        }
        if (gameProfileCache != null && gameProfileCache.profilesByName.containsKey(profileName)) {
            gameProfileCache.profilesByName.remove(profileName);
            hasClearedProfile = true;
        }
        return hasClearedProfile;
    }
}

