/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fuzs.strawstatues.client.model.StrawStatueModel;
import fuzs.strawstatues.client.renderer.entity.StrawStatueRenderer;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class StrawStatueDeadmau5EarsLayer
extends RenderLayer<StrawStatue, StrawStatueModel> {
    public StrawStatueDeadmau5EarsLayer(RenderLayerParent<StrawStatue, StrawStatueModel> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, StrawStatue livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Optional<ResourceLocation> texture;
        if ("deadmau5".equals(livingEntity.getName().getString()) && !livingEntity.isInvisible() && (texture = StrawStatueRenderer.getPlayerProfileTexture(livingEntity).map(PlayerSkin::texture)).isPresent()) {
            matrixStack.pushPose();
            if (((StrawStatueModel)this.getParentModel()).young) {
                matrixStack.translate(0.0, 0.6875, 0.0);
                matrixStack.scale(0.65f, 0.65f, 0.65f);
            }
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entitySolid((ResourceLocation)texture.get()));
            int i = LivingEntityRenderer.getOverlayCoords((LivingEntity)livingEntity, (float)0.0f);
            for (int j = 0; j < 2; ++j) {
                float f = Mth.lerp((float)partialTicks, (float)livingEntity.yRotO, (float)livingEntity.getYRot()) - Mth.lerp((float)partialTicks, (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot);
                float g = Mth.lerp((float)partialTicks, (float)livingEntity.xRotO, (float)livingEntity.getXRot());
                matrixStack.pushPose();
                matrixStack.mulPose(Axis.YP.rotationDegrees(f));
                matrixStack.mulPose(Axis.XP.rotationDegrees(g));
                matrixStack.translate((double)(0.375f * (float)(j * 2 - 1)), 0.0, 0.0);
                matrixStack.translate(0.0, -0.375, 0.0);
                matrixStack.mulPose(Axis.XP.rotationDegrees(-g));
                matrixStack.mulPose(Axis.YP.rotationDegrees(-f));
                float h = 1.3333334f;
                matrixStack.scale(1.3333334f, 1.3333334f, 1.3333334f);
                ((StrawStatueModel)this.getParentModel()).renderEars(matrixStack, vertexConsumer, packedLight, i);
                matrixStack.popPose();
            }
            matrixStack.popPose();
        }
    }
}

