/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client.gui.screens;

import com.google.common.collect.Lists;
import fuzs.statuemenus.api.v1.client.gui.components.NewTextureTickButton;
import fuzs.statuemenus.api.v1.client.gui.screens.ArmorStandPositionScreen;
import fuzs.statuemenus.api.v1.client.gui.screens.ArmorStandWidgetsScreen;
import fuzs.statuemenus.api.v1.network.client.data.DataSyncHandler;
import fuzs.statuemenus.api.v1.world.inventory.ArmorStandHolder;
import fuzs.statuemenus.api.v1.world.inventory.data.ArmorStandPose;
import fuzs.statuemenus.api.v1.world.inventory.data.ArmorStandScreenType;
import fuzs.strawstatues.init.ModRegistry;
import fuzs.strawstatues.network.client.C2SStrawStatueScaleMessage;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import net.minecraft.Util;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;

public class StrawStatueScaleScreen
extends ArmorStandPositionScreen {
    public static final String SCALE_TRANSLATION_KEY = "strawstatues.screen.position.scale";
    public static final String ROTATION_X_TRANSLATION_KEY = "strawstatues.screen.position.rotationX";
    public static final String ROTATION_Y_TRANSLATION_KEY = "strawstatues.screen.position.rotationY";
    public static final String ROTATION_Z_TRANSLATION_KEY = "strawstatues.screen.position.rotationZ";
    private AbstractWidget resetButton;

    public StrawStatueScaleScreen(ArmorStandHolder holder, Inventory inventory, Component component, DataSyncHandler dataSyncHandler) {
        super(holder, inventory, component, dataSyncHandler);
    }

    protected void init() {
        super.init();
        this.resetButton = (AbstractWidget)Util.make((Object)((NewTextureTickButton)this.addRenderableWidget((GuiEventListener)new NewTextureTickButton(this.leftPos + 6, this.topPos + 6, 20, 20, 240, 124, StrawStatueScaleScreen.getArmorStandWidgetsLocation(), button -> {
            C2SStrawStatueScaleMessage.ScaleDataType.RESET.consumer.accept((StrawStatue)this.holder.getArmorStand(), Float.valueOf(-1.0f));
            C2SStrawStatueScaleMessage.getValueSender(C2SStrawStatueScaleMessage.ScaleDataType.RESET).accept(Float.valueOf(-1.0f));
            this.widgets.forEach(ArmorStandWidgetsScreen.ArmorStandWidget::reset);
        }))), widget -> widget.setTooltip(Tooltip.create((Component)Component.translatable((String)"statuemenus.screen.rotations.reset"))));
    }

    protected List<ArmorStandWidgetsScreen.ArmorStandWidget> buildWidgets(ArmorStand armorStand) {
        StrawStatue strawStatue = (StrawStatue)armorStand;
        Object[] objectArray = new ArmorStandWidgetsScreen.ArmorStandWidget[4];
        objectArray[0] = new ScaleWidget((Component)Component.translatable((String)SCALE_TRANSLATION_KEY), strawStatue::getEntityScale, C2SStrawStatueScaleMessage.getValueSender(C2SStrawStatueScaleMessage.ScaleDataType.SCALE));
        objectArray[1] = new StrawRotationWidget(this, (Component)Component.translatable((String)ROTATION_X_TRANSLATION_KEY), strawStatue::getEntityXRotation, C2SStrawStatueScaleMessage.getValueSender(C2SStrawStatueScaleMessage.ScaleDataType.ROTATION_X), strawStatue::setEntityXRotation);
        objectArray[2] = new ArmorStandPositionScreen.RotationWidget((ArmorStandPositionScreen)this, (Component)Component.translatable((String)ROTATION_Y_TRANSLATION_KEY), () -> ((ArmorStand)armorStand).getYRot(), arg_0 -> ((DataSyncHandler)this.dataSyncHandler).sendRotation(arg_0));
        objectArray[3] = new StrawRotationWidget(this, (Component)Component.translatable((String)ROTATION_Z_TRANSLATION_KEY), strawStatue::getEntityZRotation, C2SStrawStatueScaleMessage.getValueSender(C2SStrawStatueScaleMessage.ScaleDataType.ROTATION_Z), strawStatue::setEntityZRotation);
        return Lists.newArrayList((Object[])objectArray);
    }

    protected void toggleMenuRendering(boolean disableMenuRendering) {
        super.toggleMenuRendering(disableMenuRendering);
        this.resetButton.visible = !disableMenuRendering;
    }

    public ArmorStandScreenType getScreenType() {
        return ModRegistry.STRAW_STATUE_SCALE_SCREEN_TYPE;
    }

    public static float toModelScale(double newValue) {
        newValue = newValue * 7.0 + 1.0;
        return StrawStatue.clampModelScale(newValue);
    }

    private class ScaleWidget
    extends ArmorStandPositionScreen.RotationWidget {
        public ScaleWidget(Component title, DoubleSupplier currentValue, Consumer<Float> newValue) {
            super((ArmorStandPositionScreen)StrawStatueScaleScreen.this, title, currentValue, newValue, -1.0);
        }

        protected double getCurrentValue() {
            return (this.currentValue.getAsDouble() - 1.0) / 7.0;
        }

        protected void setNewValue(double newValue) {
            this.newValue.accept(Float.valueOf(StrawStatueScaleScreen.toModelScale(newValue)));
        }

        protected Component getTooltipComponent(double mouseValue) {
            mouseValue = mouseValue * 9.0 + 1.0;
            mouseValue = Mth.clamp((double)mouseValue, (double)1.0, (double)10.0);
            return Component.literal((String)ArmorStandPose.ROTATION_FORMAT.format(mouseValue));
        }

        protected void applyClientValue(double newValue) {
            ((StrawStatue)StrawStatueScaleScreen.this.holder.getArmorStand()).setEntityScale(StrawStatueScaleScreen.toModelScale(newValue));
        }
    }

    private class StrawRotationWidget
    extends ArmorStandPositionScreen.RotationWidget {
        private final Consumer<Float> newClientValue;

        public StrawRotationWidget(StrawStatueScaleScreen strawStatueScaleScreen, Component title, DoubleSupplier currentValue, Consumer<Float> newValue, Consumer<Float> newClientValue) {
            super((ArmorStandPositionScreen)strawStatueScaleScreen, title, currentValue, newValue);
            this.newClientValue = newClientValue;
        }

        protected double getCurrentValue() {
            return this.currentValue.getAsDouble() / 360.0;
        }

        protected void setNewValue(double newValue) {
            this.newValue.accept(Float.valueOf((float)(newValue * 360.0)));
        }

        protected void applyClientValue(double newValue) {
            this.newClientValue.accept(Float.valueOf((float)(newValue * 360.0)));
        }
    }
}

