/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.textures.ImageTransformer;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.block.Rotation;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextureImage
implements AutoCloseable {
    @Nullable
    private final McMetaFile metadata;
    private final NativeImage image;
    private final FrameSize frameSize;
    private final int frameCount;
    private final int frameScale;

    private TextureImage(NativeImage image, @Nullable McMetaFile metadata) {
        this.image = image;
        this.metadata = metadata;
        int imgWidth = this.imageWidth();
        int imgHeight = this.imageHeight();
        this.frameSize = metadata == null ? new FrameSize(imgWidth, imgHeight) : metadata.animation().calculateFrameSize(imgWidth, imgHeight);
        this.frameScale = imgWidth / this.frameSize.width();
        int frameScaleHeight = imgHeight / this.frameSize.height();
        this.frameCount = this.frameScale * frameScaleHeight;
    }

    public void forEachFramePixel(FramePixelConsumer framePixelConsumer) {
        for (int ind = 0; ind < this.frameCount; ++ind) {
            int xOff = this.getFrameStartX(ind);
            int yOff = this.getFrameStartY(ind);
            for (int x = 0; x < this.frameWidth(); ++x) {
                for (int y = 0; y < this.frameHeight(); ++y) {
                    framePixelConsumer.accept(ind, x + xOff, y + yOff);
                }
            }
        }
    }

    public void toGrayscale() {
        SpriteUtils.grayscaleImage(this.image);
    }

    public RGBColor getAverageColor() {
        return SpriteUtils.averageColor(this.image);
    }

    public int frameWidth() {
        return this.frameSize.width();
    }

    public int frameHeight() {
        return this.frameSize.height();
    }

    public int getFrameStartX(int frameIndex) {
        return frameIndex % this.frameScale * this.frameWidth();
    }

    public int getFrameStartY(int frameIndex) {
        return frameIndex / this.frameScale * this.frameHeight();
    }

    public int getFramePixel(int frameIndex, int x, int y) {
        return this.image.getPixelRGBA(this.getFrameStartX(frameIndex) + x, this.getFrameStartY(frameIndex) + y);
    }

    public void setFramePixel(int frameIndex, int x, int y, int color) {
        this.image.setPixelRGBA(this.getFrameStartX(frameIndex) + x, this.getFrameStartY(frameIndex) + y, color);
    }

    public NativeImage getImage() {
        return this.image;
    }

    public int frameCount() {
        return this.frameCount;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public AnimationMetadataSection getMetadata() {
        return this.metadata == null ? null : this.metadata.animation();
    }

    public McMetaFile getMcMeta() {
        return this.metadata;
    }

    public TextureImage makeCopy() {
        NativeImage im = new NativeImage(this.imageWidth(), this.imageHeight(), false);
        im.copyFrom(this.image);
        return new TextureImage(im, this.metadata);
    }

    public TextureImage createAnimationTemplate(int length, McMetaFile useDataFrom) {
        McMetaFile newMetadata = useDataFrom.cloneWithSize(this.frameWidth(), this.frameHeight());
        NativeImage im = new NativeImage(this.frameWidth(), this.frameHeight() * length, false);
        TextureImage t = new TextureImage(im, newMetadata);
        t.forEachFramePixel((i, x, y) -> {
            int xo = this.getFrameX(i, x);
            int yo = this.getFrameY(i, y);
            t.image.setPixelRGBA(x.intValue(), y.intValue(), this.image.getPixelRGBA(xo, yo));
        });
        return t;
    }

    @Deprecated(forRemoval=true)
    public TextureImage createAnimationTemplate(int length, @NotNull AnimationMetadataSection useDataFrom) {
        return this.createAnimationTemplate(length, McMetaFile.of(useDataFrom));
    }

    @Deprecated(forRemoval=true)
    public TextureImage createAnimationTemplate(int length, List<AnimationFrame> frameData, int frameTime, boolean interpolate) {
        return this.createAnimationTemplate(length, new AnimationMetadataSection(frameData, this.frameWidth(), this.frameHeight(), frameTime, interpolate));
    }

    public static TextureImage open(ResourceManager manager, ResourceLocation relativePath) throws IOException {
        try {
            if (relativePath.getPath().endsWith(".png")) {
                relativePath = relativePath.withPath(relativePath.getPath().substring(0, relativePath.getPath().length() - 4));
            }
            ResourceLocation textureLoc = ResType.TEXTURES.getPath(relativePath);
            NativeImage i = SpriteUtils.readImage(manager, textureLoc);
            ResourceLocation metadataLoc = ResType.MCMETA.getPath(relativePath);
            McMetaFile metadata = null;
            Optional res = manager.getResource(metadataLoc);
            if (res.isPresent()) {
                try {
                    metadata = McMetaFile.read((Resource)res.get());
                }
                catch (Exception e) {
                    throw new IOException("Failed to open texture at location " + String.valueOf(relativePath) + ": failed to read mcmeta file", e);
                }
            }
            return new TextureImage(i, metadata);
        }
        catch (Exception e) {
            throw new IOException("Failed to open texture at location " + String.valueOf(relativePath) + ": no such file");
        }
    }

    public static TextureImage createNew(int width, int height) {
        return TextureImage.createNew(width, height, (McMetaFile)null);
    }

    public static TextureImage createNew(int width, int height, @Nullable McMetaFile metadata) {
        TextureImage v = new TextureImage(new NativeImage(width, height, false), metadata);
        v.clear();
        return v;
    }

    @Deprecated(forRemoval=true)
    public static TextureImage createNew(int width, int height, @Nullable AnimationMetadataSection animation) {
        return TextureImage.createNew(width, height, animation == null ? null : McMetaFile.of(animation));
    }

    public static TextureImage createMask(TextureImage original, Palette palette) {
        TextureImage copy = original.makeCopy();
        NativeImage nativeImage = copy.getImage();
        SpriteUtils.forEachPixel(nativeImage, (x, y) -> {
            int color = nativeImage.getPixelRGBA(x.intValue(), y.intValue());
            if (palette.hasColor(color)) {
                nativeImage.setPixelRGBA(x.intValue(), y.intValue(), 0);
            } else {
                nativeImage.setPixelRGBA(x.intValue(), y.intValue(), -16777216);
            }
        });
        return copy;
    }

    public TextureImage createResized(float widthScale, float heightScale) {
        int newW = (int)((float)this.imageWidth() * widthScale);
        int newH = (int)((float)this.imageHeight() * heightScale);
        McMetaFile meta = null;
        if (this.metadata != null) {
            int mW = (int)((float)this.metadata.animation().frameWidth * widthScale);
            int mH = (int)((float)this.metadata.animation().frameHeight * heightScale);
            meta = this.metadata.cloneWithSize(mW, mH);
        }
        TextureImage im = TextureImage.createNew(newW, newH, meta);
        ImageTransformer t = ImageTransformer.builder(this.frameWidth(), this.frameHeight(), im.frameWidth(), im.frameHeight()).copyRect(0, 0, this.frameWidth(), this.frameHeight(), 0, 0).build();
        t.apply(this, im);
        return im;
    }

    public void clear() {
        this.image.fillRect(0, 0, this.image.getWidth(), this.image.getHeight(), 0);
    }

    @Deprecated(forRemoval=true)
    public static TextureImage of(NativeImage image, @Nullable AnimationMetadataSection animation) {
        return new TextureImage(image, animation == null ? null : McMetaFile.of(animation));
    }

    public static TextureImage of(NativeImage image) {
        return new TextureImage(image, null);
    }

    public static TextureImage of(NativeImage image, @Nullable McMetaFile metadata) {
        return new TextureImage(image, metadata);
    }

    @Override
    public void close() {
        this.image.close();
    }

    public int imageWidth() {
        return this.image.getWidth();
    }

    public int imageHeight() {
        return this.image.getHeight();
    }

    public ImmutableList<NativeImage> splitFrames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.metadata == null) {
            builder.add((Object)this.image);
            return builder.build();
        }
        int imgWidth = this.imageWidth();
        int imgHeight = this.imageHeight();
        FrameSize fs = this.metadata.animation().calculateFrameSize(imgWidth, imgHeight);
        int frameScaleWidth = imgWidth / fs.width();
        int frameScaleHeight = imgHeight / fs.height();
        int maxFrames = frameScaleWidth * frameScaleHeight;
        ArrayList indexList = Lists.newArrayList();
        this.metadata.animation().forEachFrame((index, time) -> indexList.add(index));
        if (indexList.isEmpty()) {
            for (int l = 0; l < maxFrames; ++l) {
                indexList.add(l);
            }
        }
        if (indexList.size() <= 1) {
            builder.add((Object)this.image);
        } else {
            Iterator iterator = indexList.iterator();
            while (iterator.hasNext()) {
                int index2 = (Integer)iterator.next();
                int xOffset = index2 % frameScaleWidth * this.frameWidth();
                int yOffset = index2 / frameScaleWidth * this.frameHeight();
                if (index2 < 0 || xOffset + this.frameWidth() >= imgWidth || yOffset + this.frameHeight() >= imgHeight) continue;
                NativeImage f = new NativeImage(this.frameWidth(), this.frameHeight(), false);
                for (int x = 0; x < this.frameWidth(); ++x) {
                    for (int y = 0; y < this.frameHeight(); ++y) {
                        f.setPixelRGBA(x, y, this.image.getPixelRGBA(x + xOffset, y + yOffset));
                    }
                }
                builder.add((Object)f);
            }
        }
        return builder.build();
    }

    private void applyOverlay(boolean onlyOnExisting, TextureImage ... overlays) throws IllegalStateException {
        for (TextureImage o : overlays) {
            if (o.frameWidth() < this.frameWidth()) {
                throw new IllegalStateException("Could not apply overlay onto images because overlay was too small (overlay W: " + o.frameWidth() + ", image W: " + this.frameWidth());
            }
            if (o.frameHeight() >= this.frameHeight()) continue;
            throw new IllegalStateException("Could not apply overlay onto images because overlay was too small (overlay H: " + o.frameHeight() + ", image H: " + this.frameHeight());
        }
        for (TextureImage o : overlays) {
            this.forEachFramePixel((frameIndex, globalX, globalY) -> {
                int frameX = this.getFrameX(frameIndex, globalX);
                int frameY = this.getFrameY(frameIndex, globalY);
                int targetOverlayFrame = Math.min(frameIndex, o.frameCount - 1);
                int overlayPixel = o.getFramePixel(targetOverlayFrame, frameX, frameY);
                if (onlyOnExisting && FastColor.ABGR32.alpha((int)overlayPixel) == 0) {
                    return;
                }
                this.image.blendPixel(globalX.intValue(), globalY.intValue(), overlayPixel);
            });
            o.close();
        }
    }

    private int getFrameY(Integer frameIndex, Integer globalY) {
        return globalY - this.getFrameStartY(frameIndex);
    }

    private int getFrameX(Integer frameIndex, Integer globalX) {
        return globalX - this.getFrameStartX(frameIndex);
    }

    public void applyOverlay(TextureImage ... overlays) throws IllegalStateException {
        this.applyOverlay(false, overlays);
    }

    public void applyOverlayOnExisting(TextureImage ... overlays) throws IllegalStateException {
        this.applyOverlay(true, overlays);
    }

    public void removeAlpha(int backgroundColor) {
        for (int x = 0; x < this.image.getWidth(); ++x) {
            for (int y = 0; y < this.image.getHeight(); ++y) {
                int oldValue = this.image.getPixelRGBA(x, y);
                int a = FastColor.ABGR32.alpha((int)oldValue);
                if (a == 0) {
                    this.image.setPixelRGBA(x, y, backgroundColor);
                    continue;
                }
                this.image.setPixelRGBA(x, y, FastColor.ABGR32.color((int)255, (int)FastColor.ABGR32.blue((int)oldValue), (int)FastColor.ABGR32.green((int)oldValue), (int)FastColor.ABGR32.red((int)oldValue)));
            }
        }
    }

    public void crop(TextureImage mask) {
        this.crop(mask, true);
    }

    public void crop(TextureImage mask, boolean discardInner) {
        int width = this.imageWidth();
        int height = this.imageHeight();
        if (mask.imageHeight() < height || mask.imageWidth() < width) {
            throw new IllegalStateException("Could not merge images because they had different dimensions");
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (FastColor.ABGR32.alpha((int)mask.image.getPixelRGBA(x, y)) != 0 != discardInner) continue;
                this.image.setPixelRGBA(x, y, 0);
            }
        }
        mask.close();
    }

    public TextureImage createRotated(Rotation rotation) {
        TextureImage flippedImage = TextureImage.createNew(this.frameHeight(), this.frameWidth() * this.frameCount, this.metadata);
        this.forEachFramePixel((frameIndex, globalX, globalY) -> {
            int frameX = this.getFrameX(frameIndex, globalX);
            int frameY = this.getFrameY(frameIndex, globalY);
            int newFrameX = frameX;
            int newFrameY = frameY;
            int frameWidth = this.frameWidth();
            int frameHeight = this.frameHeight();
            if (rotation == Rotation.CLOCKWISE_90) {
                newFrameX = frameHeight - frameY - 1;
                newFrameY = frameX;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                newFrameX = frameWidth - frameX - 1;
                newFrameY = frameHeight - frameY - 1;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                newFrameX = frameY;
                newFrameY = frameWidth - frameX - 1;
            }
            int newGlobalX = flippedImage.getFrameStartX(frameIndex) + newFrameX;
            int newGlobalY = flippedImage.getFrameStartY(frameIndex) + newFrameY;
            int pixel = this.getImage().getPixelRGBA(globalX.intValue(), globalY.intValue());
            flippedImage.getImage().setPixelRGBA(newGlobalX, newGlobalY, pixel);
        });
        return flippedImage;
    }

    @FunctionalInterface
    public static interface FramePixelConsumer
    extends TriConsumer<Integer, Integer, Integer> {
        public void accept(Integer var1, Integer var2, Integer var3);
    }
}

