/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.client.gui.screen;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.gui.Widgets;
import io.github.mortuusars.exposure.client.gui.screen.album.ChildPhotographScreen;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.PalettedImage;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImage;
import io.github.mortuusars.exposure.client.render.image.RenderCoordinates;
import io.github.mortuusars.exposure.client.task.ExportExposuresTask;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.ColorPalettes;
import io.github.mortuusars.exposure.data.export.ExportLook;
import io.github.mortuusars.exposure.data.export.ExportSize;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import io.github.mortuusars.exposure_catalog.ExposureCatalog;
import io.github.mortuusars.exposure_catalog.client.gui.Mode;
import io.github.mortuusars.exposure_catalog.client.gui.Order;
import io.github.mortuusars.exposure_catalog.client.gui.Sorting;
import io.github.mortuusars.exposure_catalog.client.gui.screen.ConfirmScreen;
import io.github.mortuusars.exposure_catalog.client.gui.screen.SelectionHandler;
import io.github.mortuusars.exposure_catalog.client.gui.screen.Thumbnail;
import io.github.mortuusars.exposure_catalog.client.gui.screen.tooltip.BelowOrAboveAreaTooltipPositioner;
import io.github.mortuusars.exposure_catalog.client.gui.screen.widget.EnumButton;
import io.github.mortuusars.exposure_catalog.data.ExposureInfo;
import io.github.mortuusars.exposure_catalog.data.client.CatalogClient;
import io.github.mortuusars.exposure_catalog.network.Packets;
import io.github.mortuusars.exposure_catalog.network.packet.serverbound.CatalogClosedC2SP;
import io.github.mortuusars.exposure_catalog.network.packet.serverbound.DeleteExposureC2SP;
import io.github.mortuusars.exposure_catalog.network.packet.serverbound.QueryExposuresC2SP;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CatalogScreen
extends Screen {
    public static final WidgetSprites REFRESH_BUTTON_SPRITES = Widgets.threeStateSprites((ResourceLocation)ExposureCatalog.resource("refresh"));
    public static final WidgetSprites EXPORT_BUTTON_SPRITES = Widgets.threeStateSprites((ResourceLocation)ExposureCatalog.resource("export"));
    public static final WidgetSprites EXPORT_STOP_BUTTON_SPRITES = Widgets.threeStateSprites((ResourceLocation)ExposureCatalog.resource("export_stop"));
    public static final WidgetSprites DELETE_BUTTON_SPRITES = Widgets.threeStateSprites((ResourceLocation)ExposureCatalog.resource("delete"));
    public static final ResourceLocation TEXTURE = ExposureCatalog.resource("textures/gui/catalog.png");
    public static final int TEX_SIZE = 512;
    public static final int ROWS = 4;
    public static final int COLS = 6;
    protected static final int SCROLL_THUMB_TOP_HEIGHT = 3;
    protected static final int SCROLL_THUMB_MID_HEIGHT = 4;
    protected static final int SCROLL_THUMB_BOT_HEIGHT = 2;
    public static final int REFRESH_COOLDOWN_MS = 500;
    public static final int RELOAD_COOLDOWN_MS = 5000;
    protected final File stateFile;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    protected Rect2i windowArea;
    protected Rect2i scrollBarArea;
    protected Rect2i searchBarArea;
    protected Rect2i thumbnailsArea;
    protected EnumButton<Order> orderButton;
    protected EnumButton<Sorting> sortingButton;
    protected EditBox searchBox;
    protected EnumButton<Mode> modeButton;
    protected Rect2i scrollThumb;
    protected List<Thumbnail> thumbnails;
    protected Button refreshButton;
    protected Button exportButton;
    protected Button exportStopButton;
    protected Button deleteButton;
    protected Mode mode;
    protected Order order;
    protected Sorting sorting;
    protected ExportSize exportSize;
    protected ExportLook exportLook;
    protected boolean isLoading;
    protected boolean haveExposures;
    protected List<String> exposures;
    protected List<String> textures;
    protected ArrayList<String> filteredItems;
    protected SelectionHandler selection;
    protected int totalRows;
    protected int topRowIndex;
    protected boolean isThumbnailsGridFocused;
    protected int focusedThumbnailIndex;
    protected boolean isDraggingScrollbar;
    protected int topRowIndexAtDragStart;
    protected double dragDelta;
    protected boolean initialized;
    protected long refreshCooldownExpireTime;
    protected long lastScrolledTime;

    public CatalogScreen() {
        super((Component)Component.translatable((String)"gui.exposure_catalog.catalog"));
        this.stateFile = new File(Minecraft.getInstance().gameDirectory, "exposure_catalog_state.json");
        this.windowArea = new Rect2i(0, 0, 361, 265);
        this.scrollBarArea = new Rect2i(343, 22, 10, 221);
        this.searchBarArea = new Rect2i(219, 7, 118, 10);
        this.thumbnailsArea = new Rect2i(8, 22, 329, 221);
        this.scrollThumb = new Rect2i(0, 0, 0, 0);
        this.thumbnails = Collections.synchronizedList(new ArrayList());
        this.mode = Mode.EXPOSURES;
        this.order = Order.ASCENDING;
        this.sorting = Sorting.DATE;
        this.exportSize = ExportSize.X1;
        this.exportLook = ExportLook.REGULAR;
        this.haveExposures = true;
        this.exposures = new ArrayList<String>();
        this.textures = Collections.emptyList();
        this.filteredItems = new ArrayList();
        this.selection = new SelectionHandler();
        this.totalRows = 0;
        this.topRowIndex = 0;
        this.isDraggingScrollbar = false;
        this.topRowIndexAtDragStart = 0;
        this.dragDelta = 0.0;
        this.refreshCooldownExpireTime = 0L;
        this.lastScrolledTime = 0L;
    }

    public void onExposuresReceived(Map<String, ExposureInfo> exposuresList) {
        this.isLoading = false;
        this.haveExposures = !exposuresList.isEmpty();
        this.exposures = new ArrayList<String>(exposuresList.keySet().stream().toList());
        this.orderAndSortExposuresList(this.order, this.sorting);
        if (this.mode == Mode.EXPOSURES) {
            this.topRowIndex = 0;
            this.refreshSearchResults();
        }
    }

    protected void init() {
        super.init();
        this.imageWidth = this.windowArea.getWidth();
        this.imageHeight = this.windowArea.getHeight();
        this.leftPos = this.width / 2 - this.imageWidth / 2;
        this.topPos = this.height / 2 - this.imageHeight / 2;
        this.scrollBarArea = new Rect2i(this.leftPos + 343, this.topPos + 22, 10, 221);
        this.searchBarArea = new Rect2i(this.leftPos + 219, this.topPos + 7, 118, 10);
        this.thumbnailsArea = new Rect2i(this.leftPos + 8, this.topPos + 22, 329, 221);
        this.orderButton = new EnumButton<Order>(Order.class, this.leftPos + 188, this.topPos + 6, 12, 12, ExposureCatalog.resource("order"), (b, prev, current) -> this.changeOrder((Order)current), (Component)Component.translatable((String)"gui.exposure_catalog.catalog.order")){

            public void playDownSound(SoundManager handler) {
                CatalogScreen.this.playClickSound();
            }
        };
        this.orderButton.setTooltipFunc((Function<Order, Tooltip>)((Function)value -> {
            MutableComponent component = Component.translatable((String)"gui.exposure_catalog.catalog.order");
            for (Order v : Order.values()) {
                component.append("\n ");
                component.append((Component)Component.translatable((String)("gui.exposure_catalog.catalog.order." + v.getSerializedName())).withStyle(Style.EMPTY.withColor(value == v ? 0x6677FF : 0x444444)));
            }
            return Tooltip.create((Component)component);
        }));
        this.addRenderableWidget((GuiEventListener)this.orderButton);
        this.sortingButton = new EnumButton<Sorting>(Sorting.class, this.leftPos + 203, this.topPos + 6, 12, 12, ExposureCatalog.resource("sorting"), (b, prev, current) -> this.changeSorting((Sorting)current), (Component)Component.translatable((String)"gui.exposure_catalog.catalog.sorting")){

            public void playDownSound(SoundManager handler) {
                CatalogScreen.this.playClickSound();
            }
        };
        this.sortingButton.setTooltipFunc((Function<Sorting, Tooltip>)((Function)value -> {
            MutableComponent component = Component.translatable((String)"gui.exposure_catalog.catalog.sorting");
            for (Sorting v : Sorting.values()) {
                component.append("\n ");
                component.append((Component)Component.translatable((String)("gui.exposure_catalog.catalog.sorting." + v.getSerializedName())).withStyle(Style.EMPTY.withColor(value == v ? 0x6677FF : 0x444444)));
            }
            return Tooltip.create((Component)component);
        }));
        this.addRenderableWidget((GuiEventListener)this.sortingButton);
        int n = this.searchBarArea.getX() + 1;
        int n2 = this.searchBarArea.getY() + 1;
        int n3 = this.searchBarArea.getWidth();
        Objects.requireNonNull(this.font);
        this.searchBox = new EditBox(this.font, n, n2, n3, 9, (Component)Component.translatable((String)"itemGroup.search"));
        this.searchBox.setMaxLength(99);
        this.searchBox.setBordered(false);
        this.searchBox.setVisible(true);
        this.searchBox.setTextColor(0xFFFFFF);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.modeButton = new EnumButton<Mode>(Mode.class, this.leftPos + 342, this.topPos + 6, 12, 12, ExposureCatalog.resource("mode"), (b, prev, current) -> this.changeMode((Mode)current), (Component)Component.translatable((String)"gui.exposure_catalog.catalog.mode")){

            public void playDownSound(SoundManager handler) {
                CatalogScreen.this.playClickSound();
            }
        };
        this.modeButton.setTooltipFunc((Function<Mode, Tooltip>)((Function)value -> {
            MutableComponent component = Component.translatable((String)"gui.exposure_catalog.catalog.mode").append(" ").append((Component)Component.translatable((String)"gui.exposure_catalog.catalog.mode.hotkey"));
            for (Mode v : Mode.values()) {
                component.append("\n ");
                component.append((Component)Component.translatable((String)("gui.exposure_catalog.catalog.mode." + v.getSerializedName())).withStyle(Style.EMPTY.withColor(value == v ? 0x6677FF : 0x444444)));
            }
            return Tooltip.create((Component)component);
        }));
        this.addRenderableWidget((GuiEventListener)this.modeButton);
        this.refreshButton = new ImageButton(this.leftPos + 7, this.topPos + 247, 12, 12, REFRESH_BUTTON_SPRITES, b -> this.refresh());
        this.refreshButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.exposure_catalog.catalog.refresh").append(" ").append((Component)Component.translatable((String)"gui.exposure_catalog.catalog.refresh.hotkey")).append("\n").append((Component)Component.translatable((String)"gui.exposure_catalog.catalog.refresh.tooltip"))));
        this.addRenderableWidget((GuiEventListener)this.refreshButton);
        this.exportButton = new ImageButton(this.leftPos + 26, this.topPos + 247, 12, 12, EXPORT_BUTTON_SPRITES, b -> this.exportExposures()){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                if (this.isHoveredOrFocused()) {
                    this.setTooltip(Tooltip.create((Component)CatalogScreen.this.createExportButtonTooltip()));
                }
                super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (!(this.isHoveredOrFocused() && this.active && this.visible)) {
                    return super.mouseClicked(mouseX, mouseY, button);
                }
                if (Screen.hasControlDown()) {
                    CatalogScreen.this.exportSize = ExportSize.values()[(CatalogScreen.this.exportSize.ordinal() + 1) % ExportSize.values().length];
                    CatalogScreen.this.playClickSound();
                    return true;
                }
                if (Screen.hasShiftDown()) {
                    CatalogScreen.this.exportLook = ExportLook.values()[(CatalogScreen.this.exportLook.ordinal() + 1) % ExportLook.values().length];
                    CatalogScreen.this.playClickSound();
                    return true;
                }
                return super.mouseClicked(mouseX, mouseY, button);
            }

            public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
                if (!(this.isHoveredOrFocused() && this.active && this.visible)) {
                    return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
                }
                if (Screen.hasControlDown()) {
                    int newValue = CatalogScreen.this.exportSize.ordinal() - (int)scrollY;
                    if (newValue < 0) {
                        newValue = ExportSize.values().length - 1;
                    } else if (newValue >= ExportSize.values().length) {
                        newValue = 0;
                    }
                    if (CatalogScreen.this.exportSize != ExportSize.values()[newValue]) {
                        CatalogScreen.this.playClickSound();
                        CatalogScreen.this.exportSize = ExportSize.values()[newValue];
                    }
                    return true;
                }
                if (Screen.hasShiftDown()) {
                    int newValue = CatalogScreen.this.exportLook.ordinal() - (int)scrollY;
                    if (newValue < 0) {
                        newValue = ExportLook.values().length - 1;
                    } else if (newValue >= ExportLook.values().length) {
                        newValue = 0;
                    }
                    if (CatalogScreen.this.exportLook != ExportLook.values()[newValue]) {
                        CatalogScreen.this.playClickSound();
                        CatalogScreen.this.exportLook = ExportLook.values()[newValue];
                    }
                    return true;
                }
                return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
            }

            public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                if (!(this.isHoveredOrFocused() && this.active && this.visible)) {
                    return super.keyPressed(keyCode, scanCode, modifiers);
                }
                if (CommonInputs.selected((int)keyCode) && Screen.hasControlDown()) {
                    CatalogScreen.this.exportSize = ExportSize.values()[(CatalogScreen.this.exportSize.ordinal() + 1) % ExportSize.values().length];
                    CatalogScreen.this.playClickSound();
                    return true;
                }
                if (CommonInputs.selected((int)keyCode) && Screen.hasShiftDown()) {
                    CatalogScreen.this.exportLook = ExportLook.values()[(CatalogScreen.this.exportLook.ordinal() + 1) % ExportLook.values().length];
                    CatalogScreen.this.playClickSound();
                    return true;
                }
                return super.keyPressed(keyCode, scanCode, modifiers);
            }
        };
        this.exportButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.exposure_catalog.catalog.export")));
        this.addRenderableWidget((GuiEventListener)this.exportButton);
        this.exportStopButton = new ImageButton(this.leftPos + 26, this.topPos + 247, 12, 12, EXPORT_STOP_BUTTON_SPRITES, b -> ExportExposuresTask.stopCurrentTask());
        this.exportStopButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.exposure_catalog.catalog.export_stop").append(" ").append((Component)Component.translatable((String)"gui.exposure_catalog.catalog.export.hotkey"))));
        this.addRenderableWidget((GuiEventListener)this.exportStopButton);
        this.deleteButton = new ImageButton(this.leftPos + 342, this.topPos + 247, 12, 12, DELETE_BUTTON_SPRITES, b -> this.deleteExposures());
        this.deleteButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.exposure_catalog.catalog.delete").append(" ").append((Component)Component.translatable((String)"gui.exposure_catalog.catalog.delete.hotkey")).append("\n").append((Component)Component.translatable((String)"gui.exposure_catalog.catalog.delete.tooltip"))));
        this.addRenderableWidget((GuiEventListener)this.deleteButton);
        if (!this.initialized) {
            this.loadState();
            ExposureClient.exposureStore().clear();
            Packets.sendToServer(new QueryExposuresC2SP(false));
            this.isLoading = true;
            if (this.mode == Mode.TEXTURES) {
                this.refresh();
            }
            this.initialized = true;
        }
        this.updateElements();
    }

    protected void playClickSound() {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)Exposure.SoundEvents.CAMERA_DIAL_CLICK.get()), (float)1.0f, (float)0.8f));
    }

    protected Component createExportButtonTooltip() {
        MutableComponent tooltip = Component.translatable((String)("gui.exposure_catalog.catalog.export." + (this.selection.isEmpty() || this.selection.size() == this.exposures.size() ? "all" : "selected"))).append(" ").append((Component)Component.translatable((String)"gui.exposure_catalog.catalog.export.hotkey"));
        tooltip.append("\n");
        tooltip.append((Component)Component.translatable((String)"gui.exposure_catalog.catalog.export.location_info"));
        tooltip.append("\n").append("\n").append((Component)Component.translatable((String)"gui.exposure_catalog.catalog.export.size"));
        for (ExportSize exportSize : ExportSize.values()) {
            tooltip.append("\n");
            tooltip.append((Component)Component.translatable((String)("gui.exposure_catalog.catalog.export.size." + exportSize.getSerializedName())).withStyle(Style.EMPTY.withColor(this.exportSize == exportSize ? 0x6677FF : 0x444444)));
        }
        tooltip.append("\n").append("\n").append((Component)Component.translatable((String)"gui.exposure_catalog.catalog.export.look"));
        for (ExportSize exportSize : ExportLook.values()) {
            tooltip.append("\n").append((Component)Component.translatable((String)("gui.exposure_catalog.catalog.export.look." + exportSize.getSerializedName())).withStyle(Style.EMPTY.withColor(this.exportLook == exportSize ? 0x6677FF : 0x444444)));
        }
        tooltip.append("\n").append("\n").append((Component)Component.translatable((String)"gui.exposure_catalog.catalog.export.control_info"));
        return tooltip;
    }

    protected boolean canRefresh() {
        if (this.mode == Mode.TEXTURES) {
            return true;
        }
        if (this.mode == Mode.EXPOSURES && this.isLoading) {
            return false;
        }
        return Util.getMillis() >= this.refreshCooldownExpireTime;
    }

    protected void refresh() {
        if (!this.canRefresh()) {
            return;
        }
        if (this.mode == Mode.EXPOSURES) {
            ExposureClient.exposureStore().clear();
            boolean reload = Screen.hasShiftDown();
            Packets.sendToServer(new QueryExposuresC2SP(reload));
            if (reload) {
                this.isLoading = true;
                CatalogClient.clear();
            }
            this.refreshCooldownExpireTime = Util.getMillis() + (long)(reload ? 5000 : 500);
        } else if (this.mode == Mode.TEXTURES) {
            Map resources = Minecraft.getInstance().getResourceManager().listResources("textures", rl -> true);
            this.textures = resources.keySet().stream().map(ResourceLocation::toString).collect(Collectors.toCollection(ArrayList::new));
            this.orderTexturesList(this.order);
            this.refreshSearchResults();
            this.updateElements();
        }
    }

    protected void exportExposures() {
        ArrayList<String> exposureIds;
        if (this.mode == Mode.TEXTURES) {
            return;
        }
        List<String> list = exposureIds = !this.selection.isEmpty() ? this.selection.get().stream().map(i -> this.filteredItems.get((int)i)).toList() : this.filteredItems;
        if (exposureIds.size() > 100) {
            MutableComponent message = Component.translatable((String)"gui.exposure_catalog.catalog.confirm.message.export_all", (Object[])new Object[]{exposureIds.size()});
            ConfirmScreen confirmScreen = new ConfirmScreen(this, (Component)message, CommonComponents.GUI_YES, b -> this.exportExposures(exposureIds, this.exportSize, this.exportLook), CommonComponents.GUI_NO, b -> {});
            Minecraft.getInstance().setScreen((Screen)confirmScreen);
        } else {
            this.exportExposures(exposureIds, this.exportSize, this.exportLook);
        }
    }

    protected void exportExposures(List<String> exposureIds, ExportSize size, ExportLook look) {
        ExportExposuresTask.start(exposureIds, (ExportSize)size, (ExportLook)look);
    }

    protected void deleteExposures() {
        if (this.mode != Mode.EXPOSURES || this.selection.isEmpty() || this.filteredItems.isEmpty()) {
            return;
        }
        if (Screen.hasShiftDown()) {
            this.deleteExposuresNoConfirm();
        } else {
            MutableComponent message;
            if (this.selection.size() == 1) {
                String exposureId = this.filteredItems.get(this.selection.get().iterator().next());
                message = Component.translatable((String)"gui.exposure_catalog.catalog.confirm.message.delete_one", (Object[])new Object[]{exposureId});
            } else {
                message = Component.translatable((String)"gui.exposure_catalog.catalog.confirm.message.delete_many", (Object[])new Object[]{this.selection.size()});
            }
            ConfirmScreen confirmScreen = new ConfirmScreen(this, (Component)message, CommonComponents.GUI_YES, b -> this.deleteExposuresNoConfirm(), CommonComponents.GUI_NO, b -> {});
            Minecraft.getInstance().setScreen((Screen)confirmScreen);
        }
    }

    protected void deleteExposuresNoConfirm() {
        int globalIndex;
        if (this.mode != Mode.EXPOSURES || this.selection.isEmpty() || this.filteredItems.isEmpty()) {
            return;
        }
        ArrayList<String> removedIds = new ArrayList<String>();
        for (Integer index : this.selection.get()) {
            if (index < 0 || index >= this.filteredItems.size()) continue;
            String exposureId = this.filteredItems.get(index);
            Packets.sendToServer(new DeleteExposureC2SP(exposureId));
            removedIds.add(exposureId);
        }
        for (String id : removedIds) {
            this.exposures.remove(id);
            this.filteredItems.remove(id);
            CatalogClient.removeExposure(id);
            this.scrollTo(this.topRowIndex);
        }
        this.selection.clear();
        if (this.isThumbnailsGridFocused && (globalIndex = this.focusedThumbnailIndex + this.topRowIndex * 6) >= 0 && globalIndex < this.filteredItems.size() - 1) {
            this.selection.select(globalIndex);
        }
        this.updateElements();
    }

    protected void updateButtons() {
        this.orderButton.setState(this.order);
        this.sortingButton.setState(this.sorting);
        this.modeButton.setState(this.mode);
        this.sortingButton.active = this.mode == Mode.EXPOSURES;
        this.exportButton.visible = this.mode == Mode.EXPOSURES && !ExportExposuresTask.isRunning();
        this.exportButton.active = this.mode == Mode.EXPOSURES && !ExportExposuresTask.isRunning();
        this.exportStopButton.visible = ExportExposuresTask.isRunning();
        this.exportStopButton.active = ExportExposuresTask.isRunning();
        this.deleteButton.active = this.mode == Mode.EXPOSURES && !this.selection.isEmpty();
        this.refreshButton.active = this.canRefresh();
    }

    protected void changeMode(Mode mode) {
        this.mode = mode;
        if (mode == Mode.EXPOSURES && this.exposures.isEmpty() || mode == Mode.TEXTURES && this.textures.isEmpty()) {
            this.refresh();
        }
        this.updateButtons();
        this.refreshSearchResults();
    }

    protected void changeOrder(Order order) {
        this.order = order;
        if (this.mode == Mode.EXPOSURES) {
            this.orderAndSortExposuresList(this.order, this.sorting);
        } else {
            this.orderTexturesList(this.order);
        }
        this.updateButtons();
        this.refreshSearchResults();
    }

    protected void changeSorting(Sorting sorting) {
        this.sorting = sorting;
        if (this.mode == Mode.EXPOSURES) {
            this.orderAndSortExposuresList(this.order, this.sorting);
        }
        this.updateButtons();
        this.refreshSearchResults();
    }

    protected void orderAndSortExposuresList(Order order, Sorting sorting) {
        this.exposures.sort(Comparator.naturalOrder());
        if (sorting == Sorting.DATE) {
            Comparator<String> comparator = new Comparator<String>(this){

                @Override
                public int compare(String s1, String s2) {
                    return Long.compare(this.getTimestamp(s1), this.getTimestamp(s2));
                }

                private long getTimestamp(String exposureId) {
                    @Nullable ExposureInfo exposureInfo = CatalogClient.getExposures().get(exposureId);
                    return exposureInfo != null ? exposureInfo.tag().unixTimestamp() : 0L;
                }
            };
            this.exposures.sort(comparator);
        }
        if (order == Order.DESCENDING) {
            Collections.reverse(this.exposures);
        }
    }

    protected void orderTexturesList(Order order) {
        this.textures.sort(order == Order.ASCENDING ? Comparator.naturalOrder() : Comparator.reverseOrder());
    }

    protected void rebuildWidgets() {
        String searchBoxValue = this.searchBox.getValue();
        super.rebuildWidgets();
        this.searchBox.setValue(searchBoxValue);
    }

    protected void refreshSearchResults() {
        List<String> items = this.mode == Mode.EXPOSURES ? this.exposures : this.textures;
        String filter = this.searchBox != null ? this.searchBox.getValue().trim() : "";
        String[] queries = filter.split("\\s+");
        this.filterSearchResults(items, queries, this.mode);
        this.totalRows = (int)Math.ceil((float)this.filteredItems.size() / 6.0f);
        this.selection.clear();
        this.scroll(Integer.MIN_VALUE);
    }

    protected void filterSearchResults(Collection<String> items, String[] queries, Mode mode) {
        this.filteredItems.clear();
        if (queries.length == 0) {
            this.filteredItems.addAll(items);
            return;
        }
        ArrayList<String> filtered = new ArrayList<String>(items);
        for (String query : queries) {
            if (query.isEmpty()) continue;
            if (mode == Mode.EXPOSURES && (query.startsWith("=") || query.startsWith("!="))) {
                boolean negative = query.startsWith("!=");
                String filter = query.substring(negative ? 2 : 1);
                if (filter.isEmpty()) continue;
                if ("printed".startsWith(filter)) {
                    filtered.removeIf(id -> !CatalogClient.getExposures().getOrDefault(id, ExposureInfo.EMPTY).tag().wasPrinted() ^ negative);
                    continue;
                }
                if ("projected".startsWith(filter)) {
                    filtered.removeIf(id -> !CatalogClient.getExposures().getOrDefault(id, ExposureInfo.EMPTY).tag().loaded() ^ negative);
                    continue;
                }
                if ("color".startsWith(filter)) {
                    filtered.removeIf(id -> CatalogClient.getExposures().getOrDefault(id, ExposureInfo.EMPTY).tag().type() != ExposureType.COLOR ^ negative);
                    continue;
                }
                if ("bw".startsWith(filter)) {
                    filtered.removeIf(id -> CatalogClient.getExposures().getOrDefault(id, ExposureInfo.EMPTY).tag().type() != ExposureType.BLACK_AND_WHITE ^ negative);
                    continue;
                }
                if (filter.startsWith("size:")) {
                    String sizeStr = filter.substring(5);
                    if (sizeStr.isEmpty() || !sizeStr.matches("^[0-9]+$")) continue;
                    int size = Integer.parseInt(sizeStr);
                    filtered.removeIf(id -> CatalogClient.getExposures().get(id).width() != size ^ negative);
                    continue;
                }
                if (filter.startsWith("palette:")) {
                    String palette = filter.substring(8).toLowerCase();
                    SearchTree tree = SearchTree.plainText(filtered, id -> CatalogClient.getExposures().get(id).paletteId().toString().lines());
                    ArrayList matches = new ArrayList(tree.search(palette));
                    if (negative) {
                        filtered.removeAll(matches);
                        continue;
                    }
                    filtered = matches;
                    continue;
                }
                filtered.clear();
                continue;
            }
            SearchTree tree = SearchTree.plainText(filtered, String::lines);
            filtered = new ArrayList(tree.search(query.toLowerCase(Locale.ROOT)));
        }
        this.filteredItems.addAll(filtered);
    }

    public void updateThumbnailsGrid() {
        this.thumbnails.clear();
        for (int row = 0; row < 4; ++row) {
            int gridIndex;
            int idIndex;
            for (int column = 0; column < 6 && (idIndex = (gridIndex = column + row * 6) + this.topRowIndex * 6) < this.filteredItems.size(); ++column) {
                int thumbnailX = column * 54;
                int thumbnailY = row * 54;
                String item = this.filteredItems.get(idIndex);
                ExposureIdentifier identifier = this.mode == Mode.EXPOSURES ? ExposureIdentifier.id((String)item) : ExposureIdentifier.texture((ResourceLocation)ResourceLocation.parse((String)item));
                Rect2i area = new Rect2i(this.thumbnailsArea.getX() + 5 + thumbnailX, this.thumbnailsArea.getY() + 5 + thumbnailY, 48, 48);
                boolean isSelected = this.selection.get().contains(idIndex);
                Thumbnail thumbnail = new Thumbnail(idIndex, gridIndex, identifier, area, isSelected);
                this.thumbnails.add(thumbnail);
            }
        }
        this.focusedThumbnailIndex = Mth.clamp((int)this.focusedThumbnailIndex, (int)0, (int)(this.thumbnails.size() - 1));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateButtons();
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 512);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderScrollBar(guiGraphics, mouseX, mouseY, partialTick);
        this.renderThumbnailsGrid(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderThumbnailsGrid(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (Thumbnail thumbnail : this.thumbnails) {
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            RenderableImage image = this.getThumbnailImage(thumbnail);
            RenderCoordinates coords = new RenderCoordinates((float)thumbnail.area().getX(), (float)thumbnail.area().getY(), (float)thumbnail.area().getWidth(), (float)thumbnail.area().getHeight());
            ExposureClient.imageRenderer().render(image, guiGraphics.pose(), (MultiBufferSource)bufferSource, coords, 0xF000F0, 255, 255, 255, 255);
            bufferSource.endBatch();
            int frameVOffset = thumbnail.selected() ? 108 : (thumbnail.isMouseOver(mouseX, mouseY) ? 54 : 0);
            RenderSystem.enableBlend();
            guiGraphics.blit(TEXTURE, thumbnail.area().getX() - 3, thumbnail.area().getY() - 3, 371.0f, (float)frameVOffset, 54, 54, 512, 512);
            RenderSystem.disableBlend();
        }
    }

    protected RenderableImage getThumbnailImage(Thumbnail thumbnail) {
        if (thumbnail.identifier().isTexture() || Minecraft.getInstance().isSingleplayer()) {
            return ExposureClient.renderedExposures().getOrCreateRaw(thumbnail.identifier());
        }
        String id = (String)thumbnail.identifier().getId().orElseThrow();
        return (Util.getMillis() - this.lastScrolledTime < 250L ? CatalogClient.getThumbnail(id) : CatalogClient.getOrQueryThumbnail(id)).map(thumb -> new PalettedImage(thumb.width(), thumb.height(), thumb.pixels(), thumb.paletteId())).map(img -> RenderableImage.of((String)("thumbnail_" + id), (Image)img)).orElse(RenderableImage.EMPTY);
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.searchBox.isMouseOver((double)mouseX, (double)mouseY)) {
            ArrayList<Object> lines = new ArrayList<Object>();
            lines.add(Component.translatable((String)"gui.exposure_catalog.searchbar").append(" ").append((Component)Component.translatable((String)"gui.exposure_catalog.searchbar.hotkey")));
            if (Screen.hasShiftDown()) {
                lines.add(Component.translatable((String)"gui.exposure_catalog.searchbar.tooltip.size"));
                lines.add(Component.translatable((String)"gui.exposure_catalog.searchbar.tooltip.palette"));
                lines.add(Component.translatable((String)"gui.exposure_catalog.searchbar.tooltip.color"));
                lines.add(Component.translatable((String)"gui.exposure_catalog.searchbar.tooltip.bw"));
                lines.add(Component.translatable((String)"gui.exposure_catalog.searchbar.tooltip.printed"));
                lines.add(Component.translatable((String)"gui.exposure_catalog.searchbar.tooltip.projected"));
                lines.add(CommonComponents.EMPTY);
                lines.add(Component.translatable((String)"gui.exposure_catalog.searchbar.tooltip.filters"));
                lines.add(Component.translatable((String)"gui.exposure_catalog.searchbar.tooltip.invert"));
            } else {
                lines.add(Component.translatable((String)"gui.exposure_catalog.searchbar.tooltip.control_info"));
            }
            guiGraphics.renderTooltip(this.font, lines, Optional.empty(), mouseX, mouseY);
        }
        for (Thumbnail thumbnail : this.thumbnails) {
            if (thumbnail.isMouseOver(mouseX, mouseY)) {
                List<Component> lines = this.getThumbnailTooltipLines(thumbnail);
                guiGraphics.renderTooltip(this.font, lines, Optional.empty(), mouseX, mouseY);
                break;
            }
            if (!this.isThumbnailsGridFocused || thumbnail.gridIndex() != this.focusedThumbnailIndex) continue;
            List<Component> lines = this.getThumbnailTooltipLines(thumbnail);
            guiGraphics.renderTooltip(this.font, Lists.transform(lines, Component::getVisualOrderText), (ClientTooltipPositioner)new BelowOrAboveAreaTooltipPositioner(thumbnail.area()), mouseX, mouseY);
            break;
        }
    }

    @NotNull
    private List<Component> getThumbnailTooltipLines(Thumbnail thumbnail) {
        ArrayList<Component> lines = new ArrayList<Component>();
        lines.add((Component)Component.literal((String)thumbnail.identifier().toValueString()));
        thumbnail.identifier().ifId(exposureId -> {
            @Nullable ExposureInfo exposureInfo = CatalogClient.getExposures().get(exposureId);
            if (exposureInfo != null) {
                long timestampSeconds = exposureInfo.tag().unixTimestamp();
                if (timestampSeconds > 0L) {
                    Date date = new Date(timestampSeconds * 1000L);
                    String pattern = "yyyy-MM-dd HH:mm:ss";
                    SimpleDateFormat format = new SimpleDateFormat(pattern);
                    String format1 = format.format(date);
                    lines.add((Component)Component.literal((String)format1).withStyle(ChatFormatting.GRAY));
                }
                lines.add((Component)Component.literal((String)(exposureInfo.width() + "x" + exposureInfo.height())).withStyle(ChatFormatting.GRAY));
                if (!exposureInfo.paletteId().equals((Object)ColorPalettes.DEFAULT.location())) {
                    lines.add((Component)Component.translatable((String)"gui.exposure_catalog.catalog.tooltip.palette", (Object[])new Object[]{exposureInfo.paletteId().toString()}).withStyle(ChatFormatting.GRAY));
                }
                if (exposureInfo.tag().wasPrinted()) {
                    lines.add((Component)Component.translatable((String)"gui.exposure_catalog.catalog.tooltip.printed").withStyle(ChatFormatting.GRAY));
                }
                if (exposureInfo.tag().loaded()) {
                    lines.add((Component)Component.translatable((String)"gui.exposure_catalog.catalog.tooltip.projected").withStyle(ChatFormatting.GRAY));
                }
            }
        });
        lines.add((Component)Component.empty());
        if (Screen.hasShiftDown()) {
            lines.add((Component)Component.translatable((String)"gui.exposure_catalog.thumbnail.tooltip.view"));
            lines.add((Component)Component.translatable((String)"gui.exposure_catalog.thumbnail.tooltip.selection"));
            lines.add((Component)Component.translatable((String)"gui.exposure_catalog.thumbnail.tooltip.selection.shift"));
            lines.add((Component)Component.translatable((String)"gui.exposure_catalog.thumbnail.tooltip.selection.clear"));
        } else {
            lines.add((Component)Component.translatable((String)"gui.exposure_catalog.thumbnail.tooltip.control_info"));
        }
        return lines;
    }

    protected boolean isMouseOver(Rect2i rect, double mouseX, double mouseY) {
        return mouseX >= (double)rect.getX() && mouseX < (double)(rect.getX() + rect.getWidth()) && mouseY >= (double)rect.getY() && mouseY < (double)(rect.getY() + rect.getHeight());
    }

    protected void renderScrollBar(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int state = 0;
        if (!this.canScroll()) {
            state = 2;
        } else if (this.isDraggingScrollbar || this.isMouseOver(this.scrollThumb, mouseX, mouseY)) {
            state = 1;
        }
        int thumbStateOffset = 9;
        guiGraphics.blit(TEXTURE, this.scrollThumb.getX(), this.scrollThumb.getY(), 361.0f, (float)(state * thumbStateOffset), this.scrollThumb.getWidth(), 3, 512, 512);
        int middleParts = (this.scrollThumb.getHeight() - 3 - 2) / 4;
        for (int i = 0; i < middleParts; ++i) {
            guiGraphics.blit(TEXTURE, this.scrollThumb.getX(), this.scrollThumb.getY() + i * 4 + 3, 361.0f, (float)(3 + state * thumbStateOffset), this.scrollThumb.getWidth(), 4, 512, 512);
        }
        guiGraphics.blit(TEXTURE, this.scrollThumb.getX(), this.scrollThumb.getY() + middleParts * 4 + 3, 361.0f, (float)(7 + state * thumbStateOffset), this.scrollThumb.getWidth(), 2, 512, 512);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        MutableComponent title = this.mode == Mode.EXPOSURES ? Component.translatable((String)"gui.exposure_catalog.catalog.exposures") : Component.translatable((String)"gui.exposure_catalog.catalog.textures");
        guiGraphics.drawString(this.font, (Component)title, this.leftPos + 8, this.topPos + 8, -12500671, false);
        if (this.mode == Mode.EXPOSURES && !this.isLoading && !this.haveExposures) {
            MutableComponent component = Component.translatable((String)"gui.exposure_catalog.catalog.no_exposures");
            int x = this.thumbnailsArea.getX() + this.thumbnailsArea.getWidth() / 2 - this.font.width((FormattedText)component) / 2;
            int y = this.thumbnailsArea.getY() + this.thumbnailsArea.getHeight() / 2 - 5;
            guiGraphics.drawString(this.font, (Component)component, x, y, -12500671, false);
        }
        if (this.isLoading && this.mode == Mode.EXPOSURES) {
            int dotAnimation = (int)(Util.getMillis() / 750L % 3L) + 1;
            MutableComponent component = Component.translatable((String)("gui.exposure_catalog.catalog.loading" + dotAnimation)).withStyle(Style.EMPTY.withColor(-12500671));
            guiGraphics.drawString(this.font, (Component)component, this.leftPos + this.imageWidth / 2 - this.font.width((FormattedText)component) / 2, this.topPos + 249, -12500671, false);
        } else if (!this.filteredItems.isEmpty()) {
            String filteredCountStr = Integer.toString(this.filteredItems.size());
            MutableComponent countComponent = Component.literal((String)filteredCountStr).withStyle(Style.EMPTY.withColor(-12500671));
            if (!this.selection.isEmpty()) {
                String selectedCountStr = Integer.toString(this.selection.size());
                countComponent = Component.literal((String)selectedCountStr).withStyle(Style.EMPTY.withColor(-13084453)).append((Component)Component.literal((String)"/").withStyle(Style.EMPTY.withColor(-12500671))).append((Component)countComponent);
            }
            guiGraphics.drawString(this.font, (Component)countComponent, this.leftPos + this.imageWidth / 2 - this.font.width((FormattedText)countComponent) / 2, this.topPos + 249, -12500671, false);
        }
        if (this.searchBox.isVisible() && !this.searchBox.isFocused() && this.searchBox.getValue().isEmpty()) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.exposure_catalog.catalog.search_bar_placeholder_text"), this.searchBarArea.getX() + 2, this.searchBarArea.getY() + 1, -4276546, false);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.setFocused(null);
        this.isThumbnailsGridFocused = false;
        if (button == 1 && this.searchBox.isMouseOver(mouseX, mouseY)) {
            String value = this.searchBox.getValue();
            this.searchBox.setValue("");
            if (!value.equals(this.searchBox.getValue())) {
                this.refreshSearchResults();
            }
            this.setFocused((GuiEventListener)this.searchBox);
            return true;
        }
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 2) {
            return false;
        }
        if (this.isMouseOver(this.thumbnailsArea, mouseX, mouseY)) {
            for (Thumbnail thumbnail : this.thumbnails) {
                if (!thumbnail.isMouseOver(mouseX, mouseY)) continue;
                if (Screen.hasControlDown() || button == 1) {
                    if (Screen.hasShiftDown()) {
                        int start = Math.min(thumbnail.index(), this.selection.getLastSelectedIndex());
                        int end = Math.max(thumbnail.index(), this.selection.getLastSelectedIndex());
                        for (int i = start; i <= end; ++i) {
                            if (this.selection.get().contains(i)) continue;
                            this.selection.select(i);
                        }
                    } else if (this.selection.get().contains(thumbnail.index())) {
                        this.selection.remove(thumbnail.index());
                    } else {
                        this.selection.select(thumbnail.index());
                    }
                    this.updateElements();
                } else {
                    this.openPhotographView(thumbnail.index());
                }
                return true;
            }
            if (!this.selection.isEmpty()) {
                this.selection.clear();
                this.updateThumbnailsGrid();
                return true;
            }
        }
        if (this.canScroll()) {
            if (this.isMouseOver(this.scrollThumb, mouseX, mouseY)) {
                this.setDragging(true);
                this.isDraggingScrollbar = true;
                this.dragDelta = 0.0;
                this.topRowIndexAtDragStart = this.topRowIndex;
                return true;
            }
            if (this.isMouseOver(this.scrollBarArea, mouseX, mouseY)) {
                int direction = mouseY < (double)this.scrollThumb.getY() ? -1 : 1;
                this.scroll(4 * direction);
                return true;
            }
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isDraggingScrollbar || button != 0) {
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        this.dragDelta += dragY;
        double threshold = (double)this.scrollBarArea.getHeight() / (double)Math.max(this.totalRows, 1);
        int rows = (int)(this.dragDelta / threshold);
        if (rows != 0 || this.topRowIndex != this.topRowIndexAtDragStart) {
            this.scrollTo(this.topRowIndexAtDragStart + rows);
        }
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        this.scroll((int)(-scrollY));
        return true;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && (this.searchBox.isFocused() || this.isThumbnailsGridFocused)) {
            this.setFocused(null);
            this.isThumbnailsGridFocused = false;
            return true;
        }
        if (this.isThumbnailsGridFocused && keyCode == 257) {
            this.openPhotographView(this.thumbnails.get(this.focusedThumbnailIndex).index());
            return true;
        }
        if (this.searchBox.canConsumeInput() && keyCode != 258) {
            String string = this.searchBox.getValue();
            if (this.searchBox.keyPressed(keyCode, scanCode, modifiers)) {
                if (!string.equals(this.searchBox.getValue())) {
                    this.refreshSearchResults();
                }
                return true;
            }
            if (keyCode != 256) {
                return true;
            }
        }
        if (this.tabKeyPressed(keyCode)) {
            return true;
        }
        if (this.arrowKeysPressed(keyCode)) {
            return true;
        }
        if (keyCode == 268) {
            this.selection.clear();
            this.selection.select(0);
            this.focusedThumbnailIndex = 0;
            this.scroll(Integer.MIN_VALUE);
            return true;
        }
        if (keyCode == 269) {
            this.selection.clear();
            this.selection.select(this.filteredItems.size() - 1);
            this.focusedThumbnailIndex = this.filteredItems.size() - 1;
            this.scroll(Integer.MAX_VALUE);
            return true;
        }
        if (keyCode == 261) {
            this.deleteExposures();
            return true;
        }
        if (Screen.hasControlDown()) {
            if (keyCode == 70) {
                this.setFocused((GuiEventListener)this.searchBox);
                return true;
            }
            if (keyCode == 77) {
                this.changeMode(Mode.values()[(this.mode.ordinal() + 1) % Mode.values().length]);
                this.playClickSound();
                return true;
            }
            if (keyCode == 82) {
                if (this.canRefresh()) {
                    this.refresh();
                    this.playClickSound();
                }
                return true;
            }
            if (keyCode == 69) {
                if (ExportExposuresTask.isRunning()) {
                    ExportExposuresTask.stopCurrentTask();
                } else {
                    this.exportExposures();
                }
                this.playClickSound();
                return true;
            }
            if (keyCode == 65) {
                this.selection.clear();
                this.selection.select(IntStream.range(0, this.filteredItems.size()).boxed().toList());
                this.updateElements();
                this.playClickSound();
                return true;
            }
            if (keyCode == 68) {
                if (!this.selection.isEmpty()) {
                    this.selection.clear();
                    this.updateElements();
                    this.playClickSound();
                }
                return true;
            }
        }
        if (Minecraft.getInstance().options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private boolean tabKeyPressed(int keyCode) {
        if (keyCode != 258) {
            return false;
        }
        if (!this.filteredItems.isEmpty() && !Screen.hasShiftDown() && this.getFocused() == this.modeButton) {
            this.setFocused(null);
            this.isThumbnailsGridFocused = true;
            this.focusedThumbnailIndex = 0;
            this.selection.clear();
            this.selection.select(this.focusedThumbnailIndex + this.topRowIndex * 6);
            this.updateElements();
            return true;
        }
        if (!this.filteredItems.isEmpty() && Screen.hasShiftDown() && this.getFocused() == this.refreshButton && !this.isThumbnailsGridFocused) {
            this.setFocused(null);
            this.isThumbnailsGridFocused = true;
            this.focusedThumbnailIndex = 0;
            this.selection.clear();
            this.selection.select(this.focusedThumbnailIndex + this.topRowIndex * 6);
            this.updateElements();
            return true;
        }
        if (this.isThumbnailsGridFocused) {
            Button newFocusTarget = Screen.hasShiftDown() ? this.modeButton : this.refreshButton;
            this.setFocused((GuiEventListener)newFocusTarget);
            this.isThumbnailsGridFocused = false;
            if (this.selection.size() == 1 && this.selection.get().iterator().next() == this.focusedThumbnailIndex + this.topRowIndex * 6) {
                this.selection.clear();
                this.updateElements();
            }
            return true;
        }
        return false;
    }

    private boolean arrowKeysPressed(int keyCode) {
        if (this.filteredItems.isEmpty() || !List.of(Integer.valueOf(263), Integer.valueOf(262), Integer.valueOf(265), Integer.valueOf(264)).contains(keyCode)) {
            return false;
        }
        if (!this.isThumbnailsGridFocused) {
            this.setFocused(null);
            this.isThumbnailsGridFocused = true;
            this.focusedThumbnailIndex = 0;
            this.selection.select(this.focusedThumbnailIndex + this.topRowIndex * 6);
            this.updateElements();
            return true;
        }
        Map<Integer, Integer> keys = Map.of(263, -1, 262, 1, 265, -6, 264, 6);
        int change = keys.get(keyCode);
        int oldIndex = this.focusedThumbnailIndex;
        int newIndex = this.focusedThumbnailIndex + change;
        if (newIndex < 0) {
            if (this.topRowIndex <= 0) {
                return true;
            }
            this.scroll(-1);
            newIndex += 6;
        } else if (newIndex > 23) {
            if (this.topRowIndex >= this.totalRows - 4) {
                return true;
            }
            this.scroll(1);
            newIndex -= 6;
        }
        this.focusedThumbnailIndex = Mth.clamp((int)newIndex, (int)0, (int)(this.thumbnails.size() - 1));
        if (!Screen.hasShiftDown()) {
            this.selection.clear();
        } else {
            int lesser = Math.min(oldIndex, newIndex);
            int larger = Math.max(oldIndex, newIndex);
            for (int i = lesser; i <= larger; ++i) {
                this.selection.select(i + this.topRowIndex * 6);
            }
        }
        this.selection.select(this.focusedThumbnailIndex + this.topRowIndex * 6);
        this.updateElements();
        return true;
    }

    protected void updateElements() {
        this.totalRows = (int)Math.ceil((float)this.filteredItems.size() / 6.0f);
        this.updateScrollThumb();
        this.updateButtons();
        this.updateThumbnailsGrid();
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.searchBox.canConsumeInput()) {
            String string = this.searchBox.getValue();
            if (this.searchBox.charTyped(codePoint, modifiers)) {
                if (!string.equals(this.searchBox.getValue())) {
                    this.refreshSearchResults();
                }
                return true;
            }
        }
        return false;
    }

    public boolean canScroll() {
        return this.totalRows > 4;
    }

    public void scroll(int rows) {
        this.scrollTo(this.topRowIndex + rows);
    }

    public void scrollTo(int row) {
        int maxRowWhenAtEnd = Math.max(0, (int)Math.ceil((float)(this.filteredItems.size() - 24) / 6.0f));
        this.topRowIndex = Mth.clamp((int)row, (int)0, (int)maxRowWhenAtEnd);
        this.updateScrollThumb();
        this.updateThumbnailsGrid();
        this.lastScrolledTime = Util.getMillis();
    }

    protected void updateScrollThumb() {
        int minSize = 9;
        float ratio = 4.0f / (float)Math.max(this.totalRows, 1);
        int size = Mth.clamp((int)Mth.ceil((float)((float)this.scrollBarArea.getHeight() * ratio)), (int)minSize, (int)this.scrollBarArea.getHeight());
        int midSize = size - 3 - 2;
        int correctedMidSize = Math.max(midSize - midSize % 4, 4);
        size = 3 + correctedMidSize + 2;
        float topRowPos = (float)this.topRowIndex / (float)Math.max(1, this.totalRows - 4);
        int pos = (int)Mth.map((float)topRowPos, (float)0.0f, (float)1.0f, (float)0.0f, (float)(this.scrollBarArea.getHeight() - size));
        this.scrollThumb = new Rect2i(this.scrollBarArea.getX(), this.scrollBarArea.getY() + pos, this.scrollBarArea.getWidth(), size);
    }

    protected void openPhotographView(int clickedIndex) {
        ArrayList<String> items = !this.selection.isEmpty() ? this.selection.get().stream().map(i -> this.filteredItems.get((int)i)).toList() : this.filteredItems;
        ArrayList<ItemAndStack> photographs = new ArrayList<ItemAndStack>(items.stream().map(item -> {
            ItemStack stack = new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get());
            ExposureIdentifier identifier = this.mode == Mode.EXPOSURES ? ExposureIdentifier.id((String)item) : ExposureIdentifier.texture((ResourceLocation)ResourceLocation.parse((String)item));
            Frame frame = Frame.create().setIdentifier(identifier).toImmutable();
            stack.set(Exposure.DataComponents.PHOTOGRAPH_FRAME, (Object)frame);
            return new ItemAndStack(stack);
        }).toList());
        String clickedId = this.filteredItems.get(clickedIndex);
        int clickedIdIndex = Math.max(0, items.indexOf(clickedId));
        Collections.rotate(photographs, -clickedIdIndex);
        ChildPhotographScreen screen = new ChildPhotographScreen((Screen)this, photographs);
        Minecraft.getInstance().setScreen((Screen)screen);
        Minecrft.get().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get()), (float)(Minecrft.level().getRandom().nextFloat() * 0.2f + 1.3f), (float)0.75f));
    }

    public void onClose() {
        this.saveState();
        CatalogClient.clear();
        ExposureClient.exposureStore().clear();
        Packets.sendToServer(CatalogClosedC2SP.INSTANCE);
        super.onClose();
    }

    protected void saveState() {
        JsonObject obj = new JsonObject();
        obj.addProperty("mode", this.mode.getSerializedName());
        obj.addProperty("order", this.order.getSerializedName());
        obj.addProperty("sorting", this.sorting.getSerializedName());
        obj.addProperty("export_size", this.exportSize.getSerializedName());
        obj.addProperty("export_look", this.exportLook.getSerializedName());
        try (FileWriter writer = new FileWriter(this.stateFile);){
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)obj, (Appendable)writer);
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Cannot save catalog state: " + String.valueOf(e));
        }
    }

    protected void loadState() {
        try {
            if (!Files.exists(this.stateFile.toPath(), new LinkOption[0]) || Files.size(this.stateFile.toPath()) == 0L) {
                return;
            }
            try (FileReader reader = new FileReader(this.stateFile);){
                JsonObject obj = GsonHelper.parse((Reader)reader);
                this.mode = Mode.fromSerializedString(obj.get("mode").getAsString());
                this.order = Order.fromSerializedString(obj.get("order").getAsString());
                this.sorting = Sorting.fromSerializedString(obj.get("sorting").getAsString());
                this.exportSize = ExportSize.byName((String)obj.get("export_size").getAsString());
                this.exportLook = ExportLook.byName((String)obj.get("export_look").getAsString());
            }
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Cannot load catalog state: {}", (Object)e.toString());
        }
    }
}

