/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.registrate;

import com.oierbravo.create_mechanical_spawner.ModConstants;
import com.oierbravo.create_mechanical_spawner.content.components.recipe.SpawnerRecipe;
import com.oierbravo.create_mechanical_spawner.content.components.recipe.SpawnerRecipeSerializer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModRecipes {
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)"create_mechanical_spawner");
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"create_mechanical_spawner");
    public static final Supplier<SpawnerRecipeSerializer> SPAWNER_SERIALIZER = SERIALIZERS.register("spawner", () -> SpawnerRecipeSerializer.INSTANCE);
    public static final Supplier<RecipeType<SpawnerRecipe>> SPAWNER_TYPE = RECIPE_TYPES.register("spawner", () -> RecipeType.simple((ResourceLocation)ModConstants.asResource("spawner")));

    public static void register(IEventBus eventBus) {
        SERIALIZERS.register(eventBus);
        RECIPE_TYPES.register(eventBus);
    }

    public static Optional<SpawnerRecipe> findSpawner(FluidStack fluidStack, Level level) {
        if (level == null || level.isClientSide()) {
            return Optional.empty();
        }
        return level.getRecipeManager().getAllRecipesFor((RecipeType)SpawnerRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).filter(recipe -> recipe.matches(fluidStack)).findAny();
    }

    public static List<RecipeHolder<SpawnerRecipe>> getAllHolders() {
        return Objects.requireNonNull(Minecraft.getInstance().getConnection()).getRecipeManager().getAllRecipesFor((RecipeType)SpawnerRecipe.Type.INSTANCE);
    }
}

