/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.content.components.collector;

import com.oierbravo.create_mechanical_spawner.ModLang;
import com.oierbravo.create_mechanical_spawner.infrastructure.config.MConfigs;
import com.oierbravo.create_mechanical_spawner.registrate.ModBlockEntities;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.ItemStackHandler;

public class LootCollectorBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private final ItemStackHandler inventory = this.createInventory();
    private FilteringBehaviour filtering;
    private int lootingLevel;

    public LootCollectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new FilterPositioning()).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.LOOT_COLLECTOR.get(), (be, context) -> be.getInventory());
    }

    protected ItemStackHandler createInventory() {
        return new ItemStackHandler((Integer)MConfigs.server().spawner.lootCollectorCapacity.get()){

            protected void onContentsChanged(int slot) {
                LootCollectorBlockEntity.this.setChanged();
                assert (LootCollectorBlockEntity.this.level != null);
                LootCollectorBlockEntity.this.level.sendBlockUpdated(LootCollectorBlockEntity.this.worldPosition, LootCollectorBlockEntity.this.getBlockState(), LootCollectorBlockEntity.this.getBlockState(), 3);
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return LootCollectorBlockEntity.this.filtering.test(stack);
            }
        };
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        compound.putInt("LootingLevel", this.lootingLevel);
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        this.lootingLevel = compound.getInt("LootingLevel");
        super.read(compound, registries, clientPacket);
    }

    public int getLootingLevel() {
        return this.lootingLevel;
    }

    public void setLootingLevel(int lootingLevel) {
        this.lootingLevel = lootingLevel;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.lootingLevel > 0) {
            ModLang.translate("goggles.with_loot_enchantment", this.lootingLevel).forGoggles(tooltip);
            return true;
        }
        return false;
    }

    public static class FilterPositioning
    extends ValueBoxTransform.Sided {
        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction == Direction.UP;
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)15.0);
        }
    }
}

