/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.compat.jei;

import com.oierbravo.create_mechanical_spawner.ModConstants;
import com.oierbravo.create_mechanical_spawner.ModLang;
import com.oierbravo.create_mechanical_spawner.compat.jei.RenderHelper;
import com.oierbravo.create_mechanical_spawner.compat.jei.animations.AnimatedSpawner;
import com.oierbravo.create_mechanical_spawner.content.components.recipe.SpawnerRecipe;
import com.oierbravo.create_mechanical_spawner.infrastructure.config.MConfigs;
import com.oierbravo.create_mechanical_spawner.registrate.ModBlocks;
import com.oierbravo.create_mechanical_spawner.registrate.ModRecipes;
import com.oierbravo.mechanicals.compat.jei.RecipeRequirementRenderer;
import com.oierbravo.mechanicals.foundation.gui.MechanicalGUITextures;
import com.oierbravo.mechanicals.foundation.recipe.IRecipeWithRequirements;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class SpawnerCategory
extends CreateRecipeCategory<SpawnerRecipe> {
    private final AnimatedSpawner spawner = new AnimatedSpawner();
    public static final ResourceLocation UID = ModConstants.asResource("spawner");
    public static final RecipeType<SpawnerRecipe> TYPE = new RecipeType(UID, SpawnerRecipe.class);
    public static final CreateRecipeCategory.Info<SpawnerRecipe> INFO = new CreateRecipeCategory.Info(TYPE, (Component)ModLang.translate("recipe.spawner", new Object[0]).component(), (IDrawable)new EmptyBackground(177, 100), (IDrawable)new ItemIcon(() -> new ItemStack((ItemLike)ModBlocks.MECHANICAL_SPAWNER.asItem())), ModRecipes::getAllHolders, List.of(() -> ModBlocks.MECHANICAL_SPAWNER.asStack()));

    public SpawnerCategory(CreateRecipeCategory.Info<SpawnerRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpawnerRecipe recipe, IFocusGroup focuses) {
        boolean useCustomLoot;
        FluidIngredient fluidIngredient = recipe.getFluidIngredient();
        List<ItemStack> invisibleIngredientsBuckets = fluidIngredient.getMatchingFluidStacks().stream().map(fluidStack -> new ItemStack((ItemLike)fluidStack.getFluid().getBucket())).toList();
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(invisibleIngredientsBuckets);
        ResourceKey<EntityType<?>> mobKey = recipe.getMob();
        boolean bl = useCustomLoot = !recipe.getCustomLoot().isEmpty() && (Boolean)MConfigs.server().spawner.customLootPerSpawnRecipeEnabled.get() != false;
        if (mobKey != null && !useCustomLoot) {
            ClientLevel level = Minecraft.getInstance().level;
            EntityType entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(mobKey);
            ItemStack egg = entity.create((Level)level).getPickResult();
            builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(egg);
        }
        if (useCustomLoot) {
            NonNullList<ProcessingOutput> customLoot = recipe.getCustomLoot();
            boolean single = customLoot.size() == 1;
            int i = 0;
            for (ProcessingOutput output : customLoot) {
                int xOffset = i % 9 == 0 ? 0 : 19;
                int yOffset = 0;
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 2 + xOffset * i, 75 + yOffset).setBackground(SpawnerCategory.getRenderedSlot((ProcessingOutput)output), -1, -1).addItemStack(output.getStack())).addRichTooltipCallback(SpawnerCategory.addStochasticTooltip((ProcessingOutput)output));
                ++i;
            }
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 2, 2).setBackground(SpawnerCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, fluidIngredient.getMatchingFluidStacks())).addRichTooltipCallback(SpawnerCategory::addFluidAmountTooltip);
    }

    private static void addFluidAmountTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
        Optional displayed = recipeSlotView.getDisplayedIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK);
        if (displayed.isEmpty()) {
            return;
        }
        FluidStack fluidStack = (FluidStack)displayed.get();
        tooltip.add((FormattedText)Component.literal((String)(fluidStack.getAmount() + "mB")));
    }

    public void draw(SpawnerRecipe recipe, @NotNull IRecipeSlotsView iRecipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        boolean useCustomLoot;
        Font font = Minecraft.getInstance().font;
        MechanicalGUITextures.JEI_DOWN_RIGHT_ARROW.render(guiGraphics, 6, 25);
        this.spawner.draw(guiGraphics, 30, 30);
        ClientLevel level = Minecraft.getInstance().level;
        ResourceKey<EntityType<?>> mobKey = recipe.getMob();
        boolean bl = useCustomLoot = !recipe.getCustomLoot().isEmpty() && (Boolean)MConfigs.server().spawner.customLootPerSpawnRecipeEnabled.get() != false;
        if (mobKey == null) {
            String text = ModLang.translate("generic.biome_dependant", new Object[0]).string();
            guiGraphics.drawString(font, text, 20, 57, 8, false);
        } else {
            EntityType entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(mobKey);
            assert (level != null);
            LivingEntity mobEntity = (LivingEntity)entity.create((Level)level);
            assert (mobEntity != null);
            String id = mobEntity.getEncodeId();
            assert (id != null);
            RenderHelper.renderEntity(guiGraphics, 70, 50, 20.0, 38.0 - mouseX, 80.0 - mouseY, mobEntity);
            Component displayName = mobEntity.getDisplayName();
            guiGraphics.drawString(font, displayName, 20, 57, 8, false);
            if (useCustomLoot) {
                String customLoottext = ModLang.translate("generic.with_custom_loot", new Object[0]).string();
                guiGraphics.drawString(font, customLoottext, 20, 65, 8, false);
            }
        }
        RecipeRequirementRenderer.drawRequirements((IRecipeWithRequirements)recipe, (GuiGraphics)guiGraphics, (int)85, (int)10);
    }
}

