/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_chicken.content.components;

import com.oierbravo.create_mechanical_chicken.CreateMechanicalChicken;
import com.oierbravo.create_mechanical_chicken.ModLang;
import com.oierbravo.create_mechanical_chicken.ModRegistration;
import com.oierbravo.create_mechanical_chicken.content.components.MechanicalChickenBlock;
import com.oierbravo.create_mechanical_chicken.infrastructure.config.MConfigs;
import com.oierbravo.mechanicals.compat.jade.IHavePercent;
import com.oierbravo.mechanicals.foundation.blockEntity.behaviour.DynamicCycleBehavior;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MechanicalChickenBlockEntity
extends KineticBlockEntity
implements DynamicCycleBehavior.DynamicCycleBehaviorSpecifics,
IHavePercent {
    private DynamicCycleBehavior cycleBehaviour;
    public SmartFluidTankBehaviour inputTank;
    private boolean contentsChanged;
    private FluidIngredient requiredFluidIngredient;
    public final ItemStackHandler outputInventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            MechanicalChickenBlockEntity.this.setChanged();
            MechanicalChickenBlockEntity.this.level.sendBlockUpdated(MechanicalChickenBlockEntity.this.worldPosition, MechanicalChickenBlockEntity.this.getBlockState(), MechanicalChickenBlockEntity.this.getBlockState(), 3);
        }
    };
    private final Lazy<IItemHandler> itemCapability = Lazy.of(() -> this.outputInventory);

    public MechanicalChickenBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.verifyConfig(CreateMechanicalChicken.LOGGER);
        this.inputTank.getPrimaryHandler().setValidator((Predicate)this.requiredFluidIngredient);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.inputTank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)((Integer)MConfigs.server().mechanicalChicken.fluidCapacity.get()));
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        this.cycleBehaviour = new DynamicCycleBehavior((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.cycleBehaviour);
    }

    public void remove() {
        super.remove();
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModRegistration.MECHANICAL_CHICKEN_BLOCK_ENTITY.get(), (be, context) -> {
            Direction localDir = (Direction)be.getBlockState().getValue(MechanicalChickenBlock.HORIZONTAL_FACING);
            if (context != null && localDir == context.getOpposite()) {
                return be.getItemHandler();
            }
            if (context == null) {
                return be.getItemHandler();
            }
            return null;
        });
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModRegistration.MECHANICAL_CHICKEN_BLOCK_ENTITY.get(), (be, context) -> {
            Direction localDir = (Direction)be.getBlockState().getValue(MechanicalChickenBlock.HORIZONTAL_FACING);
            if (context != null && localDir == context) {
                return be.inputTank.getCapability();
            }
            if (context == null) {
                return be.inputTank.getCapability();
            }
            return null;
        });
    }

    @Nullable
    private IItemHandler getItemHandler() {
        return this.outputInventory;
    }

    public DynamicCycleBehavior getCycleBehaviour() {
        return this.cycleBehaviour;
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.put("OutputInventory", (Tag)this.outputInventory.serializeNBT(registries));
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.outputInventory.deserializeNBT(registries, compound.getCompound("OutputInventory"));
        super.read(compound, registries, clientPacket);
    }

    public float getKineticSpeed() {
        return this.getSpeed();
    }

    public boolean tryProcess(boolean simulate) {
        if (this.inputTank.getPrimaryHandler().isEmpty()) {
            return false;
        }
        if (this.inputTank.getPrimaryHandler().getFluidAmount() < (Integer)MConfigs.server().mechanicalChicken.requiredFluidAmount.get()) {
            return false;
        }
        if (ItemStack.EMPTY != this.outputInventory.insertItem(0, new ItemStack((ItemLike)Items.EGG, ((Integer)MConfigs.server().mechanicalChicken.outputAmount.get()).intValue()), true)) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.inputTank.getPrimaryHandler().drain(((Integer)MConfigs.server().mechanicalChicken.requiredFluidAmount.get()).intValue(), IFluidHandler.FluidAction.EXECUTE);
        this.outputInventory.insertItem(0, new ItemStack((ItemLike)Items.EGG, ((Integer)MConfigs.server().mechanicalChicken.outputAmount.get()).intValue()), false);
        return true;
    }

    public int getProcessingTime() {
        return (Integer)MConfigs.server().mechanicalChicken.processingTime.get();
    }

    public void playCompletionSound() {
        this.level.playSound((Entity)null, this.worldPosition, SoundEvents.CHICKEN_EGG, SoundSource.BLOCKS, ((Double)MConfigs.server().mechanicalChicken.soundVolume.get()).floatValue(), 1.0f);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.cycleBehaviour.isRunning()) {
            ModLang.translate("chicken.tooltip.progress", this.getProgressPercent()).style(ChatFormatting.YELLOW).forGoggles(tooltip);
            added = true;
        }
        return added;
    }

    public int getProgressPercent() {
        return this.cycleBehaviour.getProgressPercent();
    }

    public FluidIngredient getFluidIngredient() {
        int amount = (Integer)MConfigs.server().mechanicalChicken.requiredFluidAmount.get();
        String name = (String)MConfigs.server().mechanicalChicken.requiredFluid.get();
        if (name.startsWith("#")) {
            return FluidIngredient.fromTag((TagKey)FluidTags.create((ResourceLocation)ResourceLocation.parse((String)name.replace("#", ""))), (int)amount);
        }
        return FluidIngredient.fromFluid((Fluid)this.getRequiredFluid(), (int)amount);
    }

    public Fluid getRequiredFluid() {
        return (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)((String)MConfigs.server().mechanicalChicken.requiredFluid.get())));
    }

    public FluidStack getRequiredFluidStack() {
        Fluid requiredFluid = this.getRequiredFluid();
        if (requiredFluid == null) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(requiredFluid, ((Integer)MConfigs.server().mechanicalChicken.requiredFluidAmount.get()).intValue());
    }

    public void verifyConfig(Logger logger) {
        if (this.requiredFluidIngredient == null) {
            String fluidResourceRaw = (String)MConfigs.server().mechanicalChicken.requiredFluid.get();
            int configuredAmount = (Integer)MConfigs.server().mechanicalChicken.requiredFluidAmount.get();
            if (fluidResourceRaw.startsWith("#")) {
                ResourceLocation fluidTag = ResourceLocation.tryParse((String)fluidResourceRaw.replace("#", ""));
                assert (fluidTag != null);
                this.requiredFluidIngredient = FluidIngredient.fromTag((TagKey)FluidTags.create((ResourceLocation)fluidTag), (int)configuredAmount);
                return;
            }
            ResourceLocation desiredFluid = ResourceLocation.parse((String)fluidResourceRaw);
            if (BuiltInRegistries.FLUID.containsKey(desiredFluid)) {
                this.requiredFluidIngredient = FluidIngredient.fromFluid((Fluid)((Fluid)BuiltInRegistries.FLUID.get(desiredFluid)), (int)configuredAmount);
            } else {
                logger.error("Unknown fluid '{}' in config, using default '{}' instead", (Object)fluidResourceRaw, (Object)"minecraft:water");
                this.requiredFluidIngredient = FluidIngredient.fromFluid((Fluid)Fluids.WATER, (int)configuredAmount);
            }
        }
    }
}

