/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.neoforge;

import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import nx.pingwheel.common.ClientGlobal;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.commands.ClientCommandBuilder;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.config.ConfigHandler;
import nx.pingwheel.common.core.ClientCore;
import nx.pingwheel.common.helper.LanguageUtils;
import nx.pingwheel.common.networking.UpdateChannelC2SPacket;
import nx.pingwheel.common.resource.ResourceReloadListener;
import nx.pingwheel.common.screen.SettingsScreen;

@OnlyIn(value=Dist.CLIENT)
public class Client {
    public Client(IEventBus modBus) {
        ClientGlobal.ConfigHandler = new ConfigHandler<ClientConfig>(ClientConfig.class, FMLPaths.CONFIGDIR.get().resolve("ping-wheel.json"));
        ClientGlobal.ConfigHandler.load();
        NeoForge.EVENT_BUS.register((Object)this);
        modBus.addListener(this::onRegisterReloadListeners);
        modBus.addListener(this::onRegisterKeyBindings);
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (a, parent) -> new SettingsScreen(parent));
    }

    private void onRegisterReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new ResourceReloadListener());
    }

    private void onRegisterKeyBindings(RegisterKeyMappingsEvent event) {
        event.register(ClientGlobal.KEY_BINDING_PING);
        event.register(ClientGlobal.KEY_BINDING_SETTINGS);
        event.register(ClientGlobal.KEY_BINDING_NAME_LABELS);
    }

    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Pre event) {
        ClientCore.onTick();
    }

    @SubscribeEvent
    public void onClientConnectedToServer(ClientPlayerNetworkEvent.LoggingIn event) {
        Global.NetHandler.sendToServer(new UpdateChannelC2SPacket(ClientGlobal.ConfigHandler.getConfig().getChannel()));
    }

    @SubscribeEvent
    public void onClientDisconnectedFromServer(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientCore.onDisconnect();
    }

    @SubscribeEvent
    public void onRegisterClientCommands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register(ClientCommandBuilder.build((context, success, response) -> {
            if (success.booleanValue()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> LanguageUtils.withModPrefix(response), false);
            } else {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)LanguageUtils.withModPrefix(response));
            }
        }));
    }
}

