/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.helper;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import nx.pingwheel.common.ClientGlobal;

public class Raycast {
    private Raycast() {
    }

    public static HitResult traceDirectional(Vec3 direction, float tickDelta, double maxDistance, boolean hitFluids) {
        Entity cameraEntity = ClientGlobal.Game.cameraEntity;
        if (cameraEntity == null || cameraEntity.level() == null) {
            return null;
        }
        Vec3 rayStartVec = cameraEntity.getEyePosition(tickDelta);
        Vec3 rayEndVec = rayStartVec.add(direction.scale(maxDistance));
        AABB boundingBox = cameraEntity.getBoundingBox().expandTowards(cameraEntity.getViewVector(1.0f).scale(maxDistance)).inflate(1.0, 1.0, 1.0);
        BlockHitResult blockHitResult = cameraEntity.level().clip(new ClipContext(rayStartVec, rayEndVec, ClipContext.Block.OUTLINE, hitFluids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, cameraEntity));
        EntityHitResult entityHitResult = Raycast.traceEntity(cameraEntity, rayStartVec, rayEndVec, boundingBox, targetEntity -> !targetEntity.isSpectator());
        if (entityHitResult == null) {
            return blockHitResult;
        }
        if (rayStartVec.distanceToSqr(blockHitResult.getLocation()) < rayStartVec.distanceToSqr(entityHitResult.getLocation())) {
            return blockHitResult;
        }
        return entityHitResult;
    }

    private static EntityHitResult traceEntity(Entity entity, Vec3 min, Vec3 max, AABB box, Predicate<Entity> predicate) {
        double minDist = min.distanceToSqr(max);
        EntityHitResult minHitResult = null;
        for (Entity ent : entity.level().getEntities(entity, box, predicate)) {
            EntityHitResult hitResult;
            double hitDist;
            AABB targetBoundingBox = ent.getBoundingBox().inflate((double)ent.getPickRadius()).inflate(0.25);
            Optional hitPos = targetBoundingBox.clip(min, max);
            if (hitPos.isEmpty() || !(minDist > (hitDist = min.distanceToSqr((hitResult = new EntityHitResult(ent, (Vec3)hitPos.get())).getLocation())))) continue;
            minDist = hitDist;
            minHitResult = hitResult;
        }
        return minHitResult;
    }
}

