/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import nx.pingwheel.common.ClientGlobal;
import nx.pingwheel.common.helper.MathUtils;
import nx.pingwheel.common.resource.ResourceReloadListener;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class DrawContext {
    private static final int WHITE = FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);
    private static final int SHADOW_BLACK = FastColor.ARGB32.color((int)64, (int)0, (int)0, (int)0);
    private GuiGraphics guiGraphics;
    private PoseStack matrices;

    public DrawContext(GuiGraphics guiGraphics) {
        this.guiGraphics = guiGraphics;
        this.matrices = guiGraphics.pose();
    }

    public void renderLabel(Component text, float yOffset, PlayerInfo player) {
        int extraWidth = player != null ? 10 : 0;
        float f = ClientGlobal.Game.font.width((FormattedText)text) + extraWidth;
        Objects.requireNonNull(ClientGlobal.Game.font);
        Vec2 textMetrics = new Vec2(f, 9.0f);
        Vec2 textOffset = textMetrics.scale(-0.5f).add(new Vec2(0.0f, textMetrics.y * yOffset));
        this.matrices.pushPose();
        this.matrices.translate(textOffset.x, textOffset.y, 0.0f);
        this.guiGraphics.fill(-2, -2, (int)textMetrics.x + 1, (int)textMetrics.y, SHADOW_BLACK);
        this.guiGraphics.drawString(ClientGlobal.Game.font, text, extraWidth, 0, WHITE, false);
        if (player != null) {
            this.matrices.translate(-0.5, -0.5, 0.0);
            this.renderPlayerHead(player);
        }
        this.matrices.popPose();
    }

    public void renderPlayerHead(PlayerInfo player) {
        ResourceLocation texture = player.getSkin().texture();
        RenderSystem.enableBlend();
        this.guiGraphics.blit(texture, 0, 0, 0, 8.0f, 8.0f, 8, 8, 64, 64);
        this.guiGraphics.blit(texture, 0, 0, 0, 40.0f, 8.0f, 8, 8, 64, 64);
        RenderSystem.disableBlend();
    }

    public void renderPing(ItemStack itemStack, boolean drawItemIcon) {
        if (itemStack != null && drawItemIcon) {
            this.renderGuiItemModel(itemStack);
        } else if (ResourceReloadListener.hasCustomTexture()) {
            this.renderCustomPingIcon();
        } else {
            this.renderDefaultPingIcon();
        }
    }

    public void renderGuiItemModel(ItemStack itemStack) {
        this.guiGraphics.renderItem(itemStack, -8, -8, 0, -150);
    }

    public void renderCustomPingIcon() {
        int size = 12;
        int offset = -6;
        RenderSystem.enableBlend();
        this.guiGraphics.blit(ClientGlobal.PING_TEXTURE_ID, -6, -6, 0, 0.0f, 0.0f, 12, 12, 12, 12);
        RenderSystem.disableBlend();
    }

    public void renderDefaultPingIcon() {
        this.matrices.pushPose();
        MathUtils.rotateZ(this.matrices, 0.7853982f);
        this.matrices.translate(-2.5, -2.5, 0.0);
        this.guiGraphics.fill(0, 0, 5, 5, WHITE);
        this.matrices.popPose();
    }

    public void renderArrow(boolean antialias) {
        if (antialias) {
            GL11.glEnable((int)2881);
        }
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f mat = this.matrices.last().pose();
        bufferBuilder.addVertex(mat, 5.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        bufferBuilder.addVertex(mat, -5.0f, -5.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        bufferBuilder.addVertex(mat, -3.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        bufferBuilder.addVertex(mat, -5.0f, 5.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
        GL11.glDisable((int)2881);
    }
}

