/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.core;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.config.ServerConfig;
import nx.pingwheel.common.helper.ChannelMode;
import nx.pingwheel.common.helper.RateLimiter;
import nx.pingwheel.common.networking.PingLocationC2SPacket;
import nx.pingwheel.common.networking.PingLocationS2CPacket;
import nx.pingwheel.common.networking.UpdateChannelC2SPacket;

public class ServerCore {
    private static final ServerConfig Config = Global.ServerConfigHandler.getConfig();
    private static final HashMap<UUID, String> playerChannels = new HashMap();
    private static final HashMap<UUID, RateLimiter> playerRates = new HashMap();

    private ServerCore() {
    }

    public static void init() {
        RateLimiter.setRates(Config.getMsToRegenerate(), Config.getRateLimit());
    }

    public static void onPlayerDisconnect(ServerPlayer player) {
        playerChannels.remove(player.getUUID());
        playerRates.remove(player.getUUID());
    }

    public static void onChannelUpdate(ServerPlayer player, UpdateChannelC2SPacket packet) {
        if (packet.isCorrupt()) {
            Global.LOGGER.warn(() -> "invalid channel update from %s (%s)".formatted(player.getGameProfile().getName(), player.getUUID()));
            player.displayClientMessage((Component)Component.literal((String)("\u00a78[Ping-Wheel] \u00a7cChannel couldn't be updated\n\u00a7fMake sure your version matches the server's version: \u00a7d" + Global.ModVersion)), false);
            return;
        }
        ServerCore.updatePlayerChannel(player, packet.channel());
    }

    public static void onPingLocation(MinecraftServer server, ServerPlayer player, PingLocationC2SPacket packet) {
        if (packet.isCorrupt()) {
            Global.LOGGER.warn(() -> "invalid ping location from %s (%s)".formatted(player.getGameProfile().getName(), player.getUUID()));
            player.displayClientMessage((Component)Component.literal((String)("\u00a78[Ping-Wheel] \u00a7cUnable to send ping\n\u00a7fMake sure your version matches the server's version: \u00a7d" + Global.ModVersion)), false);
            return;
        }
        RateLimiter rateLimiter = playerRates.get(player.getUUID());
        if (rateLimiter == null) {
            playerRates.put(player.getUUID(), new RateLimiter());
        } else if (Config.getRateLimit() > 0 && rateLimiter.checkAndBlock()) {
            return;
        }
        String channel = packet.channel();
        ChannelMode defaultChannelMode = Config.getDefaultChannelMode();
        if (channel.isEmpty() && defaultChannelMode == ChannelMode.DISABLED) {
            player.displayClientMessage((Component)Component.literal((String)"\u00a78[Ping-Wheel] \u00a7eMust be in a channel to ping location\n\u00a7fUse \u00a7a/pingwheel channel\u00a7f to switch"), false);
            return;
        }
        if (channel.isEmpty() && defaultChannelMode == ChannelMode.TEAM_ONLY && player.getTeam() == null) {
            player.displayClientMessage((Component)Component.literal((String)"\u00a78[Ping-Wheel] \u00a7eMust be in a team or channel to ping location\n\u00a7fUse \u00a7a/pingwheel channel\u00a7f to switch"), false);
            return;
        }
        if (!channel.equals(playerChannels.getOrDefault(player.getUUID(), ""))) {
            ServerCore.updatePlayerChannel(player, channel);
        }
        PlayerList playerList = server.getPlayerList();
        PingLocationS2CPacket packetOut = !Config.isPlayerTrackingEnabled() && ServerCore.targetEntityIsPlayer(packet, playerList) ? new PingLocationS2CPacket(packet.channel(), packet.pos(), null, packet.sequence(), packet.dimension(), player.getUUID()) : PingLocationS2CPacket.fromClientPacket(packet, player.getUUID());
        for (ServerPlayer p : playerList.getPlayers()) {
            if (!channel.equals(playerChannels.getOrDefault(p.getUUID(), "")) || defaultChannelMode != ChannelMode.GLOBAL && player.getTeam() != p.getTeam()) continue;
            Global.NetHandler.sendToClient(packetOut, p);
        }
    }

    private static boolean targetEntityIsPlayer(PingLocationC2SPacket packet, PlayerList playerList) {
        UUID playerUUID = packet.entity();
        if (playerUUID == null) {
            return false;
        }
        return playerList.getPlayer(playerUUID) != null;
    }

    private static void updatePlayerChannel(ServerPlayer player, String channel) {
        if (channel.isEmpty()) {
            playerChannels.remove(player.getUUID());
            Global.LOGGER.info(() -> "Channel update: %s -> default".formatted(player.getGameProfile().getName()));
        } else {
            playerChannels.put(player.getUUID(), channel);
            Global.LOGGER.info(() -> "Channel update: %s -> \"%s\"".formatted(player.getGameProfile().getName(), channel));
        }
    }
}

