/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.core;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import nx.pingwheel.common.ClientGlobal;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.helper.DrawContext;
import nx.pingwheel.common.helper.InputUtils;
import nx.pingwheel.common.helper.LanguageUtils;
import nx.pingwheel.common.helper.MathUtils;
import nx.pingwheel.common.helper.Ping;
import nx.pingwheel.common.helper.Raycast;
import nx.pingwheel.common.helper.ScreenPos;
import nx.pingwheel.common.networking.PingLocationC2SPacket;
import nx.pingwheel.common.networking.PingLocationS2CPacket;
import nx.pingwheel.common.screen.SettingsScreen;
import nx.pingwheel.common.sound.DirectionalSoundInstance;
import org.joml.Matrix4f;

public class ClientCore {
    private static final ClientConfig Config = ClientGlobal.ConfigHandler.getConfig();
    private static final ArrayList<Ping> pingRepo = new ArrayList();
    private static boolean pingQueued = false;
    private static ClientLevel lastWorld = null;
    private static int dimension = 0;
    private static int lastPing = 0;
    private static int pingSequence = 0;

    private ClientCore() {
    }

    public static void onDisconnect() {
        pingRepo.clear();
    }

    public static void onTick() {
        if (InputUtils.consumePingHotkey()) {
            pingQueued = true;
        }
        if (ClientGlobal.KEY_BINDING_SETTINGS.consumeClick()) {
            ClientGlobal.Game.setScreen((Screen)new SettingsScreen());
        }
    }

    public static void onPingLocation(PingLocationS2CPacket packet) {
        Vec3 vecToPing;
        if (packet.isCorrupt()) {
            Global.LOGGER.warn("received invalid ping location from server");
            return;
        }
        ClientPacketListener connection = ClientGlobal.Game.getConnection();
        if (ClientGlobal.Game.player == null || ClientGlobal.Game.level == null || connection == null) {
            return;
        }
        if (!packet.channel().equals(Config.getChannel())) {
            return;
        }
        if (Config.getPingDistance() < 2048 && (vecToPing = ClientGlobal.Game.player.position().vectorTo(packet.pos())).length() > (double)Config.getPingDistance()) {
            return;
        }
        PlayerInfo authorInfo = connection.getPlayerInfo(packet.author());
        ClientGlobal.Game.execute(() -> {
            ClientCore.addOrReplacePing(new Ping(packet.pos(), packet.entity(), authorInfo, packet.sequence(), packet.dimension(), (int)ClientGlobal.Game.level.getGameTime()));
            if (packet.dimension() == dimension) {
                ClientGlobal.Game.getSoundManager().play((SoundInstance)new DirectionalSoundInstance(ClientGlobal.PING_SOUND_EVENT, SoundSource.MASTER, (float)Config.getPingVolume() / 100.0f, 1.0f, packet.pos()));
            }
        });
    }

    public static void onRenderWorld(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float tickDelta) {
        if (ClientGlobal.Game.level == null) {
            return;
        }
        if (lastWorld != ClientGlobal.Game.level) {
            lastWorld = ClientGlobal.Game.level;
            dimension = lastWorld.dimension().location().hashCode();
        }
        int time = (int)ClientGlobal.Game.level.getGameTime();
        ClientCore.processPings(modelViewMatrix, projectionMatrix, tickDelta, time);
        if (pingQueued) {
            if (Config.getCorrectionPeriod() < 5.0f && (float)(time - lastPing) > Config.getCorrectionPeriod() * 20.0f) {
                ++pingSequence;
            }
            lastPing = time;
            pingQueued = false;
            ClientCore.executePing(tickDelta);
        }
    }

    public static void onRenderGUI(GuiGraphics gg, float tickDelta) {
        if (ClientGlobal.Game.player == null || pingRepo.isEmpty()) {
            return;
        }
        PoseStack m = gg.pose();
        DrawContext ctx = new DrawContext(gg);
        Window wnd = ClientGlobal.Game.getWindow();
        Vec2 screenSize = new Vec2((float)wnd.getGuiScaledWidth(), (float)wnd.getGuiScaledHeight());
        Vec2 safeZoneTopLeft = new Vec2((float)Config.getSafeZoneLeft(), (float)Config.getSafeZoneTop());
        Vec2 safeZoneBottomRight = new Vec2(screenSize.x - (float)Config.getSafeZoneRight(), screenSize.y - (float)Config.getSafeZoneBottom());
        Vec2 safeScreenCenter = new Vec2((safeZoneBottomRight.x - safeZoneTopLeft.x) * 0.5f, (safeZoneBottomRight.y - safeZoneTopLeft.y) * 0.5f);
        boolean showDirectionIndicator = Config.isDirectionIndicatorVisible();
        boolean showNameLabels = Config.isNameLabelForced() || ClientGlobal.KEY_BINDING_NAME_LABELS.isDown();
        m.pushPose();
        m.translate(0.0f, 0.0f, (float)(-pingRepo.size()) * 16.0f);
        for (Ping ping : pingRepo) {
            boolean isOffScreen;
            ScreenPos screenPos = ping.getScreenPos();
            if (screenPos == null || ping.getDimension() != dimension || screenPos.isBehindCamera() && !showDirectionIndicator) continue;
            m.translate(0.0f, 0.0f, 16.0f);
            float pingSize = (float)Config.getPingSize() / 100.0f;
            float pingScale = ClientCore.getDistanceScale(ping.getDistance()) * pingSize * 0.4f;
            Vec2 pingDirectionVec = new Vec2(screenPos.x - safeZoneTopLeft.x - safeScreenCenter.x, screenPos.y - safeZoneTopLeft.y - safeScreenCenter.y);
            boolean behindCamera = screenPos.isBehindCamera();
            if (behindCamera) {
                pingDirectionVec = pingDirectionVec.scale(-1.0f);
            }
            float pingAngle = (float)Math.atan2(pingDirectionVec.y, pingDirectionVec.x);
            boolean bl = isOffScreen = behindCamera || !screenPos.isInBounds(Vec2.ZERO, screenSize);
            if (isOffScreen && showDirectionIndicator) {
                Vec2 indicator = MathUtils.calculateAngleRectIntersection(pingAngle, safeZoneTopLeft, safeZoneBottomRight);
                m.pushPose();
                m.translate(indicator.x, indicator.y, 0.0f);
                m.pushPose();
                m.scale(pingScale, pingScale, 1.0f);
                double indicatorOffsetX = Math.cos((double)pingAngle + Math.PI) * 12.0;
                double indicatorOffsetY = Math.sin((double)pingAngle + Math.PI) * 12.0;
                m.translate(indicatorOffsetX, indicatorOffsetY, 0.0);
                ctx.renderPing(ping.getItemStack(), Config.isItemIconVisible());
                m.popPose();
                m.pushPose();
                MathUtils.rotateZ(m, pingAngle);
                m.scale(pingSize, pingSize, 1.0f);
                m.scale(0.25f, 0.25f, 1.0f);
                m.translate(-5.0f, 0.0f, 0.0f);
                ctx.renderArrow(true);
                m.scale(0.9f, 0.9f, 1.0f);
                ctx.renderArrow(false);
                m.popPose();
                m.popPose();
            }
            if (behindCamera) continue;
            m.pushPose();
            m.translate(screenPos.x, screenPos.y, 0.0f);
            m.scale(pingScale, pingScale, 1.0f);
            MutableComponent text = LanguageUtils.UNIT_METERS.get("%,.1f".formatted(ping.getDistance()));
            ctx.renderLabel((Component)text, -1.5f, null);
            ctx.renderPing(ping.getItemStack(), Config.isItemIconVisible());
            PlayerInfo author = ping.getAuthor();
            if (showNameLabels && author != null) {
                MutableComponent displayName = PlayerTeam.formatNameForTeam((Team)author.getTeam(), (Component)Component.literal((String)author.getProfile().getName()));
                ctx.renderLabel((Component)displayName, 1.75f, author);
            }
            m.popPose();
        }
        m.popPose();
    }

    private static void processPings(Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float tickDelta, int time) {
        if (ClientGlobal.Game.player == null || pingRepo.isEmpty()) {
            return;
        }
        Vec3 cameraPos = ClientGlobal.Game.player.getEyePosition(tickDelta);
        Ping target = null;
        Iterator<Ping> iter = pingRepo.iterator();
        while (iter.hasNext()) {
            Entity ent;
            Ping ping = iter.next();
            if (ping.getUuid() != null && (ent = ClientCore.getEntity(ping.getUuid())) != null) {
                if (ent.getType() == EntityType.ITEM && Config.isItemIconVisible()) {
                    ping.setItemStack(((ItemEntity)ent).getItem().copy());
                }
                ping.setPos(ent.getPosition(tickDelta).add(0.0, ent.getBoundingBox().getYsize(), 0.0));
            }
            ping.setDistance(cameraPos.distanceTo(ping.getPos()));
            ping.setScreenPos(MathUtils.worldToScreen(ping.getPos(), modelViewMatrix, projectionMatrix));
            ping.setAge(time - ping.getSpawnTime());
            if (ping.isExpired()) {
                iter.remove();
                continue;
            }
            if (!pingQueued || !ping.isRemovable() || !ping.isCloserToCenter(target)) continue;
            target = ping;
        }
        if (target != null && pingRepo.remove(target)) {
            pingQueued = false;
        }
        pingRepo.sort((a, b) -> Double.compare(b.getDistance(), a.getDistance()));
    }

    private static void executePing(float tickDelta) {
        Entity cameraEntity = ClientGlobal.Game.cameraEntity;
        if (cameraEntity == null || ClientGlobal.Game.level == null) {
            return;
        }
        Vec3 cameraDirection = cameraEntity.getViewVector(tickDelta);
        HitResult hitResult = Raycast.traceDirectional(cameraDirection, tickDelta, Math.min(Config.getRaycastDistance(), Config.getPingDistance()), cameraEntity.isCrouching());
        if (hitResult == null || hitResult.getType() == HitResult.Type.MISS) {
            return;
        }
        UUID uuid = null;
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            uuid = ((EntityHitResult)hitResult).getEntity().getUUID();
        }
        Global.NetHandler.sendToServer(new PingLocationC2SPacket(Config.getChannel(), hitResult.getLocation(), uuid, pingSequence, dimension));
    }

    private static void addOrReplacePing(Ping newPing) {
        int index = -1;
        for (int i = 0; i < pingRepo.size(); ++i) {
            Ping entry = pingRepo.get(i);
            if (!Objects.equals(entry.getAuthor(), newPing.getAuthor()) || entry.getSequence() != newPing.getSequence()) continue;
            index = i;
            break;
        }
        if (index != -1) {
            pingRepo.set(index, newPing);
        } else {
            pingRepo.add(newPing);
        }
    }

    private static Entity getEntity(UUID uuid) {
        if (ClientGlobal.Game.level == null) {
            return null;
        }
        for (Entity entity : ClientGlobal.Game.level.entitiesForRendering()) {
            if (!entity.getUUID().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    private static float getDistanceScale(double distance) {
        double scale = 2.0 / Math.pow(distance, 0.3);
        return (float)Math.max(1.0, scale);
    }
}

