/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.api;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import top.theillusivec4.curios.api.SlotAttribute;

public record CurioAttributeModifiers(List<Entry> modifiers, boolean showInTooltip) {
    public static final CurioAttributeModifiers EMPTY = new CurioAttributeModifiers(List.of(), true);
    private static final Codec<CurioAttributeModifiers> FULL_CODEC = RecordCodecBuilder.create(p_337947_ -> p_337947_.group((App)Entry.CODEC.listOf().fieldOf("modifiers").forGetter(CurioAttributeModifiers::modifiers), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)Boolean.TRUE).forGetter(CurioAttributeModifiers::showInTooltip)).apply((Applicative)p_337947_, CurioAttributeModifiers::new));
    public static final Codec<CurioAttributeModifiers> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)Entry.CODEC.listOf(), p_332621_ -> new CurioAttributeModifiers((List<Entry>)p_332621_, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, CurioAttributeModifiers> STREAM_CODEC = StreamCodec.composite((StreamCodec)Entry.STREAM_CODEC.apply(ByteBufCodecs.list()), CurioAttributeModifiers::modifiers, (StreamCodec)ByteBufCodecs.BOOL, CurioAttributeModifiers::showInTooltip, CurioAttributeModifiers::new);

    public CurioAttributeModifiers withTooltip(boolean showInTooltip) {
        return new CurioAttributeModifiers(this.modifiers, showInTooltip);
    }

    public static Builder builder() {
        return new Builder();
    }

    public CurioAttributeModifiers withModifierAdded(ResourceLocation attribute, AttributeModifier attributeModifier, String slot) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        for (Entry attributemodifiers$entry : this.modifiers) {
            if (attributemodifiers$entry.modifier.id().equals((Object)attributeModifier.id())) continue;
            builder.add((Object)attributemodifiers$entry);
        }
        builder.add((Object)new Entry(attribute, attributeModifier, slot));
        return new CurioAttributeModifiers((List<Entry>)builder.build(), this.showInTooltip);
    }

    public void forEach(String slot, BiConsumer<ResourceLocation, AttributeModifier> consumer) {
        for (Entry attributemodifiers$entry : this.modifiers) {
            if (!attributemodifiers$entry.slot.equals(slot)) continue;
            consumer.accept(attributemodifiers$entry.attribute, attributemodifiers$entry.modifier);
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<Entry> entries = ImmutableList.builder();

        Builder() {
        }

        public Builder add(Holder<Attribute> attribute, AttributeModifier attributeModifier, String slot) {
            ResourceLocation rl;
            Object object = attribute.value();
            if (object instanceof SlotAttribute) {
                SlotAttribute wrapper = (SlotAttribute)((Object)object);
                rl = ResourceLocation.fromNamespaceAndPath((String)"curios", (String)wrapper.getIdentifier());
            } else {
                rl = ResourceLocation.parse((String)attribute.getRegisteredName());
            }
            this.entries.add((Object)new Entry(rl, attributeModifier, slot));
            return this;
        }

        public CurioAttributeModifiers build() {
            return new CurioAttributeModifiers((List<Entry>)this.entries.build(), true);
        }
    }

    public record Entry(ResourceLocation attribute, AttributeModifier modifier, String slot) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("type").forGetter(Entry::attribute), (App)AttributeModifier.MAP_CODEC.forGetter(Entry::modifier), (App)Codec.STRING.optionalFieldOf("slot", (Object)"").forGetter(Entry::slot)).apply((Applicative)instance, Entry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, Entry::attribute, (StreamCodec)AttributeModifier.STREAM_CODEC, Entry::modifier, (StreamCodec)ByteBufCodecs.STRING_UTF8, Entry::slot, Entry::new);
    }
}

