/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.service.hacks;

import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import org.sinytra.connector.util.ConnectorUtil;
import org.slf4j.Logger;

public class ConnectorForkJoinThreadFactory
implements ForkJoinPool.ForkJoinWorkerThreadFactory {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ForkJoinPool.ForkJoinWorkerThreadFactory factory;

    public ConnectorForkJoinThreadFactory(ForkJoinPool.ForkJoinWorkerThreadFactory factory) {
        this.factory = factory;
    }

    @Override
    public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
        ForkJoinWorkerThread thread = this.factory.newThread(pool);
        thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        return thread;
    }

    public static void install() {
        try {
            ConnectorForkJoinThreadFactory factory = new ConnectorForkJoinThreadFactory(ForkJoinPool.defaultForkJoinWorkerThreadFactory);
            MethodHandle handle = ConnectorUtil.TRUSTED_LOOKUP.findStaticSetter(ForkJoinPool.class, "defaultForkJoinWorkerThreadFactory", ForkJoinPool.ForkJoinWorkerThreadFactory.class);
            handle.invoke(factory);
            VarHandle commonHandle = ConnectorUtil.TRUSTED_LOOKUP.findVarHandle(ForkJoinPool.class, "factory", ForkJoinPool.ForkJoinWorkerThreadFactory.class);
            commonHandle.set(ForkJoinPool.commonPool(), factory);
        }
        catch (Throwable t) {
            LOGGER.error("Error injecting default thread pool factory", t);
        }
    }
}

