/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.util;

import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class OpcodeUtil {
    public static final List<Integer> INSN_TYPE_OFFSETS = List.of(Integer.valueOf(7), Integer.valueOf(6), Integer.valueOf(8), Integer.valueOf(10));
    public static final List<Integer> INSN_TYPE_OFFSETS_EXTENDED = List.of(Integer.valueOf(7), Integer.valueOf(6), Integer.valueOf(8), Integer.valueOf(10), Integer.valueOf(0));
    public static final Map<Type, BoxedType> BOXED_TYPES = Map.of(Type.BYTE_TYPE, new BoxedType(Byte.TYPE, Byte.class), Type.CHAR_TYPE, new BoxedType(Character.TYPE, Character.class), Type.BOOLEAN_TYPE, new BoxedType(Boolean.TYPE, Boolean.class), Type.SHORT_TYPE, new BoxedType(Short.TYPE, Short.class), Type.INT_TYPE, new BoxedType(Integer.TYPE, Integer.class), Type.LONG_TYPE, new BoxedType(Long.TYPE, Long.class), Type.FLOAT_TYPE, new BoxedType(Float.TYPE, Float.class), Type.DOUBLE_TYPE, new BoxedType(Double.TYPE, Double.class));

    public static boolean isStoreOpcode(int opcode) {
        return opcode >= 54 && opcode <= 58;
    }

    public static boolean isLoadOpcode(int opcode) {
        return opcode >= 21 && opcode <= 25;
    }

    public static boolean isReturnOpcode(int opcode) {
        return opcode >= 172 && opcode <= 177;
    }

    public static int getLoadOpcode(int sort) {
        return 21 + INSN_TYPE_OFFSETS.indexOf(sort) + 1;
    }

    public static int getStoreOpcode(int sort) {
        return 54 + INSN_TYPE_OFFSETS.indexOf(sort) + 1;
    }

    public static int getReturnOpcode(MethodNode methodNode) {
        return OpcodeUtil.getReturnOpcode(Type.getReturnType((String)methodNode.desc).getSort());
    }

    public static int getReturnOpcode(int sort) {
        return 172 + INSN_TYPE_OFFSETS_EXTENDED.indexOf(sort) + 1;
    }

    public static int getAccessVisibility(int access) {
        return access & 7;
    }

    public static int setAccessVisibility(int access, int visibility) {
        return access & 0xFFFFFFF8 | visibility;
    }

    public record BoxedType(Class<?> primitiveClass, Class<?> boxedClass) {
    }
}

