/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynfix;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.InstructionMatcher;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.adapter.patch.transformer.dynfix.DynamicFixer;
import org.sinytra.adapter.patch.transformer.operation.ModifyInjectionPoint;
import org.sinytra.adapter.patch.transformer.operation.ModifyInjectionTarget;
import org.sinytra.adapter.patch.util.AdapterUtil;

public class DynFixArbitraryInjectionPoint
implements DynamicFixer<Data> {
    private static final Set<String> ACCEPTED_ANNOTATIONS = Set.of("Lorg/spongepowered/asm/mixin/injection/Inject;", "Lorg/spongepowered/asm/mixin/injection/ModifyArg;", "Lcom/llamalad7/mixinextras/injector/ModifyExpressionValue;");

    @Override
    @Nullable
    public Data prepare(MethodContext methodContext) {
        if (methodContext.methodAnnotation().matchesAny(ACCEPTED_ANNOTATIONS)) {
            MethodContext.TargetPair dirtyInjectionTarget = methodContext.findDirtyInjectionTarget();
            if (dirtyInjectionTarget == null) {
                return null;
            }
            MethodContext.TargetPair cleanInjectionTarget = methodContext.findCleanInjectionTarget();
            List<AbstractInsnNode> cleanInsns = methodContext.findInjectionTargetInsns(cleanInjectionTarget);
            if (cleanInsns.size() == 1 && dirtyInjectionTarget != null && methodContext.failsDirtyInjectionCheck()) {
                AbstractInsnNode cleanInjectionInsn = cleanInsns.getFirst();
                return new Data(dirtyInjectionTarget, cleanInjectionInsn);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public DynamicFixer.FixResult apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchAuditTrail auditTrail, Data data) {
        MethodInsnNode targetMethodCall;
        MethodNode dirtyTargetMethod = data.dirtyTarget().methodNode();
        AbstractInsnNode cleanInjectionInsn = data.cleanInjectionInsn();
        AbstractInsnNode nextCallCandidate = DynFixArbitraryInjectionPoint.findCandidates(MethodCallAnalyzer.findBackwardsInstructions(cleanInjectionInsn, 5).inverse(), dirtyTargetMethod, List::getLast);
        if (nextCallCandidate != null) {
            targetMethodCall = DynFixArbitraryInjectionPoint.findReplacementInjectionPoint(nextCallCandidate, AbstractInsnNode::getNext, methodContext);
        } else {
            AbstractInsnNode previousCallCandidate = DynFixArbitraryInjectionPoint.findCandidates(MethodCallAnalyzer.findForwardInstructions(cleanInjectionInsn, 5), dirtyTargetMethod, List::getFirst);
            if (previousCallCandidate != null) {
                targetMethodCall = DynFixArbitraryInjectionPoint.findReplacementInjectionPoint(previousCallCandidate, AbstractInsnNode::getPrevious, methodContext);
            } else {
                return null;
            }
        }
        if (targetMethodCall != null) {
            if (targetMethodCall.owner.equals(data.dirtyTarget().classNode().name) && !methodContext.methodAnnotation().matchesDesc("Lorg/spongepowered/asm/mixin/injection/Inject;")) {
                return DynFixArbitraryInjectionPoint.tryMoveTargetMethod(targetMethodCall, methodContext);
            }
            String newInjectionPoint = Type.getObjectType((String)targetMethodCall.owner).getDescriptor() + targetMethodCall.name + targetMethodCall.desc;
            return DynamicFixer.FixResult.of(new ModifyInjectionPoint("INVOKE", newInjectionPoint, true, false).apply(methodContext), PatchAuditTrail.Match.PARTIAL);
        }
        return null;
    }

    private static DynamicFixer.FixResult tryMoveTargetMethod(MethodInsnNode insn, MethodContext methodContext) {
        String newTarget = insn.name + insn.desc;
        return DynamicFixer.FixResult.of(new ModifyInjectionTarget(List.of(newTarget)).apply(methodContext), PatchAuditTrail.Match.PARTIAL);
    }

    private static AbstractInsnNode findCandidates(InstructionMatcher cleanMatcher, MethodNode dirtyTargetMethod, Function<List<AbstractInsnNode>, AbstractInsnNode> selector) {
        if (cleanMatcher.after().isEmpty()) {
            return null;
        }
        int firstOpcode = cleanMatcher.after().getFirst().getOpcode();
        ArrayList<AbstractInsnNode> candidates = new ArrayList<AbstractInsnNode>();
        for (int i = 0; i < dirtyTargetMethod.instructions.size(); ++i) {
            AbstractInsnNode lastInsn;
            InstructionMatcher dirtyMatcher;
            AbstractInsnNode insn = dirtyTargetMethod.instructions.get(i);
            if (insn instanceof FrameNode || insn instanceof LineNumberNode || insn.getOpcode() != firstOpcode || !cleanMatcher.test(dirtyMatcher = MethodCallAnalyzer.findForwardInstructionsDirect(insn, 5), 1) || (lastInsn = selector.apply(dirtyMatcher.after())) == null) continue;
            candidates.add(lastInsn);
        }
        return !candidates.isEmpty() ? (AbstractInsnNode)candidates.getFirst() : null;
    }

    private static MethodInsnNode findReplacementInjectionPoint(AbstractInsnNode lastInsn, UnaryOperator<AbstractInsnNode> flow, MethodContext methodContext) {
        if (methodContext.methodAnnotation().matchesDesc("Lcom/llamalad7/mixinextras/injector/ModifyExpressionValue;")) {
            Type desiredReturnType = Type.getReturnType((String)methodContext.getInjectionPointMethodQualifier().desc());
            return (MethodInsnNode)AdapterUtil.iterateInsns(lastInsn, flow, v -> {
                if (!(v instanceof MethodInsnNode)) return false;
                MethodInsnNode minsn = (MethodInsnNode)v;
                if (!Type.getReturnType((String)minsn.desc).equals((Object)desiredReturnType)) return false;
                return true;
            });
        }
        return (MethodInsnNode)AdapterUtil.iterateInsns(lastInsn, flow, v -> v instanceof MethodInsnNode);
    }

    public record Data(MethodContext.TargetPair dirtyTarget, AbstractInsnNode cleanInjectionInsn) {
    }
}

